/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.DexIndexOverflowException;
import com.android.dx.command.dexer.Main;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.TypeIdItem;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.Collection;
import java.util.TreeMap;

public final class TypeIdsSection
extends UniformItemSection {
    private final TreeMap<Type, TypeIdItem> typeIds = new TreeMap();

    public TypeIdsSection(DexFile dexFile) {
        super("type_ids", dexFile, 4);
    }

    @Override
    public Collection<? extends Item> items() {
        return this.typeIds.values();
    }

    @Override
    public IndexedItem get(Constant constant) {
        if (constant == null) {
            throw new NullPointerException("cst == null");
        }
        this.throwIfNotPrepared();
        Type type = ((CstType)constant).getClassType();
        IndexedItem indexedItem = this.typeIds.get(type);
        if (indexedItem == null) {
            throw new IllegalArgumentException("not found: " + constant);
        }
        return indexedItem;
    }

    public void writeHeaderPart(AnnotatedOutput annotatedOutput) {
        int n;
        this.throwIfNotPrepared();
        int n2 = this.typeIds.size();
        int n3 = n = n2 == 0 ? 0 : this.getFileOffset();
        if (n2 > 65536) {
            throw new DexIndexOverflowException("Too many type references: " + n2 + "; max is " + 65536 + ".\n" + Main.getTooManyIdsErrorMessage());
        }
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "type_ids_size:   " + Hex.u4(n2));
            annotatedOutput.annotate(4, "type_ids_off:    " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n);
    }

    public TypeIdItem intern(Type type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        this.throwIfPrepared();
        TypeIdItem typeIdItem = this.typeIds.get(type);
        if (typeIdItem == null) {
            typeIdItem = new TypeIdItem(new CstType(type));
            this.typeIds.put(type, typeIdItem);
        }
        return typeIdItem;
    }

    public synchronized TypeIdItem intern(CstType cstType) {
        if (cstType == null) {
            throw new NullPointerException("type == null");
        }
        this.throwIfPrepared();
        Type type = cstType.getClassType();
        TypeIdItem typeIdItem = this.typeIds.get(type);
        if (typeIdItem == null) {
            typeIdItem = new TypeIdItem(cstType);
            this.typeIds.put(type, typeIdItem);
        }
        return typeIdItem;
    }

    public int indexOf(Type type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        this.throwIfNotPrepared();
        TypeIdItem typeIdItem = this.typeIds.get(type);
        if (typeIdItem == null) {
            throw new IllegalArgumentException("not found: " + type);
        }
        return typeIdItem.getIndex();
    }

    public int indexOf(CstType cstType) {
        if (cstType == null) {
            throw new NullPointerException("type == null");
        }
        return this.indexOf(cstType.getClassType());
    }

    @Override
    protected void orderItems() {
        int n = 0;
        for (Item item : this.items()) {
            ((TypeIdItem)item).setIndex(n);
            ++n;
        }
    }
}

