/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.SimpleInsn;
import com.android.dx.dex.code.VariableSizeInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.util.AnnotatedOutput;

public final class HighRegisterPrefix
extends VariableSizeInsn {
    private SimpleInsn[] insns;

    public HighRegisterPrefix(SourcePosition sourcePosition, RegisterSpecList registerSpecList) {
        super(sourcePosition, registerSpecList);
        if (registerSpecList.size() == 0) {
            throw new IllegalArgumentException("registers.size() == 0");
        }
        this.insns = null;
    }

    @Override
    public int codeSize() {
        int n = 0;
        this.calculateInsnsIfNecessary();
        for (SimpleInsn simpleInsn : this.insns) {
            n += simpleInsn.codeSize();
        }
        return n;
    }

    @Override
    public void writeTo(AnnotatedOutput annotatedOutput) {
        this.calculateInsnsIfNecessary();
        for (SimpleInsn simpleInsn : this.insns) {
            simpleInsn.writeTo(annotatedOutput);
        }
    }

    private void calculateInsnsIfNecessary() {
        if (this.insns != null) {
            return;
        }
        RegisterSpecList registerSpecList = this.getRegisters();
        int n = registerSpecList.size();
        this.insns = new SimpleInsn[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec = registerSpecList.get(i);
            this.insns[i] = HighRegisterPrefix.moveInsnFor(registerSpec, n2);
            n2 += registerSpec.getCategory();
        }
    }

    @Override
    public DalvInsn withRegisters(RegisterSpecList registerSpecList) {
        return new HighRegisterPrefix(this.getPosition(), registerSpecList);
    }

    @Override
    protected String argString() {
        return null;
    }

    @Override
    protected String listingString0(boolean bl) {
        RegisterSpecList registerSpecList = this.getRegisters();
        int n = registerSpecList.size();
        StringBuffer stringBuffer = new StringBuffer(100);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec = registerSpecList.get(i);
            SimpleInsn simpleInsn = HighRegisterPrefix.moveInsnFor(registerSpec, n2);
            if (i != 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(simpleInsn.listingString0(bl));
            n2 += registerSpec.getCategory();
        }
        return stringBuffer.toString();
    }

    private static SimpleInsn moveInsnFor(RegisterSpec registerSpec, int n) {
        return DalvInsn.makeMove(SourcePosition.NO_INFO, RegisterSpec.make(n, registerSpec.getType()), registerSpec);
    }
}

