/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.text.Info;
import com.sas.text.InvalidFormatException;
import com.sas.text.SASFormat;
import com.sas.text.TableEntry;
import com.sas.text.ValueFormatDescription;
import com.sas.util.MissingValueRangeSegment;
import com.sas.util.NumericRangeSegment;
import com.sas.util.RangeSegment;
import com.sas.util.StringRangeSegment;
import java.text.Format;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

@SASScope
class ValueEntry
extends TableEntry
implements ValueFormatDescription {
    private boolean notSort = true;
    protected boolean fmt;
    protected String otherLabel;
    protected SASFormat oFormat;
    protected Vector rangeSegments = new Vector();
    protected Vector missingRangeSegments = new Vector();
    private boolean characterFormat;
    protected int width;
    private float fuzzValue = 1.0E-12f;

    protected ValueEntry(String format, String className) {
        super(format, className);
        this.characterFormat = format.charAt(0) == '$';
        this.fmt = false;
        this.otherLabel = null;
        this.oFormat = null;
        this.setMinWidth(1);
        this.setMaxWidth(200);
        this.setDefaultWidth(-1);
        this.width = -1;
    }

    @Override
    public void setNotSorted(boolean trueOrFalse) {
        this.notSort = trueOrFalse;
    }

    @Override
    public boolean isNotSorted() {
        return this.notSort;
    }

    @Override
    public String getBaseFormatName() {
        return this.format;
    }

    @Override
    public void setOtherValue(String value) {
        int length;
        if (value != null && (length = (value = value.trim()).length()) >= 1) {
            this.fmt = false;
            char c = value.charAt(0);
            if (c == '[') {
                if (value.charAt(length - 1) == ']') {
                    this.otherLabel = value.substring(1, length - 1);
                    this.fmt = true;
                } else {
                    this.otherLabel = value;
                }
            } else {
                this.otherLabel = c == '\'' ? (value.charAt(length - 1) == '\'' ? value.substring(1, length - 1) : value) : value;
            }
        }
    }

    @Override
    public boolean addRangeSegment(RangeSegment rs) {
        boolean result = true;
        if (rs instanceof MissingValueRangeSegment) {
            this.missingRangeSegments.addElement(rs);
        } else if (!this.characterFormat && rs instanceof NumericRangeSegment) {
            this.rangeSegments.addElement(rs);
        } else if (this.characterFormat && rs instanceof StringRangeSegment) {
            this.rangeSegments.addElement(rs);
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isCharacterFormat() {
        return this.characterFormat;
    }

    @Override
    public String getOtherValue(Object value) {
        String result = this.fmt ? this.oFormat.format(value) : this.otherLabel;
        return result;
    }

    @Override
    public void setWidth(int formatWidth) {
        this.width = formatWidth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public String getValue(Object value) {
        Object obj;
        String result = null;
        RangeSegment segment = this.getRangeSegment(value);
        result = segment != null ? ((obj = segment.getValue(value)) instanceof Format ? ((Format)obj).format(value) : obj.toString()) : (this.rangeSegments != null && this.rangeSegments.size() > 0 && this.rangeSegments.get(0) instanceof NumericRangeSegment && (double)this.fuzzValue != 0.0 ? ((segment = this.getRangeSegmentByFuzz(value, this.fuzzValue)) != null ? ((obj = segment.getValue(value)) instanceof Format ? ((Format)obj).format(value) : obj.toString()) : this.getOtherValue(value)) : this.getOtherValue(value));
        return result;
    }

    @Override
    public RangeSegment getRangeSegment(Object value) {
        RangeSegment result = null;
        Vector temp = value instanceof MissingValues ? this.missingRangeSegments : this.rangeSegments;
        int numOfRanges = temp.size();
        for (int i = 0; i < numOfRanges; ++i) {
            RangeSegment e = (RangeSegment)temp.elementAt(i);
            if (e.inRange(value) != 0) continue;
            result = e;
            break;
        }
        return result;
    }

    protected void init() {
        this.init(null);
    }

    @Override
    public void init(Hashtable table) {
        RangeSegment entry;
        Vector<RangeSegment> sort = new Vector<RangeSegment>();
        int length = -1;
        int dWidth = 1;
        Enumeration elts = this.rangeSegments.elements();
        while (elts.hasMoreElements()) {
            entry = (RangeSegment)elts.nextElement();
            length = this.parseValue(entry, table);
            dWidth = Math.max(dWidth, length);
            if (this.notSort) continue;
            boolean inserted = false;
            for (int i = sort.size() - 1; i >= 0 && !inserted; --i) {
                RangeSegment e;
                if (!this.characterFormat) {
                    NumericRangeSegment nrs = (NumericRangeSegment)sort.elementAt(i);
                    e = (NumericRangeSegment)entry;
                    if (!(((NumericRangeSegment)e).getMin() > nrs.getMin())) continue;
                    if (((NumericRangeSegment)e).getMax() < nrs.getMax()) {
                        throw new RuntimeException("ERROR: These two ranges overlap:");
                    }
                    if (((NumericRangeSegment)e).getMax() == nrs.getMax()) {
                        e.setMinExclude(true);
                    }
                    inserted = true;
                    sort.insertElementAt(entry, i + 1);
                    continue;
                }
                StringRangeSegment srs = (StringRangeSegment)sort.elementAt(i);
                e = (StringRangeSegment)entry;
                int scp = ((StringRangeSegment)e).getMin().compareTo(srs.getMin());
                int ecp = ((StringRangeSegment)e).getMax().compareTo(srs.getMax());
                if (scp <= 0) continue;
                if (ecp < 0) {
                    throw new RuntimeException("ERROR: These two ranges overlap:");
                }
                if (ecp == 0) {
                    e.setMinExclude(true);
                }
                inserted = true;
                sort.insertElementAt(entry, i + 1);
            }
            if (inserted) continue;
            sort.insertElementAt(entry, 0);
        }
        if (!this.notSort) {
            this.rangeSegments = sort;
        }
        elts = this.missingRangeSegments.elements();
        while (elts.hasMoreElements()) {
            entry = (RangeSegment)elts.nextElement();
            dWidth = Math.max(dWidth, this.parseValue(entry, table));
        }
        if (this.otherLabel != null) {
            if (this.fmt) {
                this.oFormat = this.getFormat(this.otherLabel, table);
                dWidth = this.oFormat != null ? Math.max(dWidth, this.oFormat.formatInfo.getWidth()) : Math.max(dWidth, this.otherLabel.length());
            } else {
                dWidth = Math.max(dWidth, this.otherLabel.length());
            }
        }
        if (this.getDefaultWidth() == -1) {
            this.setDefaultWidth(dWidth);
        }
        dWidth = this.getDefaultWidth();
        if (this.minWidth < 1 || this.minWidth > 200) {
            System.err.println("ERROR: The parameter value " + this.minWidth + " is not within the required range of 1 and 200. Using default min width of 1");
            this.minWidth = 1;
        }
        if (this.maxWidth < 1 || this.maxWidth > 200) {
            System.err.println("ERROR: The parameter value " + this.maxWidth + " is not within the required range of 1 and 200. Using default max width of 200");
            this.maxWidth = 200;
        }
        if (dWidth < this.minWidth) {
            this.minWidth = dWidth;
        } else if (dWidth > this.maxWidth) {
            this.maxWidth = dWidth;
        }
        if (this.minWidth > this.maxWidth) {
            System.err.println("NOTE: MIN value of " + this.minWidth + " greater than MAX value of " + this.maxWidth + " . Both values will be ignored.");
            this.minWidth = 1;
            this.maxWidth = 200;
        }
        int n = this.width = this.width != -1 ? this.width : this.getDefaultWidth();
        if (this.fmt && this.oFormat == null) {
            this.oFormat = this.getDefaultFormat(dWidth);
            System.err.println("WARN: format " + this.otherLabel + " could not be instantiated.\nFormat " + this.oFormat.getBaseFormatName() + " to be used");
        } else if (this.otherLabel == null) {
            this.fmt = true;
            this.oFormat = this.getDefaultFormat(dWidth);
        }
    }

    private SASFormat getDefaultFormat(int defaultWidth) {
        int oWidth;
        SASFormat result = null;
        int n = this.width != -1 ? this.width : (oWidth = this.getDefaultWidth() != -1 ? this.getDefaultWidth() : defaultWidth);
        if (this.characterFormat) {
            result = SASFormat.getInstance("$" + oWidth);
        } else {
            int tempWidth = oWidth;
            if (tempWidth > 32) {
                tempWidth = 32;
            }
            result = SASFormat.getInstance("BEST" + tempWidth);
        }
        return result;
    }

    protected int parseValue(RangeSegment segment, Hashtable table) {
        String value;
        int length = 0;
        if (segment.getValue(null) instanceof String && (length = (value = ((String)segment.getValue(null)).trim()).length()) >= 1) {
            char c = value.charAt(0);
            if (c == '[') {
                if (value.charAt(length - 1) == ']') {
                    SASFormat format = this.getFormat(value.substring(1, length - 1), table);
                    length = format.formatInfo.getWidth();
                    segment.setValue(format);
                }
            } else if (c == '\'' && value.charAt(length - 1) == '\'') {
                String label = value.substring(1, length - 1);
                length = label.length();
                segment.setValue(label);
            }
        }
        return length;
    }

    private SASFormat getFormat(String sFormat, Hashtable table) {
        TableEntry entry;
        int decimalWidth;
        String[] pf = SASFormat.parseFormat(sFormat.trim().toUpperCase());
        String baseFormat = pf[0] == null ? String.valueOf(' ') : pf[0];
        int width = pf[1] == null ? -1 : Integer.parseInt(pf[1], 10);
        int n = decimalWidth = pf[2] == null ? 0 : Integer.parseInt(pf[2], 10);
        if (decimalWidth != 0 && decimalWidth >= width) {
            decimalWidth = width - 1;
        }
        if (table != null && (entry = (TableEntry)table.get(baseFormat)) != null) {
            try {
                Class<?> temp = Class.forName(entry.getClassName());
                SASFormat format = (SASFormat)temp.newInstance();
                format.locale = Locale.getDefault();
                format.formatInfo = new Info(entry, baseFormat, width);
                format.init();
                return format;
            }
            catch (InvalidFormatException ife) {
                return null;
            }
            catch (Exception cnfe) {
                return null;
            }
        }
        return SASFormat.getInstance(baseFormat, width, decimalWidth, Locale.getDefault());
    }

    @Override
    public boolean isDecimalWidthSupported() {
        return false;
    }

    @Override
    public int getMinDValue() {
        return -1;
    }

    @Override
    public int getMaxDValue() {
        return -1;
    }

    public void setFuzzValue(float fuzzConstant) {
        this.fuzzValue = fuzzConstant;
    }

    public RangeSegment getRangeSegmentByFuzz(Object value, double fuzzConstant) {
        RangeSegment result = null;
        Vector temp = value instanceof MissingValues ? this.missingRangeSegments : this.rangeSegments;
        int numOfRanges = temp.size();
        int range = 0;
        for (int i = 0; i < numOfRanges - 1; ++i) {
            RangeSegment rangeSegmentNext;
            RangeSegment rangeSegment = (RangeSegment)temp.elementAt(i);
            range = this.isInRange(value, fuzzConstant, rangeSegment, rangeSegmentNext = (RangeSegment)temp.elementAt(i + 1));
            if (range == -1) continue;
            if (range == 0) {
                result = rangeSegment;
                break;
            }
            if (range == -2) break;
            result = rangeSegmentNext;
            break;
        }
        if (range == -1) {
            NumericRangeSegment numericRangeSegment = (NumericRangeSegment)temp.lastElement();
            double userValue = (Double)value;
            if (userValue > numericRangeSegment.getMax() && userValue - fuzzConstant >= numericRangeSegment.getMin() && userValue - fuzzConstant <= numericRangeSegment.getMax()) {
                return numericRangeSegment;
            }
        }
        return result;
    }

    public int isInRange(Object value, double fuzzConstant, RangeSegment rs, RangeSegment rsNext) {
        NumericRangeSegment numericRangeSegment = (NumericRangeSegment)rs;
        NumericRangeSegment numericRangeSegmentNext = (NumericRangeSegment)rsNext;
        int result = -1;
        double userValue = (Double)value;
        if (userValue < numericRangeSegment.getMin() && userValue + fuzzConstant < numericRangeSegment.getMin()) {
            return -2;
        }
        if (userValue < numericRangeSegment.getMin() && userValue + fuzzConstant >= numericRangeSegment.getMin() && userValue + fuzzConstant <= numericRangeSegment.getMax()) {
            return 0;
        }
        if (userValue > numericRangeSegment.getMax() && userValue < numericRangeSegmentNext.getMin()) {
            if (userValue + fuzzConstant >= numericRangeSegmentNext.getMin() && userValue + fuzzConstant <= numericRangeSegmentNext.getMax()) {
                return 1;
            }
            if (userValue - fuzzConstant >= numericRangeSegment.getMin() && userValue - fuzzConstant <= numericRangeSegment.getMax()) {
                return 0;
            }
        }
        return result;
    }
}

