/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SASURI;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.LoadBalancingCluster;
import com.sas.services.connection.Server;
import java.io.Serializable;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class Cluster
implements Cloneable,
Serializable {
    public static final int TYPE_LOAD_BALANCING = 0;
    public static final int TYPE_FAILOVER = 1;
    private static final long serialVersionUID = -8799220558539020978L;
    private Server[] _serverArr;
    private String _classID;
    private String _domain;
    private int _maxClients;
    private boolean _securityPackageAllowed;
    private String _authService;

    public static Cluster getInstance(Server[] servers, int clusterType) {
        if (clusterType == 1) {
            return new FailoverCluster(servers);
        }
        if (clusterType == 0) {
            return new LoadBalancingCluster(servers);
        }
        throw new IllegalArgumentException("\"clusterType\" must be either TYPE_FAILOVER or TYPE_LOAD_BALANCING.");
    }

    protected Cluster(Server[] serverArray) {
        this.setServerArray(serverArray);
    }

    public void setServerArray(Server[] serverArray) {
        if (serverArray == null || serverArray.length == 0) {
            throw new IllegalArgumentException("\"serverArray\" cannot be null or empty.");
        }
        for (int i = 0; i < serverArray.length; ++i) {
            if (serverArray[i] != null) continue;
            throw new IllegalArgumentException("Element " + i + " of \"serverArray\" cannot be null.");
        }
        this._serverArr = serverArray;
        this.init();
    }

    public Server[] getServerArray() {
        return this._serverArr;
    }

    public abstract int getClusterType();

    public String getClassID() {
        return this._classID;
    }

    public String getDomain() {
        return this._domain;
    }

    public int getMaxClients() {
        return this._maxClients;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        Cluster thatCluster = (Cluster)that;
        Server[] thoseServers = thatCluster.getServerArray();
        if (this._serverArr.length != thoseServers.length) {
            return false;
        }
        for (int i = 0; i < this._serverArr.length; ++i) {
            if (this._serverArr[i].equals(thoseServers[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = this.getClass().getName().hashCode();
        for (int i = 0; i < this._serverArr.length; ++i) {
            hc ^= this._serverArr[i].hashCode();
        }
        return hc;
    }

    public Object clone() {
        Cluster cluster = null;
        try {
            cluster = (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("A Cloneable object threw CloneNotSupportedException.");
        }
        Server[] serverArray = cluster.getServerArray();
        serverArray = ConnectionFactoryUtil.copyServerArray(serverArray);
        cluster.setServerArray(serverArray);
        return cluster;
    }

    public String toString() {
        String[][] snvPairArr = new String[this._serverArr.length][2];
        for (int i = 0; i < this._serverArr.length; ++i) {
            Server server = this._serverArr[i];
            snvPairArr[i][0] = "s" + i;
            snvPairArr[i][1] = server.toString();
        }
        String[][] nvPairArr = new String[2][2];
        nvPairArr[0][0] = "servers";
        nvPairArr[0][1] = ConnectionFactoryUtil.nvPairsToString(snvPairArr);
        nvPairArr[1][0] = "type";
        nvPairArr[1][1] = this.getClusterType() == 1 ? "FAILOVER" : "LOAD_BALANCING";
        String str = ConnectionFactoryUtil.nvPairsToString(nvPairArr);
        return str;
    }

    protected abstract int computeMaxClients();

    @SASScope
    protected boolean isSecurityPackageAllowed() {
        return this._securityPackageAllowed;
    }

    @SASScope
    protected String getAuthService() {
        return this._authService;
    }

    @SASScope
    protected String getEntryPoint() {
        int bufL = SASURI.lParenL + SASURI.rParenL;
        for (int i = 0; i < this._serverArr.length; ++i) {
            Server server = this._serverArr[i];
            String serverEntryPoint = server.getEntryPoint();
            int serverEntryPointL = serverEntryPoint.length();
            bufL += serverEntryPointL;
            bufL += SASURI.commaL;
        }
        StringBuffer buf = new StringBuffer(bufL);
        buf.append("(");
        for (int i = 0; i < this._serverArr.length; ++i) {
            Server server = this._serverArr[i];
            String serverEntryPoint = server.getEntryPoint();
            buf.append(serverEntryPoint);
            buf.append(",");
        }
        int curBufL = buf.length();
        int newBufL = curBufL - 1;
        buf.setLength(newBufL);
        buf.append(")");
        String clusterEntryPoint = buf.toString();
        return clusterEntryPoint;
    }

    private void init() {
        int i;
        int i2;
        this._maxClients = this.computeMaxClients();
        this._domain = this._serverArr[0].getDomain();
        for (i2 = 1; i2 < this._serverArr.length; ++i2) {
            if (this._domain.equals(this._serverArr[i2].getDomain())) continue;
            StringBuffer msgBuffer = new StringBuffer("All servers in a cluster must have the same domain. ");
            msgBuffer.append("Server 0 has domain \"").append(this._domain).append("\", but server ");
            msgBuffer.append(i2).append(" has domain \"").append(this._serverArr[i2].getDomain()).append("\".");
            throw new IllegalArgumentException(msgBuffer.toString());
        }
        this._classID = this._serverArr[0].getNormalizedClassID();
        for (i2 = 1; i2 < this._serverArr.length; ++i2) {
            if (this._classID.equals(this._serverArr[i2].getNormalizedClassID())) continue;
            StringBuffer msgBuffer = new StringBuffer("All servers in a cluster must have the same class ID. ");
            msgBuffer.append("Server 0 has class ID \"").append(this._classID).append("\", but server ");
            msgBuffer.append(i2).append(" has classID \"").append(this._serverArr[i2].getClassID()).append("\".");
            throw new IllegalArgumentException(msgBuffer.toString());
        }
        boolean securityPackageAllowed = this._serverArr[0].isSecurityPackageAllowed();
        for (i = 1; i < this._serverArr.length; ++i) {
            securityPackageAllowed &= this._serverArr[i].isSecurityPackageAllowed();
        }
        this._securityPackageAllowed = securityPackageAllowed;
        this._authService = this._serverArr[0].getAuthService();
        for (i = 1; i < this._serverArr.length; ++i) {
            if (this._authService.equals(this._serverArr[i].getAuthService())) continue;
            StringBuffer msgBuffer = new StringBuffer("All servers in a cluster must have the same authentication service. ");
            msgBuffer.append("Server 0 has authentication service \"").append(this._authService).append("\", but server ");
            msgBuffer.append(i).append(" has authentication service \"").append(this._serverArr[i].getAuthService()).append("\".");
            throw new IllegalArgumentException(msgBuffer.toString());
        }
    }
}

