# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.util
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..lang.locale import Locale as Locale_70d308fa
from .search_algorithms import SearchAlgorithms as SearchAlgorithms_e2c00d36


class SearchOptions(object):
    """
    Struct Class


    See Also:
        `API SearchOptions <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1util_1_1SearchOptions.html>`_
    """
    typeName: Literal['com.sun.star.util.SearchOptions']

    def __init__(self, algorithmType: typing.Optional[SearchAlgorithms_e2c00d36] = ..., searchFlag: typing.Optional[int] = ..., searchString: typing.Optional[str] = ..., replaceString: typing.Optional[str] = ..., Locale: typing.Optional[Locale_70d308fa] = ..., changedChars: typing.Optional[int] = ..., deletedChars: typing.Optional[int] = ..., insertedChars: typing.Optional[int] = ..., transliterateFlags: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            algorithmType (SearchAlgorithms, optional): algorithmType value.
            searchFlag (int, optional): searchFlag value.
            searchString (str, optional): searchString value.
            replaceString (str, optional): replaceString value.
            Locale (Locale, optional): Locale value.
            changedChars (int, optional): changedChars value.
            deletedChars (int, optional): deletedChars value.
            insertedChars (int, optional): insertedChars value.
            transliterateFlags (int, optional): transliterateFlags value.
        """


    @property
    def algorithmType(self) -> SearchAlgorithms_e2c00d36:
        """
        search type
        """


    @property
    def searchFlag(self) -> int:
        """
        some flags - can be mixed
        """


    @property
    def searchString(self) -> str:
        """
        The text or pattern to be searched.
        """


    @property
    def replaceString(self) -> str:
        """
        The replacement text (is for optional replacing - SearchOption is only the data container for it)
        """


    @property
    def Locale(self) -> Locale_70d308fa:
        """
        The locale for case insensitive search.
        """


    @property
    def changedChars(self) -> int:
        """
        This many characters can be different (as a replacement) between the found word and the search pattern in a \"Weighted Levenshtein
        Distance\" search.
        """


    @property
    def deletedChars(self) -> int:
        """
        This many characters can be missing in the found word in a \"Weighted Levenshtein Distance\" search.
        """


    @property
    def insertedChars(self) -> int:
        """
        This many characters can be additional in the found word in a \"Weighted Levenshtein Distance\" search.
        """


    @property
    def transliterateFlags(self) -> int:
        """
        Flags for the transliteration.
        
        Same meaning as the enum of com.sun.star.i18n.TransliterationModules
        """


