# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.text
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..beans.property_values import PropertyValues as PropertyValues_d6470ce6
    from .x_text_content import XTextContent as XTextContent_b16e0ba5
    from .x_text_range import XTextRange as XTextRange_9a910ab7
    from .x_text_table import XTextTable as XTextTable_9a810ab2

class XTextConvert(XInterface_8f010a43):
    """
    allows converting selections of text to frames or tables.

    See Also:
        `API XTextConvert <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1text_1_1XTextConvert.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.text.XTextConvert']

    def convertToTable(self, TableRanges: 'typing.Tuple[object, ...]', CellProperties: 'typing.Tuple[typing.Tuple[PropertyValues_d6470ce6, ...], ...]', RowProperties: 'typing.Tuple[PropertyValues_d6470ce6, ...]', TableProperties: 'PropertyValues_d6470ce6') -> 'XTextTable_9a810ab2':
        """
        converts the paragraphs marked in TableRanges into a table.
        
        The inner sequence contains the start and end paragraphs of each table cell. The next sequence groups the cells to a row and the outer sequence groups the rows of the table.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.beans.UnknownPropertyException: ``UnknownPropertyException``
        """
    def convertToTextFrame(self, Start: 'XTextRange_9a910ab7', End: 'XTextRange_9a910ab7', FrameProperties: 'PropertyValues_d6470ce6') -> 'XTextContent_b16e0ba5':
        """
        moves the paragraphs from Start to End into a text frame.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.beans.UnknownPropertyException: ``UnknownPropertyException``
            com.sun.star.beans.PropertyVetoException: ``PropertyVetoException``
        """

