# Story

## The Opportunity

[Web scraping](https://en.wikipedia.org/wiki/Web_scraping) for content acquisition
and [business process automation](https://en.wikipedia.org/wiki/Business_process_automation)
is a key enabler for many thriving businesses.
For example, [this](https://medium.com/datadriveninvestor/web-scraping-and-hedge-funds-alternative-data-strategy-4ab5b3e6dcc6)
article expaoins how *the average investment firm is spending about $900,000 yearly on alternative data*.
But writing and maintaining spiders is hard and while
there are [lots of screen scraping utilities](other_screen_screen_scapers.md)
available, these utilities tend to solve only a piece of the overall problem.
There is a distinct lack of an operationally complete and enterprise ready
web scraping solution which:

1. makes it easy to author spiders that are robust enough to survive
   most types of web site change
1. provides an infrastructure that makes it easy to discover and run spiders
   through a well defined (RESTful) API
1. detects spider failure and gathers enough evidence on failure details
   that debugging spider failure is easy

Further complicating this overall challenge is that while web scraping
might be a key enabler for a business, web scraping isn't typically something
most companies want to become experts in. Far too many companies are working
far too hard on solving the web scraping problem instead of offloading/outsourcing this
responsibility to a **WS**craping **a**s **a** **S**ervice (WSaaS) offering.

## Spider Writing is Hard?

Why is it so hard to write a spider?
When someone uses a web browser to surf the web, the web browser
generates network traffic to interact with a web server.
Traditional spiders are written to mimic the network traffic
generated by a web browser as a result of someone interacting with the web browser.
However, it’s hard to write these kinds of spiders and it’s getting much
harder as web sites increasingly leverage [AJAX-like](https://en.wikipedia.org/wiki/Ajax_(programming)) patterns.
In addition, this approach to spider writing creates spiders that are very brittle -
even minor web site changes can cause spiders to break
in ways that are hard to debug.

## Trends

There are some very important trends which can be leveraged to realize
our spidering dreams.

### Automated Testing Trends

The wide spread adoption of automated testing has fueled some important trends/milestones:

1. web sites are being built to be tested using automated mechanisms
1. automated testing tools have become very robust
   - [Chrome supporting headless mode](https://developers.google.com/web/updates/2017/04/headless-chrome)
   - [Chrome's DevTools Protocol](https://chromedevtools.github.io/devtools-protocol/)
   - [ChromeDriver using the DevTools Protocol to implement WebDriver protocol](https://sites.google.com/a/chromium.org/chromedriver/)
   - [standardization of WebDriver protocol](https://w3c.github.io/webdriver/webdriver-spec.html)
   - [Python binding of the WebDriver protocol](https://seleniumhq.github.io/selenium/docs/api/py/index.html))
1. lots of "QA automation" companies are very familiar with Selenium WebDriver

### IaaS Trends

1. the number of IaaS providers continues to increase
1. IaaS costs continue to drop
1. an increasing number of very capable CI services are available
1. efficiently running and isolating a variety of workload types
   on an IaaS offering at scale has become easier with [Docker](https://www.docker.com/)
   and [Kubernetes](https://kubernetes.io/)

1. something about organizational adoption of aaS offerings

## The Cloudfeaster Approach

Write spiders using a high level scripting language (Python)
using tools/APIs designed for automated testing ([Selenium](http://www.seleniumhq.org/)).
Package collections of spiders in a [Docker](https://www.docker.com/) image.
This means:

1. spiders are easy to write
1. spiders are reliable even in the face of most web site changes
1. it's possible to outsource spider development and maintenance

Use a RESTful API for discovering and running spiders.
The service implementing the RESTful API is hosted on an IaaS provider.
To run a spider, the service locates the [Docker](https://www.docker.com/) image
containing the spider, makes sure the latest version of the [Docker](https://www.docker.com/) image
is available and uses the latest [Docker](https://www.docker.com/) image to
create a [Docker](https://www.docker.com/) container in which the spider is run.
Inside the [Docker](https://www.docker.com/) container a headless browser
is started and the spider runs against that headless browser.
Use [Kubernetes](https://kubernetes.io/) for all orchestration and operation
of [Docker](https://www.docker.com/) containers to both run the service
behind the RESTful API and run the spiders .
