import re
from typing import Any, Dict, List, Union

from tree_sitter import Node

from src.utils.parser.language_parser import traverse_type


def check_node_error(node: Node) -> bool:
    """
    Check if node contains "ERROR" node
    Args:
        node (tree_sitter.Node): node
    
    Return:
        bool
    """
    if not isinstance(node, Node):
        raise ValueError("Expect type tree_sitter.Node, get %i", type(node))

    error_node = []        
    traverse_type(node, error_node, ['ERROR'])
    if len(error_node) > 0:
        return True
    else:
        return False


def get_node_length(node: Node) -> int:
    """
    Get node length
    Args:
        node (tree_sitter.Node): node
        
    Return:
        int
    """
    if not isinstance(node, Node):
        raise ValueError("Expect type tree_sitter.Node, get %i", type(node))

    line_start = node.start_point[0]
    line_end = node.end_point[0]
    return int(line_end - line_start)
    
    
def remove_tag(input: str) -> str:
    pass


def remove_special_character(input: str) -> str:
    pass


def remove_url(input: str) -> str:
    pass


def extract_documentation(docstring: str, args_metadata: Union[Dict, List]) -> Dict[str, Any]:
    pass


def check_black_node(node_name: str, exclude_list: List = None):
    """
    Check if node belongs to black list
        - Built-in function
        - Test function, test class
        - Constructor
    """
    black_keywords = ['test_', 'Test_', 'toString', 'constructor', 'Constructor']
    black_keywords.extend(exclude_list)
    
    if not isinstance(node_name, str):
        raise ValueError(f'Expect str, get {type(node_name)}')
    if node_name.startswith('__') and node_name.endswith('__'):
        return True
    if node_name.startswith('set') or node_name.startswith('get'):
        return True
    if any(keyword in node_name for keyword in black_keywords):
        return True
    
    return False


def check_function_empty(node):
    # for child in node.children:
    #     if child.type == 'block':
    #         for item in child.children:
    #             if item.type == 'comment' or (item.type == 'expression_statement' and item.children[0].type == 'string'):
    #                 continue
    #             elif item.type != 'pass_statement' and item.type != 'raise_statement':
    #                 return False
    return False


def check_docstring_length(docstring: str):
    pass


def check_docstring_literal(docstring: str):
    pass


def check_docstring_contain_question(docstring: str):
    pass


def check_docstring_underdevelopment(docstring: str):
    pass


def check_docstring_autogenerated(docstriing: str):
    pass


def check_function(node, node_metadata: Dict[str, Any], exclude_list: List = None, is_class=False):
    """
    Check function if
        - is built-in function (python)
        - is constructor
        - is empty 
        - is error node
        - have length < 3 lines
    
    Args:
        node (tree_sitter.Node): function node
        exclude_list (List): exclude name of function
    Return:
        bool: pass the check or not
    """
    node_identifier = node_metadata['identifier']
    if check_node_error(node):
        return False
    if get_node_length(node) <= 3:
        return False
    if check_black_node(node_identifier, exclude_list):
        return False

    # TODO: check empty
    if check_function_empty(node):
        return False
    
    return True


def check_docstring(docstring: str):
    """
    """
    return True
