"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = void 0;
const base_1 = require("./base");
const k8s = require("./imports/k8s");
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _a;
        super(scope, id, { metadata: props.metadata });
        this.stringData = (_a = props.stringData) !== null && _a !== void 0 ? _a : {};
        this.apiObject = new k8s.Secret(this, 'Secret', {
            metadata: props.metadata,
            stringData: this.stringData,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     * @param name The name of the secret to reference.
     */
    static fromSecretName(name) {
        return { name };
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
//# sourceMappingURL=data:application/json;base64,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