"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Probe = void 0;
/**
 * Probe describes a health check to be performed against a container to
 * determine whether it is alive or ready to receive traffic.
 */
class Probe {
    /**
     * Defines a probe based on an HTTP GET request to the IP address of the container.
     *
     * @param path The URL path to hit
     * @param options Options
     */
    static fromHttpGet(path, options = {}) {
        return {
            _toKube(container) {
                var _a, _b;
                return {
                    ...parseProbeOptions(options),
                    httpGet: {
                        path,
                        port: (_b = (_a = options.port) !== null && _a !== void 0 ? _a : container.port) !== null && _b !== void 0 ? _b : 80,
                    },
                };
            },
        };
    }
    /**
     * Defines a probe based on a command which is executed within the container.
     *
     * @param command The command to execute
     * @param options Options
     */
    static fromCommand(command, options = {}) {
        return {
            _toKube: _ => ({
                ...parseProbeOptions(options),
                exec: { command },
            }),
        };
    }
}
exports.Probe = Probe;
function parseProbeOptions(options = {}) {
    var _a;
    return {
        failureThreshold: (_a = options.failureThreshold) !== null && _a !== void 0 ? _a : 3,
        initialDelaySeconds: options.initialDelaySeconds ? options.initialDelaySeconds.toSeconds() : undefined,
        periodSeconds: options.periodSeconds ? options.periodSeconds.toSeconds() : undefined,
        successThreshold: options.successThreshold,
        timeoutSeconds: options.timeoutSeconds ? options.timeoutSeconds.toSeconds() : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,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