"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const appscaling = require("@aws-cdk/aws-applicationautoscaling");
const cdk = require("@aws-cdk/core");
const lambda = require("../lib");
/**
* Stack verification steps:
* aws application-autoscaling describe-scalable-targets --service-namespace lambda --resource-ids function:<function name>:prod
* has a minCapacity of 3 and maxCapacity of 50
*/
class TestStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new lambda.Function(this, 'MyLambda', {
            code: new lambda.InlineCode('exports.handler = async () => {\nconsole.log(\'hello world\');\n};'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_10_X,
        });
        const version = fn.addVersion('1', undefined, 'integ-test');
        const alias = new lambda.Alias(this, 'Alias', {
            aliasName: 'prod',
            version,
        });
        const scalingTarget = alias.addAutoScaling({ minCapacity: 3, maxCapacity: 50 });
        scalingTarget.scaleOnUtilization({
            utilizationTarget: 0.5,
        });
        scalingTarget.scaleOnSchedule('ScaleUpInTheMorning', {
            schedule: appscaling.Schedule.cron({ hour: '8', minute: '0' }),
            minCapacity: 20,
        });
        scalingTarget.scaleOnSchedule('ScaleDownAtNight', {
            schedule: appscaling.Schedule.cron({ hour: '20', minute: '0' }),
            maxCapacity: 20,
        });
        new cdk.CfnOutput(this, 'FunctionName', {
            value: fn.functionName,
        });
    }
}
const app = new cdk.App();
new TestStack(app, 'aws-lambda-autoscaling');
app.synth();
//# sourceMappingURL=data:application/json;base64,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