# pattern_feedback_tool

Design Pattern Feedback Tool

## Installation

This package is built only for playing [the DesignPatternsAdventure/game][dpa_game_link]

For developers working on `game` there are hidden `doit` tasks to help with development:

```sh
poetry run doit --continue _format _test _check _check_types _update _build_diagrams
```

## Usage

See [the README of the game][dpa_game_link], which utilizes `pft`'s `doit` tasks, such as `doit check` or `doit build_diagrams`.

See [tests] for example code and output.

## Project Status

See the `Open Issues` and/or the [CODE_TAG_SUMMARY]. For release history, see the [CHANGELOG].

## Contributing

We welcome pull requests! For your pull request to be accepted smoothly, we suggest that you first open a GitHub issue to discuss your idea. For resources on getting started with the code base, see the below documentation:

- [DEVELOPER_GUIDE]
- [STYLE_GUIDE]
- [CONTRIBUTING]

## Code of Conduct

We follow the [Contributor Covenant Code of Conduct][contributor-covenant].

## Responsible Disclosure

If you have any security issue to report, please contact the project maintainers privately. You can reach us at [dev.act.kyle@gmail.com](mailto:dev.act.kyle@gmail.com).

## License

[LICENSE]

[changelog]: ./docs/CHANGELOG.md
[code_tag_summary]: ./docs/CODE_TAG_SUMMARY.md
[contributing]: ./docs/CONTRIBUTING.md
[contributor-covenant]: https://www.contributor-covenant.org
[developer_guide]: ./docs/DEVELOPER_GUIDE.md
[dpa_game_link]: https://github.com/DesignPatternsAdventure/community-rpg
[license]: https://github.com/DesignPatternsAdventure/pattern_feedback_tool/LICENSE
[style_guide]: ./docs/STYLE_GUIDE.md
[tests]: https://github.com/DesignPatternsAdventure/pattern_feedback_tool/tests
