# avh-api-async
REST API to manage your virtual devices.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.9.0-13085
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import avh_api_async
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import avh_api_async
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import avh_api_async
from avh_api_async.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://app.avh.arm.com/api
# See configuration.py for a list of all supported configuration parameters.
configuration = avh_api_async.Configuration(
    host = "https://app.avh.arm.com/api"
)



# Enter a context with an instance of the API client
with avh_api_async.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = avh_api_async.ArmApi(api_client)
    api_token = {
  "apiToken": "<token>"
} # ApiToken | Authorization Data

    try:
        # Log In
        api_response = api_instance.v1_auth_login(api_token)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ArmApi->v1_auth_login: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://app.avh.arm.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArmApi* | [**v1_auth_login**](docs/ArmApi.md#v1_auth_login) | **POST** /v1/auth/login | Log In
*ArmApi* | [**v1_create_image**](docs/ArmApi.md#v1_create_image) | **POST** /v1/images | Create a new Image
*ArmApi* | [**v1_create_instance**](docs/ArmApi.md#v1_create_instance) | **POST** /v1/instances | Create Instance
*ArmApi* | [**v1_create_snapshot**](docs/ArmApi.md#v1_create_snapshot) | **POST** /v1/instances/{instanceId}/snapshots | Create Instance Snapshot
*ArmApi* | [**v1_delete_image**](docs/ArmApi.md#v1_delete_image) | **DELETE** /v2/images/{imageId} | Delete Image
*ArmApi* | [**v1_delete_instance**](docs/ArmApi.md#v1_delete_instance) | **DELETE** /v1/instances/{instanceId} | Remove Instance
*ArmApi* | [**v1_get_image**](docs/ArmApi.md#v1_get_image) | **GET** /v1/images/{imageId} | Get Image Metadata
*ArmApi* | [**v1_get_images**](docs/ArmApi.md#v1_get_images) | **GET** /v1/images | Get all Images Metadata
*ArmApi* | [**v1_get_instance**](docs/ArmApi.md#v1_get_instance) | **GET** /v1/instances/{instanceId} | Get Instance
*ArmApi* | [**v1_get_instance_console**](docs/ArmApi.md#v1_get_instance_console) | **GET** /v1/instances/{instanceId}/console | Get console websocket URL
*ArmApi* | [**v1_get_instance_gpios**](docs/ArmApi.md#v1_get_instance_gpios) | **GET** /v1/instances/{instanceId}/gpios | Get Instance GPIOs
*ArmApi* | [**v1_get_instance_peripherals**](docs/ArmApi.md#v1_get_instance_peripherals) | **GET** /v1/instances/{instanceId}/peripherals | Get Instance Peripherals
*ArmApi* | [**v1_get_instance_state**](docs/ArmApi.md#v1_get_instance_state) | **GET** /v1/instances/{instanceId}/state | Get state of Instance
*ArmApi* | [**v1_get_instances**](docs/ArmApi.md#v1_get_instances) | **GET** /v1/instances | Get Instances
*ArmApi* | [**v1_get_model_software**](docs/ArmApi.md#v1_get_model_software) | **GET** /v1/models/{model}/software | Get Software for Model
*ArmApi* | [**v1_get_models**](docs/ArmApi.md#v1_get_models) | **GET** /v1/models | Get Supported Models
*ArmApi* | [**v1_get_project**](docs/ArmApi.md#v1_get_project) | **GET** /v1/projects/{projectId} | Get Project
*ArmApi* | [**v1_get_project_instances**](docs/ArmApi.md#v1_get_project_instances) | **GET** /v1/projects/{projectId}/instances | Get Instances in Project
*ArmApi* | [**v1_get_project_vpn_config**](docs/ArmApi.md#v1_get_project_vpn_config) | **GET** /v1/projects/{projectId}/vpnconfig/{format} | Get Project VPN Configuration
*ArmApi* | [**v1_get_projects**](docs/ArmApi.md#v1_get_projects) | **GET** /v1/projects | Get Projects
*ArmApi* | [**v1_get_snapshot**](docs/ArmApi.md#v1_get_snapshot) | **GET** /v1/instances/{instanceId}/snapshots/{snapshotId} | Get Instance Snapshots
*ArmApi* | [**v1_get_snapshots**](docs/ArmApi.md#v1_get_snapshots) | **GET** /v1/instances/{instanceId}/snapshots | Get Instance Snapshots
*ArmApi* | [**v1_patch_instance**](docs/ArmApi.md#v1_patch_instance) | **PATCH** /v1/instances/{instanceId} | Update Instance
*ArmApi* | [**v1_pause_instance**](docs/ArmApi.md#v1_pause_instance) | **POST** /v1/instances/{instanceId}/pause | Pause an Instance
*ArmApi* | [**v1_ready**](docs/ArmApi.md#v1_ready) | **GET** /v1/ready | API Status
*ArmApi* | [**v1_reboot_instance**](docs/ArmApi.md#v1_reboot_instance) | **POST** /v1/instances/{instanceId}/reboot | Reboot an Instance
*ArmApi* | [**v1_restore_snapshot**](docs/ArmApi.md#v1_restore_snapshot) | **POST** /v1/instances/{instanceId}/snapshots/{snapshotId}/restore | Restore a Snapshot
*ArmApi* | [**v1_set_instance_gpios**](docs/ArmApi.md#v1_set_instance_gpios) | **PUT** /v1/instances/{instanceId}/gpios | Set Instance GPIOs
*ArmApi* | [**v1_set_instance_peripherals**](docs/ArmApi.md#v1_set_instance_peripherals) | **PUT** /v1/instances/{instanceId}/peripherals | Set Instance Peripherals
*ArmApi* | [**v1_set_instance_state**](docs/ArmApi.md#v1_set_instance_state) | **PUT** /v1/instances/{instanceId}/state | Set state of Instance
*ArmApi* | [**v1_snapshot_delete**](docs/ArmApi.md#v1_snapshot_delete) | **DELETE** /v1/instances/{instanceId}/snapshots/{snapshotId} | Delete a Snapshot
*ArmApi* | [**v1_snapshot_rename**](docs/ArmApi.md#v1_snapshot_rename) | **PATCH** /v1/instances/{instanceId}/snapshots/{snapshotId} | Rename a Snapshot
*ArmApi* | [**v1_start_instance**](docs/ArmApi.md#v1_start_instance) | **POST** /v1/instances/{instanceId}/start | Start an Instance
*ArmApi* | [**v1_stop_instance**](docs/ArmApi.md#v1_stop_instance) | **POST** /v1/instances/{instanceId}/stop | Stop an Instance
*ArmApi* | [**v1_unpause_instance**](docs/ArmApi.md#v1_unpause_instance) | **POST** /v1/instances/{instanceId}/unpause | Unpause an Instance
*ArmApi* | [**v1_upload_image_data**](docs/ArmApi.md#v1_upload_image_data) | **POST** /v1/images/{imageId} | Upload Image Data


## Documentation For Models

 - [ApiConflictError](docs/ApiConflictError.md)
 - [ApiError](docs/ApiError.md)
 - [ApiNotFoundError](docs/ApiNotFoundError.md)
 - [ApiToken](docs/ApiToken.md)
 - [Bit](docs/Bit.md)
 - [Credentials](docs/Credentials.md)
 - [Firmware](docs/Firmware.md)
 - [GpioStateDefinition](docs/GpioStateDefinition.md)
 - [Image](docs/Image.md)
 - [Instance](docs/Instance.md)
 - [InstanceBootOptions](docs/InstanceBootOptions.md)
 - [InstanceConsoleEndpoint](docs/InstanceConsoleEndpoint.md)
 - [InstanceCreateOptions](docs/InstanceCreateOptions.md)
 - [InstanceNetmonState](docs/InstanceNetmonState.md)
 - [InstanceReturn](docs/InstanceReturn.md)
 - [InstanceServices](docs/InstanceServices.md)
 - [InstanceStartOptions](docs/InstanceStartOptions.md)
 - [InstanceState](docs/InstanceState.md)
 - [InstanceStopOptions](docs/InstanceStopOptions.md)
 - [Model](docs/Model.md)
 - [ModelSoftware](docs/ModelSoftware.md)
 - [PeripheralsData](docs/PeripheralsData.md)
 - [Project](docs/Project.md)
 - [ProjectQuota](docs/ProjectQuota.md)
 - [ProjectSettings](docs/ProjectSettings.md)
 - [ProjectUsage](docs/ProjectUsage.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotCreationOptions](docs/SnapshotCreationOptions.md)
 - [SnapshotStatus](docs/SnapshotStatus.md)
 - [Token](docs/Token.md)
 - [UserError](docs/UserError.md)
 - [V1SetStateBody](docs/V1SetStateBody.md)
 - [VolumeOptions](docs/VolumeOptions.md)
 - [VpnDefinition](docs/VpnDefinition.md)


## Documentation For Authorization


## BearerAuth

- **Type**: Bearer authentication (ApiToken or JWT)


## Author




