# dsps
[![tests](https://github.com/ArgonneCPAC/dsps/actions/workflows/tests.yml/badge.svg)](https://github.com/ArgonneCPAC/dsps/actions/workflows/tests.yml)

Differentiable Stellar Population Synthesis

## Installation

The latest release of DSPS is now available for installation with pip:
```
$ pip install dsps
```

Alternatively, the latest release is also available on conda-forge:
```
$ conda install -c conda-forge dsps
```

To install dsps from source, first clone the GitHub repository, and then:
```
$ pip install .
```

## Documentation

Online documentation for DSPS is available at [dsps.readthedocs.io](https://dsps.readthedocs.io/en/latest/).


## Citing DSPS
[The DSPS paper](https://arxiv.org/abs/2112.06830) has been published in [Monthly Notices of the Royal Astronomical Society](https://academic.oup.com/mnras/advance-article-abstract/doi/10.1093/mnras/stad456/7034352?utm_source=advanceaccess&utm_campaign=mnras&utm_medium=email). Citation information for the paper can be found at [this ADS link](https://ui.adsabs.harvard.edu/abs/2023MNRAS.521.1741H/abstract), copied below for convenience:

```
@ARTICLE{2023MNRAS.521.1741H,
       author = {{Hearin}, Andrew P. and {Chaves-Montero}, Jon{\'a}s and {Alarcon}, Alex and {Becker}, Matthew R. and {Benson}, Andrew},
        title = "{DSPS: Differentiable stellar population synthesis}",
      journal = {MNRAS},
     keywords = {software: data analysis, galaxies: stellar content, cosmology: large-scale structure of Universe, Astrophysics - Astrophysics of Galaxies, Astrophysics - Cosmology and Nongalactic Astrophysics},
         year = 2023,
        month = may,
       volume = {521},
       number = {2},
        pages = {1741-1756},
          doi = {10.1093/mnras/stad456},
archivePrefix = {arXiv},
       eprint = {2112.06830},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2023MNRAS.521.1741H},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}
```
