#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['fastapi',
 'fastapi.dependencies',
 'fastapi.middleware',
 'fastapi.openapi',
 'fastapi.security']

package_data = \
{'': ['*']}

install_requires = \
['starlette ==0.13.2', 'pydantic >=0.32.2,<2.0.0']

extras_require = \
{'all': ['requests',
         'aiofiles',
         'jinja2',
         'python-multipart',
         'itsdangerous',
         'pyyaml',
         'graphene',
         'ujson',
         'orjson',
         'email_validator',
         'uvicorn',
         'async_exit_stack',
         'async_generator'],
 'dev': ['pyjwt',
         'passlib[bcrypt]',
         'autoflake',
         'flake8',
         'uvicorn',
         'graphene'],
 'doc': ['mkdocs',
         'mkdocs-material',
         'markdown-include',
         'typer',
         'typer-cli',
         'pyyaml'],
 'test': ['pytest >=4.0.0',
          'pytest-cov',
          'mypy',
          'black',
          'isort',
          'requests',
          'email_validator',
          'sqlalchemy',
          'peewee',
          'databases[sqlite]',
          'orjson',
          'async_exit_stack',
          'async_generator',
          'python-multipart',
          'aiofiles',
          'flask']}

setup(name='fastapi',
      version='0.53.1',
      description='FastAPI framework, high performance, easy to learn, fast to code, ready for production',
      author='Sebastián Ramírez',
      author_email='tiangolo@gmail.com',
      url='https://github.com/tiangolo/fastapi',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
