#!/usr/bin/env python

#    "$Name:  $";
#    "$Header:  $";
#=============================================================================
#
# file :        PyStateComposer.py
#
# description : Python source for the PyStateComposer and its commands. 
#                The class is derived from Device. It represents the
#                CORBA servant object which will be accessed from the
#                network. All commands which can be executed on the
#                PyStateComposer are implemented in this file.
#
# project :     TANGO Device Server
#
# $Author: sergi_rubio $
#
# $Revision: 1.2 $
#
# $Log: PyStateComposer.py,v $
# Revision 1.2  2009/01/22 16:37:41  sergi_rubio
# Now this PyStateComposer uses Miscellaneous/PyTango_utils package. It provides DynamicDS and ThreadDict for DynamicAttributes and reliable polling.
#
# $Revision:  $
#
# Revision 1.1.1.1  2007/10/17 16:42:52  sergi_rubio
# A PyTango StateComposer, based on Calculation/StateComposer device
#
# copyleft :    ALBA Synchrotron
#               Barcelona, EU
#
#=============================================================================
#          This file is generated by POGO
#    (Program Obviously used to Generate tango Object)
#
#         (c) - Controls Section - ALBA
#=============================================================================
#


import PyTango
import sys,os,time,traceback,re
import threading
import collections
from functools import partial
from copy import *
try: import fandango as fn
except: import PyTango_utils as fn

from fandango import DynamicDS,DynamicDSClass,DynamicAttribute
from fandango.interface import FullTangoInheritance
from fandango.dynamic import CreateDynamicCommands,USE_STATIC_METHODS
from fandango.tango import (fakeAttributeValue,parse_tango_model,EventType,
    get_device,get_database,get_matching_devices,fakeEventType,
    AttrQuality,DevState,TangoProxies)

from fandango import CaselessList

#if "Device_4Impl" not in dir(PyTango):
    #print 'Adapting to PyTango7 ...'
    #PyTango.DeviceClass = PyTango.PyDeviceClass
    #PyTango.Device_4Impl = PyTango.Device_3Impl
    
import fandango.tango.defaults
fandango.tango.defaults.KEEP_PROXIES = True
fandango.tango.defaults.TANGO_DEBUG = True

#from fandango.callbacks import EventListener,EventSource,EventThread
#EventThread.MinWait = 5e-2 #1e-4
#EventThread.DEFAULT_PERIOD_ms = 1000 #0.1
#EventSource.get_thread().setLogLevel('INFO')
    
try: 
    __RELEASE__ = (l for l in open(os.path.dirname(os.path.abspath(__file__))
        +'/CHANGES').readlines() if l.startswith('VERSION')
        ).next().split('=',1)[-1].strip()
except Exception,e: 
    __RELEASE__ = str(e)
    
print '> ',__RELEASE__

"""
@mainpage PyStateComposer Tango Device Server

"""


#==================================================================
#   PyStateComposer Class Description:
#
#         <p>This device requires <a href="http://www.tango-controls.org/Documents/tools/fandango/fandango">Fandango module<a> to be available in the PYTHONPATH.</p>
#         PyStateComposer(Dev4Tango,DynamicDS) allows to create a new composed State or Attributes using the State and Attributes from a list of devices: <ul>
#         <li>When a new Device is added the composer subscribes to its State changes.</li>
#         <li>If it is not able to subscribe to events, then a polling thread is started.</li>
#         <li>relays on PyTango_utils package to provide DynamicAttributes and DynamicStates.</li>
#         <li>Either StatePolicy or DynamicStates property can be used to compose the State.</li>
#         <li>StatePolicy uses the same format than Soleil's composer, the default policy is generated the first time the composer is launched</li>
#         </ul>
#
#==================================================================


class PyStateComposer(PyTango.LatestDeviceImpl):

    #--------- Add you global variables here --------------------------
    '''   @class PyStateComposer
    PyStateComposer(Dev4Tango,DynamicDS) allows to create a new composed State or Attributes using the State and Attributes from a list of devices: <ul>
    <li>When a new Device is added the composer subscribes to its State changes.</li>
    <li>If it is not able to subscribe to events, then a polling thread is started.</li>
    <li>relays on PyTango_utils package to provide DynamicAttributes and DynamicStates.</li>
    <li>Either StatePolicy or DynamicStates property can be used to compose the State.</li>
    <li>StatePolicy uses the same format than Soleil's composer, the default policy is generated the first time the composer is launched</li>
    </ul>
    '''
    
    defaultStatePriorities = {
            'ON':0, 
            'OPEN':0, 
            'EXTRACT':0, 
            'STANDBY':0, 
            'MOVING':8, 
            'RUNNING':8, 
            'CLOSE':10, 
            'INSERT':10, 
            'DISABLE':11, 
            'OFF':11, 
            'UNKNOWN':12,
            'INIT':13, 
            'ALARM':13, 
            'FAULT':14, 
            }
    
    def cout(self,prio,s):
        if self.getLogLevel(prio)>=self.log_obj.level:
            print '%s %s %s: %s' % (prio.upper(),time.strftime('%Y-%m-%d %H:%M:%S',time.localtime()),self.get_name(),s)
        if hasattr(self,prio): getattr(self,prio)(s)

    def event_received(self,*args):
        """
        This method manages the events received from external attributes.
        """
        if len(args) == 1:
            event = args[0]
            source = event.attr_name #fqdn name
            type_ = 'error' if event.err else event.event #'change'
            attr_value = event.attr_value
        elif len(args) == 3:
            source,type_,attr_value = args
            
        self.last_event_received = time.time()
        etype = fakeEventType[type_] if type_ in fakeEventType else type_
        self.info('>'*80)
        self.info('In PyStateComposer.event_received(%s(%s),%s,%s)'
            %(type(source).__name__,source,etype,
              type(attr_value).__name__))
        try:
            DynamicDS.event_received(self,source,type_,attr_value)
            self.cout('info','-'*80)            
            source = fn.tango.get_model_name(source)
            self.cout('debug','source = %s'%source)
            if etype in ('Config','attr_conf','config'):
                self.cout('debug','Config event ignored ... %s'%source)
            elif '/' not in source:
                self.cout('info','Not-tango names ignored ... %s'%source)
            else:
                params = parse_tango_model(source)
                if params:
                    tango_host,dev_name,att,model = (
                        '%s:%s'%(params['host'],params['port']),
                        params['devicename'],params['attributename'],
                        '%s/%s'%(params['devicename'],params['attributename']))
                else: 
                    self.cout('error','Unparsable source: %s => %s'%(source,params))
                    tango_host,dev_name,att,model = '','',None,''
                dev_name,model = dev_name.lower(),model.lower()
                
                if model not in self.AttributeCache:
                    self.AttributeCache[model] = fakeAttributeValue(model,None,0)
                    
                if fn.clmatch('error',etype) or not hasattr(attr_value,'value'):
                    self.AttributeCache[model].set_value_date_quality(
                        DevState.UNKNOWN,time.time(),AttrQuality.ATTR_INVALID)
                    value = None
                    self.cout('warning','%s Error received: %s'%(model,attr_value))
                else:
                    #self.AttributeCache[model] = attr_value # I keep value/time/quality struct
                    self.AttributeCache[model].set_value_date_quality(
                        attr_value.value,attr_value.time,attr_value.quality)    
                    value = attr_value.value
                    self.info('event_received(%s): %s' % (model,value))
                    
                if att == 'state' and (self.DevicesDict.get(dev_name)!=value 
                        or str(etype).lower()=='error'):
                    self.DevicesDict[dev_name] = fn.notNone(value,DevState.UNKNOWN)
                    #if self.__initialized: 
                        #self.evaluateStates()
        except:
            self.cout('error','Exception in event_received(%s,%s,...):\n%s'%(source,type_,traceback.format_exc()))
            
        self.cout('info','Out of PyStateComposer.event_received()')
        return

    def updateSubComposers(self):
        #Updating _locals dictionary
        if hasattr(self,'SubComposers') and self.SubComposers:
            for composer in sorted(self.SubComposers):
                self.info('Importing states from composer: %s ' % (composer))
                devs = self.getXAttr(composer+'/DevicesList')
                states = self.getXAttr(composer+'/StatesList')
                try:
                    self.SubComposers[composer].update(zip(devs,states))
                    for k,v in sorted(zip(devs,states)):
                      self._locals['DEVICES'].append(k)
                      self._locals['STATES'][k] = v
                except:
                    self.error('Unable to import states from %s:\ndevs:%s\nstates:%s\n%s' % (composer,str(devs),str(states),traceback.format_exc()))
        return
      
    def checkState(self,model,check=False):
        """
        This method will check if the state of the model device appears in the BadStates list.
        If it is not the case, True will be returned.
        """
        try:
          dev_name = parse_tango_model(model)['devicename'].lower()
          state = self.DevicesDict.get(dev_name,True if not check else fn.check_device(dev_name))
          #self.info('checkState(%s): %s => %s'%(model,dev_name,state))
          assert (str(state) not in self.BadStates and not isinstance(state,Exception))
          return True
        except:
          #traceback.print_exc()
          return False
        
    def getXAttr(self,aname,default=None,write=False,wvalue=None):
        """
        Overriding DynamicDS.getXAttr to return default value in case device is not available
        """
        if '/' in aname and not self.checkState(aname): 
          self.warning('%s is not readable.'%aname)
          return default
        else:
          return DynamicDS.getXAttr(self,aname,default,write,wvalue)
        
    def evaluateStates(self):
        '''
        This method is called from push_event, always_executed_hook, AddDeviceToList and RemoveDevice methods; It depends of UseEvents property.
        
        It iterates over DevicesDict/StatesList dictionary and:
        
        @li Chooses the highest priority in StatesList
        @li Makes a report with the epochs received for each dev in EventsList
        @li Makes a report with subscribed AttributesList
        @li Updates status and state and forces a push_change_event('state') 
        '''
        self.cout('info','In evaluateStates(UseEvents=%s) ...'%self.UseEvents)
        dead_thread = 0
        now = time.time()
        states = []
        new_state = old_state = self.get_state()
        status = '%s is in %s State since %s.\n'%(
            self.get_name(),self.get_state(),time.ctime(self.LastStateUpdate))        
        try:
            #publishing Devices and States for Dynamic Attributes and States
            self.LastStateCheck = now            
            self._locals['DEVICES'] = CaselessList(self.DevicesDict.keys())
            if self.SortLists: self._locals['DEVICES'] = sorted(self._locals['DEVICES'])
            self._locals['STATES'] = self.DevicesDict.copy()
            self._locals['CHECK'] = self.checkState
            self._locals['IGNORED'] = []
            
            if not self.DevicesDict:
                self.cout('warning','DevicesDict is empty! State (%s) will not be updated.'%old_state)
                return
            
            #Discarding devices in IgnoreList property
            self.IgnoreList = [a.lower() for a in self.IgnoreList 
                                if a.strip() and not a.startswith('#')]

            for k,v in self.DevicesDict.items():
                if fn.matchAny(self.IgnoreList,k.lower()):
                    self._locals['IGNORED'].append(k.lower())
                    continue
                
                #Checking dead_threads
                try:
                    a = (k+'/state').lower()
                    if a not in self.AttributeCache: 
                        self.info('%s not in AttributeCache!' % a)
                        self.AttributeCache[a] = fakeAttributeValue(a,None,0)
                        
                    av = self.AttributeCache[a]
                    last = av.time.totime()
                    self.debug('Checking if %s updated %d s ago' % (a,now-last))
                    timeout = self.PollingCycle * (
                        1e-3 if self.EventSources.get(a) is None else 5e-3)
                    if (now-last)>(timeout):
                        self.info('>'*80)
                        self.info('reading %s, not updated since %s'%(a,last))
                        #if not isinstance(av,fakeAttributeValue):
                            #self.info('new fakeAttributeValue(%s)' % a)
                            #av = self.AttributeCache[a] = fakeAttributeValue(
                                #a,v,last,av.quality,av.dim_x,av.dim_y)
                        try: 
                            #v = av.read(cache=False).value
                            v = TangoProxies[k].read_attribute('state').value
                        except: 
                            self.error(traceback.format_exc())
                            v = PyTango.DevState.UNKNOWN

                        self.AttributeCache[a].set_value(v)
                        self.AttributeCache[a].set_date(now)                            
                        self.DevicesDict[k] = v   

                    self.debug('%s = %s' % (a,v))
                    states.append(v)
                except:
                    #if not av:
                        #self.warning('%s error received or not read yet!')
                    #elif av.value not in (None,PyTango.DevState.UNKNOWN):
                    self.cout('error','Exception in evaluateStates(%s)'%a)
                    print traceback.format_exc()
            
            # To sort the values we use the priority for each state; obtained using the state name from self.TangoStates
            # The highest priority (last) will give the new_state
            if states:
                new_state = sorted(states,key=lambda st:self.StatePriorities[str(st)])[-1]
            elif self.DevicesDict:
                self.cout('warning','StatesList is empty!?!?!')
                new_state = PyTango.DevState.UNKNOWN
                
            if self.dyn_states:
                result = '%s = %s\n' %(str(old_state),self.dyn_states.get(str(old_state),{}).get('formula',' ...' ))
                self.cout('info','DynamicStates (%s) overrides State composing.'%result)                    
            elif states:
                result = '%s = %s\n' % (str(new_state),'+'.join(sorted(set('%s(%d)'%(s,self.StatePriorities.get(str(s),0)) for s in states))))
            else:
                result = '%s\n'%old_state
            
            #Setting States
            if new_state != old_state:
                #@todo Some Hystheresis or change conditions must be applied 
                #before changing the State @n (e.g. keeping FAULT at least 
                #for 5 State evaluations, waiting 3 cycles before setting an UNKNOWN state)
                self.LastStateUpdate = time.time()
                if states: 
                    self.info(sorted(states,key=lambda st:self.StatePriorities[str(st)])[-1])
                if not self.dyn_states:
                    self.cout('info','State changed! %s -> %s\n%s' % (
                        old_state,new_state,self.DevicesDict))
                    self.set_state(new_state)
                    #self.push_change_event('state')  #Already done by DynamicDS.set_state()         
            
            #Updating Status
            status += 'DevicesList:\n'
            for dev,state in sorted(self.DevicesDict.items()):
                status += dev + ':\t' + str(state) + '\n'
            status = result+status+'\nLast Changes:\n'
            for d,h in self.History: 
                status+='%s: %s'%(time.ctime(d),h)
            if not self.History or result!=self.History[0][1]: 
                self.History.insert(0,(time.time(),result))
            self.History = self.History[:5]
            status+="\n\nLast event received at %s"%time.ctime(self.last_event_received)

            #Initializes local variables needed by DynamicStatus generation in DynamicDS.always_executed_hook
            if not self.DynamicStatus: 
                self.set_status(status) 
            else: 
                self._locals['STATUS'] = status

            self.cout('debug','evaluateStates(): composer status = %s'%status)
            
        except Exception,e:
            msg = 'Exception in evaluateStates(): %s' % traceback.format_exc()
            self.cout('error',msg)
            self.set_status(msg)
         
        finally:
            t3=time.time()
            self.cout('info','Out of evaluateStates() ... it took %f ms' % (1000.*(t3-now)))

            
    def create_state_attribute(self,argin):
        new_attr_name = argin.upper().replace('/','_')
        self.info('Creating attribute %s for %s/State' % (argin,new_attr_name))
        self.add_attribute(PyTango.Attr(new_attr_name,PyTango.ArgType.DevState,PyTango.AttrWriteType.READ),
                self.read_state_attribute,
                None, #self.write_new_attribute #(attr)
                lambda s,req_type,attr_name=argin: True,
                )

    def read_state_attribute(self,attr,attr_name=None):
        self.info('In read_state_attribute(%s,%s,%s)'%(self.get_name(),attr.get_name(),attr_name))
        if attr_name is None: 
            attr_name = [a.lower() for a in self.DevicesDict 
                if a.replace('_','').replace('/','').lower()==attr.get_name().replace('_','').lower()]
            if not attr_name: 
                raise Exception('%s:AttributesNotFound!'%attr.get_name())
        self.debug('\t%s = > %s'%(attr.get_name(),attr_name))
        attr.set_value(self.DevicesDict[((fn.isSequence(attr_name) and attr_name and attr_name[0]) or attr_name).lower()])
        
    if USE_STATIC_METHODS: read_state_attribute=staticmethod(read_state_attribute)
    
    def AddDeviceToList(self,argin):
        ''' @brief This method adds a new device to @bPyTango_utils.callback@b dictionaries: StatesList, EventsList, AttributesLIst ...
        @param[in] argin : the device to add; it must be an string; it can contain '*' or '?' , but not regular expressions
        
        Behaviour:
        @li the composer and the device are both added to DevicesDict (but composer itself cannot be added as device)
        @li A DeviceProxy is created for the device
        @li If needed: StatesList[dev_name] and AttributesList[dev_name] are initialized to UNKNOWN and None
        @li For State and each value in AttributesList keys it checks if appears in the list of attributes of the device
        
        For each cross-checked device attribute (or at least State attribute):
        @li if ForcePolling is set ... the polling of this attribute is forced
        @li A TAttr object is added to EventsList dictionary; it stores event receivers, DeviceProxy, event_id and more ...
        @li The composer is subscribed to the device attribute CHANGE events
        '''
        self.info("In AddDeviceToList(%s) ..." % str(argin))
        try:
            if '*' in argin or '?' in argin:
                devs = get_matching_devices(argin,fullname=False)
                self.info('AddDeviceToList: %d devices got from Database using wildcard (%s)'%(len(devs),argin))
                for d in devs:
                    self.AddDeviceToList(d)
                return

            dev_name = (fn.isSequence(argin) and argin and argin[0] or argin).lower()
            if '/' not in dev_name:
                raise Exception('%s is not a valid device name!' % dev_name)
            if self.get_name().lower() in dev_name:
                raise Exception("Recursive composing is not allowed.")
            if dev_name in self.DevicesDict:
                raise Exception("%s already subscribed" % dev_name)

            self.DevicesDict[dev_name] = PyTango.DevState.INIT
            if not fn.matchAny(self.IgnoreList,dev_name):
                try:
                    aname = dev_name + '/state'
                    #self.subscribe_external_attributes(dev_name,['State'])
                    #at = fn.callbacks.EventSource(aname,log_level='INFO',
                        #keeptime=250,polling_period=self.PollingCycle)
                    #self.info('Adding Listener to %s(%s)'%(type(at),aname))
                    #at.addListener(self.event_received,use_polling=self.PollingCycle)
                    
                    #dp = fn.get_device(dev_name,keep=True)
                    dp = TangoProxies[dev_name]
                    at = dp.subscribe_event('state',EventType.CHANGE_EVENT,self.event_received)
                except:
                    self.error('Unable to subscribe to %s: %s' % (argin,traceback.format_exc()))
                    at = None

                self.EventSources[aname] = at
                self.create_state_attribute(argin)

            return True
        
        except Exception,e:
                self.error('Exception in AddDevice(): %s' % traceback.format_exc())

#------------------------------------------------------------------
#    Device constructor
#------------------------------------------------------------------
    def __init__(self,cl, name):
        self.call__init__(DynamicDS,cl,name,
            _locals={
                #'list': fn.toList,
                'join': fn.join,
                'taurus': fn.tango.TAU or None,
                },
            useDynStates=True)
        self.__initialized = False
        PyStateComposer.init_device(self)

#------------------------------------------------------------------
#    Device destructor
#------------------------------------------------------------------
    def delete_device(self):
        if hasattr(self,'add_thread') and self.add_thread.is_alive():
          self.add_event.set()
          self.add_thread.join()
        self.info('*'*80)
        self.info("[Device delete_device method] for device %s"%self.get_name())
        #self.unsubscribe_external_attributes()
        self.info('*'*80)

#------------------------------------------------------------------
#    Device initialization
#------------------------------------------------------------------
    def init_device(self):
        print "In ", self.get_name(), "::init_device()"
        self._db = getattr(self,'_db',PyTango.Database())
        
        #Order Matters!
        #self.get_device_properties(self.get_device_class())
        #try: 
        DynamicDS.init_device(self)
        #except: self.get_DynDS_properties()
        
        #self.setLogLevel(self.LogLevel if hasattr(self,'LogLevel') else 'INFO')
        self.set_state(PyTango.DevState.INIT)
        st = 'Connecting devices ... '
        self.set_status(st)
        # If self.DevicesList property is not initialized then DeviceNameList is read instead; this is for Soleil's device compatibility
        if not self.DevicesList:
            props = self._db.get_device_property(self.get_name(),['DeviceNameList','DevicesList'])
            if not props['DevicesList']: self.DevicesList = props['DeviceNameList']
        self.DeviceNameList = self.DevicesList
        self.IgnoreList = [a for a in self.IgnoreList if a.strip() and not a.startswith('#')]
        #self.info('DevicesList:%s'%self.DevicesList)
        #Updating StatePriorities dictionary
        self.UpdateStatePolicy(read_properties = False)
        
        if not self.__initialized:
            self.DevicesDict = fn.SortedDict()#fandango.CaselessDict()
            self.AttributeCache = fn.CaselessDict()
            self.EventSources = fn.CaselessDict()
            self.History = []
            self.LastStateCheck = 0.
            self.LastStateUpdate = 0.
            self.last_event_received = 0.
            self.set_change_event('State',True,True)
            
            #publishing Devices and States for Dynamic Attributes and States
            self._locals['DEVICES'] = CaselessList(self.DevicesDict.keys())
            if self.SortLists: self._locals['DEVICES'] = sorted(self._locals['DEVICES'])
            self._locals['STATES'] = self.DevicesDict.copy()
            self._locals['CHECK'] = self.checkState
            self._locals['IGNORED'] = []
            
            
            self.info('Updating Device Properties ...')
            default_props = {
                'UseEvents':self.UseEvents,
                'PollingCycle':[self.PollingCycle],
                } 
            if not len(self.DynamicStates): default_props['StatePolicy']=self.StatePolicy
            if not self.DevicesList: default_props['DeviceNameList']=self.DeviceNameList
            if not len(self.IgnoreList): default_props['IgnoreList']=['']
            
            self._db.put_device_property(self.get_name(),dict((k,(v if len(v) else None) if fn.isSequence(v) else [v]) for k,v in default_props.items()))
            self.info('DevicesList:%s'%self.DevicesList)
            self.info('IgnoreList:%s'%self.IgnoreList)
    
            self.add_event = threading.Event()
            
            # Adding devices from subcomposer devices
            def add_all(obj=self,wait=True):
                while wait and not obj.__initialized: 
                    obj.add_event.wait(.1)

                if obj.SubComposers:
                    obj.SubComposers = [s for s in obj.SubComposers if s]
                    print 'Adding devices from SubComposers list (%s)'%obj.SubComposers
                    obj.SubComposers = dict.fromkeys(obj.SubComposers)
                    for composer in obj.SubComposers:
                        print 'Adding devices from %s'%composer
                        if obj.add_event.is_set(): break
                        obj.SubComposers[composer] = {}
                        obj.AddDeviceToList(composer)
                        if wait: obj.add_event.wait(.1)

                print 'Adding devices from DevicesList(%s(%s))'%(type(self.DevicesList),self.DevicesList)
                for device in obj.DevicesList:
                    if obj.add_event.is_set(): break
                    obj.AddDeviceToList(device)
                    if wait: obj.add_event.wait(.1)

                print('Ready to process events ...')
                return
            
            if False:
                self.add_thread = threading.Thread(target=add_all)
                self.add_thread.setDaemon(False)#True)
                self.add_thread.start()
            else: add_all(wait=False)
            
        print('#'*80)        
        print('Ready to accept request ...')
        print('#'*80)        
        self.__initialized = True

#------------------------------------------------------------------
#    Always excuted hook method
#------------------------------------------------------------------
    def always_executed_hook(self):
        #print "In ", self.get_name(), "::always_executed_hook()"
        self.debug("In ::always_executed_hook()")
        DynamicDS.always_executed_hook(self)
        #if (self.LastStateCheck+1e-3*self.PollingCycle)<time.time():
            #self.evaluateStates()
        #else:
        self._locals['DEVICES'] = CaselessList(self.DevicesDict.keys())
        if self.SortLists: self._locals['DEVICES'] = sorted(self._locals['DEVICES'])
        self._locals['STATES'].update(self.DevicesDict.items())
        for v in self.DevicesDict.values():
            # States will also contain a counter of occurrences for each state
            self._locals['STATES'][str(v)] = 1+self._locals['STATES'].get(str(v),0)

#==================================================================
#
#    PyStateComposer read/write attribute methods
#
#==================================================================
#------------------------------------------------------------------
#    Read Attribute Hardware
#------------------------------------------------------------------
    def read_attr_hardware(self,data):
        #print "In ", self.get_name(), "::read_attr_hardware()"
        self.debug("In read_attr_hardware()")


#------------------------------------------------------------------
#    Read VersionNumber attribute
#------------------------------------------------------------------
    def read_VersionNumber(self, attr):
        self.debug( "In "+self.get_name()+"::read_VersionNumber()")

        #    Add your own code here
        attr_VersionNumber_read = __RELEASE__
        attr.set_value(attr_VersionNumber_read)


#------------------------------------------------------------------
#    Read StatesList attribute
#------------------------------------------------------------------
    def read_StatesList(self, attr):
        #print "In ", self.get_name(), "::read_StatesList()"
        self.debug("In read_StatesList()")
        
        #    Add your own code here
        
        attr_StatesList_read,meth = [],(sorted if self.SortLists else list)
        [attr_StatesList_read.append(str(v)) for k,v in meth(self.DevicesDict.items())]
        if self.SubComposers:
            [[attr_StatesList_read.append(v) for k,v in sorted(self.SubComposers[c].items())] for c in sorted(self.SubComposers)]
        attr.set_value(attr_StatesList_read, len(attr_StatesList_read))


#------------------------------------------------------------------
#    Read DevicesList attribute
#------------------------------------------------------------------
    def read_DevicesList(self, attr):
        #print "In ", self.get_name(), "::read_DevicesList()"
        self.debug("In read_DevicesList")
        
        #    Add your own code here
        
        attr_DevicesList_read = []
        [attr_DevicesList_read.append(k) for k,v in self.DevicesDict.items()]
        if self.SortLists: attr_DevicesList_read = sorted(attr_DevicesList_read)
        if hasattr(self,'SubComposers') and self.SubComposers:
            [[attr_DevicesList_read.append(k) for k,v in sorted(self.SubComposers[c].items())] for c in sorted(self.SubComposers)] 
        attr.set_value(attr_DevicesList_read, len(attr_DevicesList_read))

#------------------------------------------------------------------
#    Read DevStates attribute
#------------------------------------------------------------------
    def read_DevStates(self, attr):
        #print "In ", self.get_name(), "::read_DevStates"
        self.debug("In read_DevStates")
        
        #    Add your own code here
        attr_DevStates_read = []
        names = (sorted if self.SortLists else list)(self.DevicesDict.keys())
        for d in names:
            attr_DevStates_read.append(str(d))
            attr_DevStates_read.append(str(self.DevicesDict[d]))
        attr.set_value(attr_DevStates_read, len(attr_DevStates_read))


#==================================================================
#
#    PyStateComposer command methods
#
#==================================================================

#------------------------------------------------------------------
#    AddDevice command:
#
#    Description: 
#    argin:  DevString    Device to add to the composing
#------------------------------------------------------------------
    def AddDevice(self, argin):
        #print "In ", self.get_name(), "::AddDevice("+argin+")"
        self.debug("In AddDevice(%s)" % argin)
        
        #    Add your own code here
        self.AddDeviceToList(argin)


#------------------------------------------------------------------
#    RemoveDevice command:
#
#    Description: 
#    argin:  DevString    Device to remove
#------------------------------------------------------------------
    def RemoveDevice(self, argin):
        """ @deprecated RemoveDevice method has been deprecated """
        #print "In ", self.get_name(), "::RemoveDevice()"
        self.debug("In RemoveDevice(%s)" % argin)
        if '*' in argin or '?' in argin:
            devs = PyTango.Database().get_device_exported(argin)
            for d in devs:
                self.RemoveDevice(d)
        else:
            k = (argin+'/state').lower()
            if k in self.EventSources:
                fn.get_device(argin,keep=True).unsubscribe_event(
                    self.EventSources[(argin+'/state').lower()])
            self.DevicesDict.pop(k)

#------------------------------------------------------------------
#    UpdateStatePolicy command:
#
#    Description: Updates the way State is computed
#    
#------------------------------------------------------------------
    def UpdateStatePolicy(self, read_properties = True):
        """
        It updates two Objects used to manage States:
        @li StatePriorities is the dictionary used
        @li StatePolicy is its string representation (Tango Property)
        """
        self.info("In UpdateStatePolicy()")
        
        #Updating Device Properties
        if read_properties: self.get_device_properties(self.get_device_class())
        #Updating StatePriorites dictionary from StatePolicy property
        if len(self.StatePolicy):
            self.StatePriorities = {}
            separators = ":=, "
            for line in self.StatePolicy:
                try:
                    line = line.strip().split('#')[0]
                    if not line: continue
                    state,priority = fn.first(line.split(s) for s in separators if s in line)
                    self.StatePriorities[state.upper()]=int(priority)
                except:
                    self.error('Exception in UpdateStatePolicy():\n%s'%traceback.format_exc())
            [self.StatePriorities.__setitem__(s,0) for s in self.TangoStates if s not in self.StatePriorities]
        else:
            self.info("Reloading default StatePolicy")
            self.StatePriorities = dict(PyStateComposer.defaultStatePriorities)
            
        #Updating StatePolicy from StateProperties dictionary
        self.StatePolicy = ['%s,%d'%(k,v) for v,k in sorted((j,s) for s,j in self.StatePriorities.items())]
        if read_properties: get_database().put_device_property(self.get_name(),{'StatePolicy':self.StatePolicy})
        self.info('StatePolicy set to: %s' % str(self.StatePolicy))
        return

    def UpdateStates(self):
        self.evaluateStates()
        return

#==================================================================
#
#    PyStateComposerClass class definition
#
#==================================================================
class PyStateComposerClass(PyTango.DeviceClass):

    #    Class Properties
    class_property_list = {
        }


    #    Device Properties
    device_property_list = {
        #'DynamicAttributes':
            #[PyTango.DevVarStringArray,
            #"Attributes and formulas to create for this device.<br>This Tango Attributes will be generated dynamically using this syntax:<br>&nbsp;AllPressures=DevVarDoubleArray([XAttr(dev+'/Pressure') or 0 for dev in DEVICES])",
            #[] ],
        #'DynamicStates':
            #[PyTango.DevVarStringArray,
            #"This property will allow to declare new States dinamically based on dynamic attributes changes:<br>&nbsp;FAULT=any([s==FAULT for s in STATES])<br>&nbsp;ON=1",
            #[] ],
        #'DynamicStatus':
            #[PyTango.DevVarStringArray,
            #"Each line generated by this property code will be added to status",
            #[] ],
        #'CheckDependencies':
            #[PyTango.DevBoolean,
            #"This property manages if dependencies between attributes are used to check readability.",
            #[False] ], #This property is normally True for other Dynamic Devices
        'PollingCycle':
            [PyTango.DevLong,
            "Default period for polling all device states.",
            [ 3000 ] ],
        #'UseEvents':
            #[PyTango.DevVarStringArray,
            #"This property allows to enable/disable events management.",
            #[ 'false' ] ],
        'DevicesList':
            [PyTango.DevVarStringArray,
            "A list of device names, wildcards like domain/family/* are allowed.<br>If this property is not initialized DeviceNameList is read instead.",
            [] ],
        'IgnoreList':
            [PyTango.DevVarStringArray,
            "A list of device names, wildcards like domain/family/* are allowed.<br>The devices in this list will not be used to compose the state.",
            [] ],    
        'SubComposers':
            [PyTango.DevVarStringArray,
            "A list of composer device names from which devices/states lists will be imported.",
            [] ],            
        'StatePolicy':
            [PyTango.DevVarStringArray,
            "A list of States and its priority. this property is not used if DynamicStates has been initialized.",
            [] ],
        'BadStates':
            [PyTango.DevVarStringArray,
            "Attributes from devices with these states will be not evaluated.",
            [ 'None' ] ],
        'SortLists':
            [PyTango.DevBoolean,
            "A property to control whether DEVICES lists will be sorted or not",
            [True] ],
        'LogLevel':
            [PyTango.DevString,
            "This property selects the log level (DEBUG/INFO/WARNING/ERROR)",
            ['WARNING'] ],
        }


    #    Command definitions
    cmd_list = {
        'AddDevice':
            [[PyTango.DevString, "Device to add to the composing"],
            [PyTango.DevVoid, ""]],
        #'RemoveDevice':
            #[[PyTango.DevString, "Device to remove"],
            #[PyTango.DevVoid, ""]],
        'UpdateStatePolicy':
            [[PyTango.DevVoid, "Reloads StatePolicy from the database"],
            [PyTango.DevVoid, ""]],
        'UpdateStates':
            [[PyTango.DevVoid, "Updates States Values"],
            [PyTango.DevVoid, ""],
            {
                'Display level':PyTango.DispLevel.EXPERT,
                'Polling period': 3000,
            } ],
        }


    #    Attribute definitions
    attr_list = {
        'VersionNumber':
            [[PyTango.DevString,
            PyTango.SCALAR,
            PyTango.READ],
            {
                'Display level':PyTango.DispLevel.EXPERT,
                'description':"Version number and release note",
            } ],
        'StatesList':
            [[PyTango.DevString,
            PyTango.SPECTRUM,
            PyTango.READ, 2048],
            {
                'description':"States of subscribed devices.",
            } ],
        'DevicesList':
            [[PyTango.DevString,
            PyTango.SPECTRUM,
            PyTango.READ, 2048],
            {
                'description':"Devices actually subscribed.",
            } ],
        'DevStates':
            [[PyTango.DevString,
            PyTango.SPECTRUM,
            PyTango.READ, 2048],
            {
                'description':"A list with device/state pairs .",
            } ],            
        }


#------------------------------------------------------------------
#    PyStateComposerClass Constructor
#------------------------------------------------------------------
    def __init__(self, name):
        PyTango.DeviceClass.__init__(self, name)
        self.set_type(name);
        print "In PyStateComposerClass  constructor"

#==================================================================
#
#    PyStateComposer class main method
#
#==================================================================

PyStateComposer,PyStateComposerClass=FullTangoInheritance('PyStateComposer',
    PyStateComposer,PyStateComposerClass,DynamicDS,DynamicDSClass,
    ForceDevImpl=True)
#PyStateComposer,PyStateComposerClass=FullTangoInheritance('PyStateComposer',
    #PyStateComposer,PyStateComposerClass,Dev4Tango,PyTango.DeviceClass,
    #ForceDevImpl=False)

def main():
    #@staticmethod
    #def main():
    try:
        #py = ('PyUtil' in dir(PyTango) and PyTango.PyUtil or PyTango.Util)(sys.argv)
        py = PyTango.Util(sys.argv)
        py.add_TgClass(PyStateComposerClass,PyStateComposer,'PyStateComposer')        
        U = PyTango.Util.instance()
        CreateDynamicCommands(PyStateComposer,PyStateComposerClass)
        U.server_init()
        U.server_run()

    except PyTango.DevFailed,e:
        print('-------> Received a DevFailed exception:',traceback.format_exc())
    except Exception,e:
        print('-------> An unforeseen exception occured....',traceback.format_exc())
    
if __name__ == '__main__':
    main()
