import { RemovalPolicy } from 'aws-cdk-lib';
import * as cf from 'aws-cdk-lib/aws-cloudfront';
import * as cforigins from 'aws-cdk-lib/aws-cloudfront-origins';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Represents a MicroApps S3
 */
export interface IMicroAppsS3 {
    /**
     * S3 bucket for deployed applications
     */
    readonly bucketApps: s3.IBucket;
    /**
     * CloudFront Origin Access Identity for the deployed applications bucket
     */
    readonly bucketAppsOAI: cf.OriginAccessIdentity;
    /**
     * CloudFront Origin for the deployed applications bucket
     */
    readonly bucketAppsOrigin: cforigins.S3Origin;
    /**
     * S3 bucket for staged applications (prior to deploy)
     */
    readonly bucketAppsStaging: s3.IBucket;
    /**
     * S3 bucket for CloudFront logs
     */
    readonly bucketLogs: s3.IBucket;
}
/**
 * Properties to initialize an instance of `MicroAppsS3`.
 */
export interface MicroAppsS3Props {
    /**
     * RemovalPolicy override for child resources
     *
     * Note: if set to DESTROY the S3 buckets will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * S3 deployed apps bucket name
     *
     * @default auto-assigned
     */
    readonly bucketAppsName?: string;
    /**
     * S3 staging apps bucket name
     *
     * @default auto-assigned
     */
    readonly bucketAppsStagingName?: string;
    /**
     * S3 logs bucket name
     *
     * @default auto-assigned
     */
    readonly bucketLogsName?: string;
    /**
     * Optional asset name root
     *
     * @example microapps
     * @default - resource names auto assigned
     */
    readonly assetNameRoot?: string;
    /**
     * Optional asset name suffix
     *
     * @example -dev-pr-12
     * @default none
     */
    readonly assetNameSuffix?: string;
}
/**
 * Create the durable MicroApps S3 Buckets
 *
 * These should be created in a stack that will not be deleted if
 * there are breaking changes to MicroApps in the future.
 */
export declare class MicroAppsS3 extends Construct implements IMicroAppsS3 {
    private _bucketApps;
    get bucketApps(): s3.IBucket;
    private _bucketAppsOAI;
    get bucketAppsOAI(): cf.OriginAccessIdentity;
    private _bucketAppsOrigin;
    get bucketAppsOrigin(): cforigins.S3Origin;
    private _bucketAppsStaging;
    get bucketAppsStaging(): s3.IBucket;
    private _bucketLogs;
    get bucketLogs(): s3.IBucket;
    constructor(scope: Construct, id: string, props?: MicroAppsS3Props);
}
//# sourceMappingURL=MicroAppsS3.d.ts.map