import { Construct } from '@aws-cdk/core';
import { DatadogCredentials } from '../common/properties';
/**
 * @stability stable
 */
export interface DatadogIAMUserProps {
    /**
     * Credentials for the Datadog API.
     *
     * @stability stable
     */
    readonly datadogCredentials: DatadogCredentials;
    /**
     * The role of the user.
     *
     * @stability stable
     */
    readonly accessRole?: string;
    /**
     * Whether or not the user is disabled.
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * User email.
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * User handle (a valid email).
     *
     * @stability stable
     */
    readonly handle?: string;
    /**
     * User name.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Whether or not the user is verified.
     *
     * @stability stable
     */
    readonly verified?: boolean;
}
/**
 * Datadog Application User 1.2.0.
 *
 * @stability stable
 */
export declare class DatadogIAMUser {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DatadogIAMUserProps);
}
