import { Construct } from '@aws-cdk/core';
import { DatadogCredentials } from '../common/properties';
/**
 * @stability stable
 */
export interface DatadogIntegrationAWSProps {
    /**
     * Credentials for the Datadog API.
     *
     * @stability stable
     */
    readonly datadogCredentials: DatadogCredentials;
    /**
     * The id of the account with which to integrate.
     *
     * @stability stable
     */
    readonly accountId: string;
    /**
     * The name of the created role.
     *
     * @stability stable
     */
    readonly roleName: string;
}
/**
 * Datadog Integration 1.1.0.
 *
 * @stability stable
 */
export declare class DatadogIntegrationAWS {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DatadogIntegrationAWSProps);
}
