# coding: utf-8

"""
    STACKIT LogMe API

    The STACKIT LogMe API provides endpoints to list service offerings, manage service instances and service credentials within STACKIT portal projects.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set, Union

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing_extensions import Annotated, Self

from stackit.logme.models.instance_parameters_groks_inner import (
    InstanceParametersGroksInner,
)


class InstanceParameters(BaseModel):
    """
    InstanceParameters
    """

    enable_monitoring: Optional[StrictBool] = False
    fluentd_tcp: Optional[StrictInt] = Field(default=0, alias="fluentd-tcp")
    fluentd_tls: Optional[StrictInt] = Field(default=6514, alias="fluentd-tls")
    fluentd_tls_ciphers: Optional[StrictStr] = Field(default=None, alias="fluentd-tls-ciphers")
    fluentd_tls_max_version: Optional[StrictStr] = Field(default=None, alias="fluentd-tls-max-version")
    fluentd_tls_min_version: Optional[StrictStr] = Field(default=None, alias="fluentd-tls-min-version")
    fluentd_tls_version: Optional[StrictStr] = Field(default=None, alias="fluentd-tls-version")
    fluentd_udp: Optional[StrictInt] = Field(default=514, alias="fluentd-udp")
    graphite: Optional[StrictStr] = Field(
        default=None,
        description="If you want to monitor your service with Graphite, you can set the custom parameter graphite. It expects the host and port where the Graphite metrics should be sent to.",
    )
    groks: Optional[List[InstanceParametersGroksInner]] = None
    ism_deletion_after: Optional[StrictStr] = Field(
        default="30d",
        description="Combination of an integer and a timerange when an index will be considered 'd' and can be deleted from OpenSearch. Possible values for the timerange are s, m, h and d.",
    )
    ism_jitter: Optional[Union[StrictFloat, StrictInt]] = 0.6
    ism_job_interval: Optional[StrictInt] = 5
    java_heapspace: Optional[Annotated[int, Field(strict=True, ge=256)]] = Field(
        default=None,
        description="Default: not set, 46% of available memory will be used. The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.",
    )
    java_maxmetaspace: Optional[Annotated[int, Field(le=1024, strict=True, ge=256)]] = Field(
        default=512, description="The amount of memory (in MB) used by the JVM to store metadata for OpenSearch."
    )
    max_disk_threshold: Optional[StrictInt] = Field(
        default=80,
        description="This component monitors ephemeral and persistent disk usage. If one of these disk usages reaches the default configured threshold of 80%, the a9s Parachute stops all processes on that node.",
    )
    metrics_frequency: Optional[StrictInt] = Field(
        default=10, description="Frequency of metrics being emitted in seconds"
    )
    metrics_prefix: Optional[StrictStr] = Field(
        default=None,
        description="Depending on your graphite provider, you might need to prefix the metrics with a certain value, like an API key for example.",
    )
    monitoring_instance_id: Optional[StrictStr] = None
    opensearch_tls_ciphers: Optional[List[StrictStr]] = Field(default=None, alias="opensearch-tls-ciphers")
    opensearch_tls_protocols: Optional[List[StrictStr]] = Field(default=None, alias="opensearch-tls-protocols")
    sgw_acl: Optional[StrictStr] = Field(
        default=None,
        description="Comma separated list of IP networks in CIDR notation which are allowed to access this instance.",
    )
    syslog: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = [
        "enable_monitoring",
        "fluentd-tcp",
        "fluentd-tls",
        "fluentd-tls-ciphers",
        "fluentd-tls-max-version",
        "fluentd-tls-min-version",
        "fluentd-tls-version",
        "fluentd-udp",
        "graphite",
        "groks",
        "ism_deletion_after",
        "ism_jitter",
        "ism_job_interval",
        "java_heapspace",
        "java_maxmetaspace",
        "max_disk_threshold",
        "metrics_frequency",
        "metrics_prefix",
        "monitoring_instance_id",
        "opensearch-tls-ciphers",
        "opensearch-tls-protocols",
        "sgw_acl",
        "syslog",
    ]

    @field_validator("opensearch_tls_ciphers")
    def opensearch_tls_ciphers_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(["TLSv1.2", "TLSv1.3"]):
                raise ValueError("each list item must be one of ('TLSv1.2', 'TLSv1.3')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstanceParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in groks (list)
        _items = []
        if self.groks:
            for _item in self.groks:
                if _item:
                    _items.append(_item.to_dict())
            _dict["groks"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstanceParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "enable_monitoring": (
                    obj.get("enable_monitoring") if obj.get("enable_monitoring") is not None else False
                ),
                "fluentd-tcp": obj.get("fluentd-tcp") if obj.get("fluentd-tcp") is not None else 0,
                "fluentd-tls": obj.get("fluentd-tls") if obj.get("fluentd-tls") is not None else 6514,
                "fluentd-tls-ciphers": obj.get("fluentd-tls-ciphers"),
                "fluentd-tls-max-version": obj.get("fluentd-tls-max-version"),
                "fluentd-tls-min-version": obj.get("fluentd-tls-min-version"),
                "fluentd-tls-version": obj.get("fluentd-tls-version"),
                "fluentd-udp": obj.get("fluentd-udp") if obj.get("fluentd-udp") is not None else 514,
                "graphite": obj.get("graphite"),
                "groks": (
                    [InstanceParametersGroksInner.from_dict(_item) for _item in obj["groks"]]
                    if obj.get("groks") is not None
                    else None
                ),
                "ism_deletion_after": (
                    obj.get("ism_deletion_after") if obj.get("ism_deletion_after") is not None else "30d"
                ),
                "ism_jitter": obj.get("ism_jitter") if obj.get("ism_jitter") is not None else 0.6,
                "ism_job_interval": obj.get("ism_job_interval") if obj.get("ism_job_interval") is not None else 5,
                "java_heapspace": obj.get("java_heapspace"),
                "java_maxmetaspace": obj.get("java_maxmetaspace") if obj.get("java_maxmetaspace") is not None else 512,
                "max_disk_threshold": (
                    obj.get("max_disk_threshold") if obj.get("max_disk_threshold") is not None else 80
                ),
                "metrics_frequency": obj.get("metrics_frequency") if obj.get("metrics_frequency") is not None else 10,
                "metrics_prefix": obj.get("metrics_prefix"),
                "monitoring_instance_id": obj.get("monitoring_instance_id"),
                "opensearch-tls-ciphers": obj.get("opensearch-tls-ciphers"),
                "opensearch-tls-protocols": obj.get("opensearch-tls-protocols"),
                "sgw_acl": obj.get("sgw_acl"),
                "syslog": obj.get("syslog"),
            }
        )
        return _obj
