"use strict";
const assert_1 = require("@aws-cdk/assert");
const iam = require("@aws-cdk/aws-iam");
const eks = require("../lib");
const util_1 = require("./util");
module.exports = {
    'add Service Account': {
        'defaults should have default namespace and lowercase unique id'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.ServiceAccount(stack, 'MyServiceAccount', { cluster });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.KubernetesResource.RESOURCE_TYPE, {
                ServiceToken: {
                    'Fn::GetAtt': [
                        'awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B',
                        'Outputs.StackawscdkawseksKubectlProviderframeworkonEvent8897FD9BArn',
                    ],
                },
                Manifest: {
                    'Fn::Join': [
                        '',
                        [
                            '[{\"apiVersion\":\"v1\",\"kind\":\"ServiceAccount\",\"metadata\":{\"name\":\"stackmyserviceaccount58b9529e\",\"namespace\":\"default\",\"labels\":{\"app.kubernetes.io/name\":\"stackmyserviceaccount58b9529e\"},\"annotations\":{\"eks.amazonaws.com/role-arn\":\"',
                            {
                                'Fn::GetAtt': [
                                    'MyServiceAccountRoleB41709FF',
                                    'Arn',
                                ],
                            },
                            '\"}}}]',
                        ],
                    ],
                },
            }));
            assert_1.expect(stack).to(assert_1.haveResource(iam.CfnRole.CFN_RESOURCE_TYPE_NAME, {
                AssumeRolePolicyDocument: {
                    Statement: [
                        {
                            Action: 'sts:AssumeRoleWithWebIdentity',
                            Effect: 'Allow',
                            Principal: {
                                Federated: {
                                    Ref: 'ClusterOpenIdConnectProviderE7EB0530',
                                },
                            },
                            Condition: {
                                StringEquals: {
                                    'Fn::GetAtt': [
                                        'MyServiceAccountConditionJson1ED3BC54',
                                        'Value',
                                    ],
                                },
                            },
                        },
                    ],
                    Version: '2012-10-17',
                },
            }));
            test.done();
        },
        'should have allow multiple services accounts'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            cluster.addServiceAccount('MyServiceAccount');
            cluster.addServiceAccount('MyOtherServiceAccount');
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.KubernetesResource.RESOURCE_TYPE, {
                ServiceToken: {
                    'Fn::GetAtt': [
                        'awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B',
                        'Outputs.StackawscdkawseksKubectlProviderframeworkonEvent8897FD9BArn',
                    ],
                },
                Manifest: {
                    'Fn::Join': [
                        '',
                        [
                            '[{\"apiVersion\":\"v1\",\"kind\":\"ServiceAccount\",\"metadata\":{\"name\":\"stackclustermyotherserviceaccounta472761a\",\"namespace\":\"default\",\"labels\":{\"app.kubernetes.io/name\":\"stackclustermyotherserviceaccounta472761a\"},\"annotations\":{\"eks.amazonaws.com/role-arn\":\"',
                            {
                                'Fn::GetAtt': [
                                    'ClusterMyOtherServiceAccountRole764583C5',
                                    'Arn',
                                ],
                            },
                            '\"}}}]',
                        ],
                    ],
                },
            }));
            test.done();
        },
        'should have unique resource name'(test) {
            // GIVEN
            const { cluster } = util_1.testFixtureCluster();
            // WHEN
            cluster.addServiceAccount('MyServiceAccount');
            // THEN
            test.throws(() => cluster.addServiceAccount('MyServiceAccount'));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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