"""
[![PiPy Version](https://badge.fury.io/py/labml-nn.svg)](https://badge.fury.io/py/labml-nn)
[![PiPy Downloads](https://pepy.tech/badge/labml-nn)](https://pepy.tech/project/labml-nn)

# [LabML Neural Networks](http://lab-ml.com/labml_nn/index.html)

This is a collection of simple PyTorch implementation of various
neural network architectures and layers.
We will keep adding to this.

**If you have any suggestions for other new implementations,
please create a [Github Issue](https://github.com/lab-ml/labml_nn/issues).**

## Modules

#### ✨ [Transformers](http://lab-ml.com/labml_nn/transformers)

[Transformers module](http://lab-ml.com/labml_nn/transformers)
contains implementations for
[multi-headed attention](http://lab-ml.com/labml_nn/transformers/mha.html)
and
[relative multi-headed attention](http://lab-ml.com/labml_nn/transformers/relative_mha.html>).

#### ✨ [Recurrent Highway Networks](http://lab-ml.com/labml_nn/recurrent_highway_networks)

#### ✨ [LSTM](http://lab-ml.com/labml_nn/lstm)

#### ✨ [Capsule Networks](http://lab-ml.com/labml_nn/capsule_networks/)

#### ✨ [Generative Adversarial Networks](http://lab-ml.com/labml_nn/gan/)

### Installation

```bash
pip install labml_nn
```

### Links

[💬 Slack workspace for discussions](https://join.slack.com/t/labforml/shared_invite/zt-egj9zvq9-Dl3hhZqobexgT7aVKnD14g/)_

[📗 Documentation](http://lab-ml.com)

[📑 Articles & Tutorials](https://medium.com/@labml/)

[👨‍🏫 Samples](https://github.com/lab-ml/samples)


### Citing LabML

If you use LabML for academic research, please cite the library using the following BibTeX entry.

```bibtex
@misc{labml,
 author = {Varuna Jayasiri, Nipun Wijerathne},
 title = {LabML: A library to organize machine learning experiments},
 year = {2020},
 url = {https://lab-ml.com/},
}
```
"""
