# Generated by Django 3.0.3 on 2021-01-19 10:08

import core.fields
import datetime
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0009_mutationlog_client_mutation_details'),
    ]

    operations = [
        migrations.CreateModel(
            name='Premium',
            fields=[
                ('validity_from', core.fields.DateTimeField(db_column='ValidityFrom', default=datetime.datetime.now)),
                ('validity_to', core.fields.DateTimeField(blank=True, db_column='ValidityTo', null=True)),
                ('legacy_id', models.IntegerField(blank=True, db_column='LegacyID', null=True)),
                ('id', models.AutoField(db_column='PremiumId', primary_key=True, serialize=False)),
                ('uuid', models.CharField(db_column='PremiumUUID', default=uuid.uuid4, max_length=36, unique=True)),
                ('amount', models.DecimalField(db_column='Amount', decimal_places=2, max_digits=18)),
                ('receipt', models.CharField(db_column='Receipt', max_length=50)),
                ('pay_date', core.fields.DateField(db_column='PayDate')),
                ('pay_type', models.CharField(choices=[('B', 'Bank transfer'), ('C', 'Cash'), ('M', 'Mobile phone'), ('F', 'Funding')], db_column='PayType', max_length=1)),
                ('is_photo_fee', models.BooleanField(blank=True, db_column='isPhotoFee', null=True)),
                ('is_offline', models.BooleanField(blank=True, db_column='isOffline', null=True)),
                ('reporting_id', models.IntegerField(blank=True, db_column='ReportingId', null=True)),
                ('audit_user_id', models.IntegerField(db_column='AuditUserID')),
            ],
            options={
                'db_table': 'tblPremium',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='PremiumMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='premiums', to='core.MutationLog')),
                ('premium', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='contribution.Premium')),
            ],
            options={
                'db_table': 'contribution_PremiumMutation',
                'managed': True,
            },
        ),
    ]
