# Tests for the decoder package.
from typing import Dict

import pytest

pytestmark = pytest.mark.unit

from decoder import decoder


def test_jinja2_3_0_decode():
    # Arrange
    text: str = "foo={{ foo }}, bar={{ bar }}, baz={{ baz }}"
    field_map: Dict = {"foo": 1, "bar": 2, "baz": 3}
    expected_text: str = "foo=1, bar=2, baz=3"

    # Act
    rendered, success = decoder.decode(
        text, field_map, "text", decoder.TextEncoding.JINJA2_3_0
    )

    # Assert
    assert success
    assert rendered == expected_text


def test_jinja2_3_0_decode_with_missing_variables():
    # Arrange
    text: str = "foo={{ foo }}, bar={{ bar }}, baz={{ baz }}"
    field_map: Dict = {"foo": 1, "bar": 2}

    # Act
    rendered, success = decoder.decode(
        text, field_map, "text", decoder.TextEncoding.JINJA2_3_0
    )

    # Assert
    assert not success
    assert rendered == "Undefined template variables for text: baz"


def test_jinja2_3_0_decode_without_variables():
    # Arrange
    text: str = "foo=1, bar=2, baz=3"
    expected_text: str = "foo=1, bar=2, baz=3"

    # Act
    rendered, success = decoder.decode(
        text, None, "text", decoder.TextEncoding.JINJA2_3_0
    )

    # Assert
    assert success
    assert rendered == expected_text
