/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.udf;

import com.alibaba.alink.executor.python.PythonUdfFactory;
import com.alibaba.alink.executor.util.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.BatchTableEnvironment;
import org.apache.flink.table.api.java.StreamTableEnvironment;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<UdfConfigT> udfList = new ArrayList<UdfConfigT>();
    final List<ResourceInfoT> resourceList = new ArrayList<ResourceInfoT>();

    public UdfManager(JsonArray resources, JsonArray udfList) {
        JsonObject x;
        HashMap<Long, JsonObject> resHash = new HashMap<Long, JsonObject>();
        if (resources != null) {
            for (JsonElement e : resources) {
                x = e.getAsJsonObject();
                if (x.has("id")) {
                    Long id = x.get("id").getAsLong();
                    resHash.put(id, x);
                }
                this.resourceList.add(ResourceInfoT.fromJsonObject(x));
            }
        }
        if (udfList == null) {
            return;
        }
        for (JsonElement e : udfList) {
            Long resId;
            x = e.getAsJsonObject();
            UdfConfigT config = new UdfConfigT();
            config.name = x.get("name").getAsString();
            if (x.has("className")) {
                config.className = x.get("className").getAsString();
            } else if (x.has("classObject")) {
                config.classObject = x.get("classObject").getAsString();
                config.classObjectType = x.get("classObjectType").getAsString();
            } else {
                throw new RuntimeException("Missing classInfo in udf:" + config.name);
            }
            config.language = x.get("language").getAsString();
            config.resultType = x.get("resultType").getAsString();
            config.type = x.has("udfType") ? x.get("udfType").getAsString() : x.get("type").getAsString();
            config.paths = new String[0];
            if (x.has("resourceId") && resHash.containsKey(resId = Long.valueOf(x.get("resourceId").getAsLong()))) {
                config.paths = new String[]{((JsonObject)resHash.get(resId)).get("name").getAsString()};
            }
            this.udfList.add(config);
        }
    }

    public String stringifyResourceList() {
        return new Gson().toJson(this.resourceList);
    }

    public static List<ResourceInfoT> parseResourceList(String str) {
        TypeToken<List<ResourceInfoT>> typeToken = new TypeToken<List<ResourceInfoT>>(){};
        return (List)new Gson().fromJson(str, typeToken.getType());
    }

    public static Map<String, ResourceInfoT> parseResourceConfig(String config) {
        if (StringUtils.isBlank((CharSequence)config)) {
            return Collections.emptyMap();
        }
        HashMap<String, ResourceInfoT> h = new HashMap<String, ResourceInfoT>();
        JsonObject json = new JsonParser().parse(config).getAsJsonObject();
        json.entrySet().forEach(x -> h.put((String)x.getKey(), ResourceInfoT.fromJsonObject(((JsonElement)x.getValue()).getAsJsonObject())));
        return h;
    }

    public String shipResources(ExecutionEnvironment env) throws IOException {
        return this.shipResources((arg_0, arg_1) -> ((ExecutionEnvironment)env).registerCachedFile(arg_0, arg_1));
    }

    public String shipResources(StreamExecutionEnvironment env) throws IOException {
        return this.shipResources((arg_0, arg_1) -> ((StreamExecutionEnvironment)env).registerCachedFile(arg_0, arg_1));
    }

    private String shipResources(BiConsumer<String, String> registerCachedFileFn) throws IOException {
        this.logger.info("begin to ship resources count:{}", (Object)this.resourceList.size());
        JsonObject ret = new JsonObject();
        for (ResourceInfoT r : this.resourceList) {
            if (r.path.startsWith("http://") || r.path.startsWith("https://")) {
                File f = File.createTempFile("tmp_alink_res", r.name);
                this.logger.info("begin to download resource name:{} path:{} to {}", new Object[]{r.name, r.path, f});
                FileUtils.copyURLToFile((URL)new URL(r.path), (File)f);
                registerCachedFileFn.accept(f.getAbsolutePath(), r.name);
                f.deleteOnExit();
                ret.add(r.name, (JsonElement)r.toJsonObject());
                this.logger.info("registered cache file with name:{} file:{}", (Object)r.name, (Object)f);
                continue;
            }
            if (r.path.startsWith("hdfs://") || r.path.startsWith("file:://")) {
                registerCachedFileFn.accept(r.path, r.name);
                ret.add(r.name, (JsonElement)r.toJsonObject());
                this.logger.info("registered cache file with name:{} file:{}", (Object)r.name, (Object)r.path);
                continue;
            }
            this.logger.warn("ignore ship resource: {}", (Object)r.toJsonObject().toString());
        }
        return ret.toString();
    }

    public void register(TableEnvironment env) {
        for (UdfConfigT c : this.udfList) {
            if (c.language.equalsIgnoreCase("python")) {
                this.registerPythonUdf(env, c);
                continue;
            }
            throw new RuntimeException("Unsupport language: " + c.language);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerPythonUdf(TableEnvironment env, UdfConfigT c) {
        if (c.type.equalsIgnoreCase("udf") || c.type.equalsIgnoreCase("ScalarFunction")) {
            ScalarFunction f = PythonUdfFactory.makeScalarFunction(c.name, c.resultType, c.toUdfJson());
            env.registerFunction(c.name, f);
            return;
        } else {
            if (!c.type.equalsIgnoreCase("udtf") && !c.type.equalsIgnoreCase("TableFunction")) throw new RuntimeException("not implement yet");
            TableFunction<Row> f = PythonUdfFactory.makeTableFunction(c.name, c.toUdfJson());
            if (env instanceof StreamTableEnvironment) {
                ((StreamTableEnvironment)env).registerFunction(c.name, f);
                return;
            } else {
                if (!(env instanceof BatchTableEnvironment)) throw new RuntimeException("env is not support.");
                ((BatchTableEnvironment)env).registerFunction(c.name, f);
            }
        }
    }

    public static class ResourceInfoT
    implements Serializable {
        public String name;
        public String type;
        public String path;
        public Long size = 0L;

        static ResourceInfoT fromJsonObject(JsonObject m) {
            ResourceInfoT x = new ResourceInfoT();
            x.name = m.get("name").getAsString();
            x.type = m.get("type").getAsString();
            x.path = m.get("path").getAsString();
            if (m.has("size")) {
                x.size = m.get("size").getAsLong();
            }
            return x;
        }

        public JsonObject toJsonObject() {
            JsonObject m = new JsonObject();
            m.addProperty("name", this.name);
            m.addProperty("type", this.type);
            m.addProperty("path", this.path);
            if (this.size != null && this.size > 0L) {
                m.addProperty("size", (Number)this.size);
            }
            return m;
        }
    }

    public static class UdfConfigT
    implements Serializable {
        public String name;
        public String language;
        public String[] paths;
        public String className;
        public String classObject;
        public String classObjectType;
        public String resultType;
        public String type;

        public String toUdfJson() {
            JsonObject m = new JsonObject();
            m.addProperty("language", this.language);
            m.add("paths", JsonUtil.gson.toJsonTree((Object)this.paths));
            if (this.className != null) {
                m.addProperty("className", this.className);
            } else {
                m.addProperty("classObject", this.classObject);
                m.addProperty("classObjectType", this.classObjectType);
            }
            m.addProperty("resultType", this.resultType);
            return m.toString();
        }
    }
}

