[![Build Status](https://travis-ci.org/rantanevich/MobilePASSER.svg?branch=python)](https://travis-ci.org/rantanevich/MobilePASSER)

MobilePASSER is a tool that generates OTP based on Activation Code from SafeNet MobilePASS.

SafeNet MobilePASS does not use time-based algorithm. It uses a counter which saves its state in the file. When we push "Generate Passcode" the couter retrieves last state from the file, incremets value, generates token and saves state into the file.

You can find more details in the article: [http://sbudella.altervista.org/blog/20180128-mobilepass.html](http://sbudella.altervista.org/blog/20180128-mobilepass.html)

Requirements
------------

You need Python 3.6.1 or later. 

Quick start
------------



```
python setup.py install
```

Usage
-----

```
usage: mobilepass.py [-h] -k KEY [-i INDEX] -p POLICY

Generate one-time passcodes based on activation code

optional arguments:
  -h, --help            show this help message and exit
  -k KEY, --key KEY     Activation Code is generated by SafeNet MobilePASS
  -i INDEX, --index INDEX
                        The index number of the one-time passcode
  -p POLICY, --policy POLICY
                        Token policy string
```

Tests
-----

```
python -m unittest
```

Configuration
-------------
The configuration file

```
[MobilePASS]
ActivationCode  = QVKYC-FM6KO-SY6F7-TR22W
Policy          =
Index           = 0
AutoUpdateIndex = true
```