# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nton']

package_data = \
{'': ['*'], 'nton': ['assets/exefs/*', 'assets/logo/*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'click>=8.1.3,<9.0.0',
 'coloredlogs>=15.0.1,<16.0.0',
 'jsonpickle>=2.2.0,<3.0.0',
 'requests>=2.28.1,<3.0.0']

entry_points = \
{'console_scripts': ['nton = nton.main:main']}

setup_kwargs = {
    'name': 'nton',
    'version': '1.1.0',
    'description': 'Nintendo Switch NRO to NSP Forwarder.',
    'long_description': '# NTON\n\n[![Build status](https://github.com/rlaphoenix/nton/actions/workflows/ci.yml/badge.svg)](https://github.com/rlaphoenix/nton/actions/workflows/ci.yml)\n[![PyPI version](https://img.shields.io/pypi/v/nton)](https://pypi.python.org/pypi/nton)\n[![Python versions](https://img.shields.io/pypi/pyversions/nton)](https://pypi.python.org/pypi/nton)\n<a href="https://github.com/rlaphoenix/nton/blob/master/LICENSE">\n  <img align="right" src="https://img.shields.io/badge/license-GPLv3-blue" alt="License (GPLv3)"/>\n</a>\n\nNTON is a Nintendo Switch NRO to NSP Forwarder for firmware 12.0.0 and newer.\n\nA forwarder lets you open a Homebrew NRO file from your SD card through the Nintendo Switch Home Screen instead\nof the Homebrew Launcher.\n\n![Preview of 4x Forwarders](https://user-images.githubusercontent.com/17136956/201314901-4a34a4dc-800b-44ba-beb8-333b6c37ebb6.jpg)  \n*Preview of 4x Forwarders made with NTON.*\n\nThe exefs ROM used is the one by [meliodas2255] which was based on or inspired by the original v12.0.0 ROM by [mpham].\nBoth ROMs are supported as they use the same romfs structure for specifying which NRO to load from the microSD card.\nSimply replace the assets in the `/assets/exefs` folder with the [original ROM][ROM]\'s exefs files.\n\n## Features\n\n- 🛡️ Safety-first approach; System/Game Title IDs cannot be used and NRO files are validated\n- 🕹️ Boot right into an Emulated Game with Direct RetroArch Game Forwarding\n- 🖼️ Supports any Image file of any resolution or format for the NSP Icon\n- 🤖 The Title Name, Publisher, Icon, and more are automatically extracted from the NRO\n- 🎥 Supports Video Capture and Screenshots\n- ⚙ Currently Supports Firmware 12.0.0 and up\n- 🧩 Plug-and-play installation via PIP/PyPI\n- ❤️ Forever FOSS!\n\n## Installation\n\n*Note: Requires [Python] 3.7.0 or newer with PIP installed.*\n\n```shell\n$ pip install nton\n```\n\nYou now have the `nton` package installed and a `nton` executable is now available.\nCheck it out with `nton --help` - Voilà 🎉!\n\n*If you see any warnings about a path not being in your PATH environment variable, add it, or `nton` won\'t run.*\n\n### Dependencies\n\nThe following is a list of programs required to be installed manually.  \nI recommend installing these with [winget] or [chocolatey] where possible as it automatically adds them to your\n`PATH` environment variable and will be easier to update in the future.\n\n- [hacBrewPack] for packing the NSP.\n- [ImageMagick] for Icon conversion and preparation.\n- [nstool] for NRO extraction and verification.\n\nFor portable downloads, make sure you put them in your current working directory, in the installation directory,\nor put the directory path in your `PATH` environment variable. If you do not do this then NTON will not be able to\nfind any of the binaries.\n\n  [winget]: <https://winget.run>\n  [chocolatey]: <https://chocolatey.org>\n  [hacBrewPack]: <https://github.com/The-4n/hacBrewPack>\n  [ImageMagick]: <https://imagemagick.org/script/download.php>\n  [nstool]: <https://github.com/jakcron/nstool>\n\n### Keys\n\nNTON requires the use of proprietary key data for use in various ways.\n\nPlace your `prod.keys` file at `C:\\Users\\<User>\\.switch\\prod.keys` or in your current working directory for\nNTON to be able to find and use your keys.\n\nMake sure your `prod.keys` file is up-to-date for the firmware version your Nintendo Switch is on. It can be extracted\nfrom your Nintendo Switch with [Lockpick_RCM](https://github.com/shchmue/Lockpick_RCM).\n\n### From Source Code\n\nThe following steps are instructions on downloading, preparing, and running the code under a Poetry environment.\nYou can skip steps 3-5 with a simple `pip install .` call instead, but you miss out on a wide array of benefits.\n\n1. `git clone https://github.com/rlaphoenix/nton`\n2. `cd nton`\n3. (optional) `poetry config virtualenvs.in-project true` \n4. `poetry install`\n5. `poetry run nton --help`\n\nAs seen in Step 5, running the `nton` executable is somewhat different to a normal PIP installation.\nSee [Poetry\'s Docs] on various ways of making calls under the virtual-environment.\n\n  [Python]: <https://python.org>\n  [Poetry]: <https://python-poetry.org>\n  [Poetry\'s Docs]: <https://python-poetry.org/docs/basic-usage/#using-your-virtual-environment>\n\n## Usage\n\nTake a look at `nton --help`, specifically `nton build --help`.  \nIf you simply want to take an NRO and get an NSP forwarder, simply run `nton build "<nro path>"`.\n\nNote that the NRO path MUST be on your Switch microSD card. Do not provide a path in your C:/ Drive or such.\nTwo different kinds of paths are used based on the initial file path, therefore it must be from your Switch microSD\ncard.\n\nE.g., to make a forwarder for the Homebrew Menu that\'s on your Switch\'s microSD at `D:\\hbmenu.nro`, simply run\n`nton build "D:/hbmenu.nro"`\n\nTake a look at `nton build --help` for advanced usage like changing the Icon, Title Name, and so on.\n\n### Direct RetroArch Game forwarding\n\nUse a RetroArch Game Core as the NRO path and provide the path to the ROM on your Switch\'s microSD card with `--rom`.  \nThis will then load the Core directly under RetroArch and provide the path to the ROM as a startup argument to the\nRetroArch Core.\n\nNote:\n\n- You must use a path to a RetroArch Game Core NRO, not the path to the RetroArch NRO itself.\n- Do not move, delete, or rename the ROM or the Core NRO files that are on your microSD card, or it will break.\n\n## To-do\n\n- [X] Rewrite as a Python script to heavily improve the user experience and code.\n- [X] Combine the Drive letter and Path arguments and manually split them when they need to be separate instead.\n- [X] Automate name and publisher by extracting from the extracted `control.nacp`.\n- [X] Force enable video capture and screenshots in the extracted `control.nacp`.\n- [x] Add support for direct RetroArch Game Forwarding.\n- [ ] Force disable save data allocation. Fixed in [v3.3.5 of Nro2NSP](https://github.com/Root-MtX/Nro2Nsp/releases/tag/3.3.5).\n- [ ] Maybe a new GUI one day, and let you override the icons and such?\n\n## Troubleshooting\n\nBefore continuing try running the homebrew from the Homebrew Launcher and see if it works through there.\nIf it does not work through the Homebrew launcher either, then it was never the forwarder\'s fault and you should\ncheck on your NRO or application installation.\n\nPlease note that using Forwarders others have created has a good chance of not working on your system.\nThe location of the NRO on their system may differ from the location on your system, hence the NSP won\'t be able\nto load the homebrew.\n\n### The forwarder does not launch, "The software was closed because an error occurred."\n\nYou\'re sigpatches that allow non-signed software to launch is outdated or not set up correctly.\nThe `prod.keys` you used to create the NSP may also be outdated. Get new ones with [Lockpick_RCM] and\nmake sure you choose to get keys from whichever SysNAND or EmuNAND is actually on the latest firmware.\n\n### The forwarder starts loading but then crashes\n\nIf it gets to the black loading screen with the Nintendo Switch logo, but then crashes, you may be setting\nthe NRO path wrong when making the NSP. Make sure it starts with `/` and is an absolute path to an existing\nNRO file on your Switch\'s microSD card. The path you built for must be where the NRO file lies in your Switch\'s\nmicroSD card, not your PC.\n\n### The forwarder\'s icon is a \'?\'\n\nThe `icon_AmericanEnglish.dat` is not to the spec that Nintendo likes in some way. This is usually caused by the format of the\nimage not being a JPEG, or it has EXIF data or an embedded color space.\n\nI recommend stripping all EXIF metadata and saving without an Embed Color Space. You can do this quickly with ImageMagick,\n`magick mogrify -format jpg -resize 256x256 -strip "C:\\Users\\John\\Downloads\\icon.png"`.\n\n### The forwarder randomly stopped working after a while, I changed nothing!\n\nYou most likely updated your Switch\'s Firmware and need to update your sigpatches. If not, you may have deleted the NRO from\nyour Switch\'s microSD card or moved the NRO somewhere else. It cannot be moved as the built NSP loads the NRO at the specified\npath when you ran `build`.\n\nIt\'s also possible the firmware update has broken the [forwarder ROM][ROM] that is used and needs to be fixed.\nFirmware 9.0.0 and 12.0.0 are times the firmware has broken different forwarder ROMs in the past.\n\n## Credit\n\n- [Martin Pham (mpham)][mpham] for the [original forwarder ROM][ROM] supporting v12.0.0+, and original batch script.\n- [meliodas2255] for [their forwarder ROM][ROM2] also supporting v12.0.0+ compiled with the latest hbl-loader as of May\n  2021, with both direct RetroArch Forwarding and general forwarding support.\n\n  [mpham]: <https://gbatemp.net/members/mpham.537130>\n  [meliodas2255]: <https://gbatemp.net/members/meliodas2255.410353>\n  [ROM]: <https://gitlab.com/martinpham/NSP-Forwarder>\n  [ROM2]: <https://gbatemp.net/threads/nsp-forwarder-tool-for-12.587936/post-9468469>\n\n## License\n\n[GNU General Public License, Version 3.0](LICENSE)\n',
    'author': 'rlaphoenix',
    'author_email': 'rlaphoenix@pm.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/rlaphoenix/nton',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
