# coding: utf-8

"""
TileDB Storage Platform API

TileDB Storage Platform REST API  # noqa: E501

The version of the OpenAPI document: 2.17.51
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client.rest_api.configuration import Configuration


class GroupInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "namespace": "str",
        "name": "str",
        "description": "str",
        "uri": "str",
        "tiledb_uri": "str",
        "asset_count": "float",
        "group_count": "float",
        "size": "float",
        "last_accessed": "datetime",
        "allowed_actions": "list[GroupActions]",
        "group_type": "GroupType",
        "logo": "str",
        "access_credentials_name": "str",
        "share_count": "float",
        "public_share": "bool",
        "tags": "list[str]",
        "license_id": "str",
        "license_text": "str",
        "created_at": "datetime",
        "created_by": "str",
        "metadata": "list[MetadataStringifiedEntry]",
    }

    attribute_map = {
        "id": "id",
        "namespace": "namespace",
        "name": "name",
        "description": "description",
        "uri": "uri",
        "tiledb_uri": "tiledb_uri",
        "asset_count": "asset_count",
        "group_count": "group_count",
        "size": "size",
        "last_accessed": "last_accessed",
        "allowed_actions": "allowed_actions",
        "group_type": "group_type",
        "logo": "logo",
        "access_credentials_name": "access_credentials_name",
        "share_count": "share_count",
        "public_share": "public_share",
        "tags": "tags",
        "license_id": "license_id",
        "license_text": "license_text",
        "created_at": "created_at",
        "created_by": "created_by",
        "metadata": "metadata",
    }

    def __init__(
        self,
        id=None,
        namespace=None,
        name=None,
        description=None,
        uri=None,
        tiledb_uri=None,
        asset_count=None,
        group_count=None,
        size=None,
        last_accessed=None,
        allowed_actions=None,
        group_type=None,
        logo=None,
        access_credentials_name=None,
        share_count=None,
        public_share=None,
        tags=None,
        license_id=None,
        license_text=None,
        created_at=None,
        created_by=None,
        metadata=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """GroupInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._namespace = None
        self._name = None
        self._description = None
        self._uri = None
        self._tiledb_uri = None
        self._asset_count = None
        self._group_count = None
        self._size = None
        self._last_accessed = None
        self._allowed_actions = None
        self._group_type = None
        self._logo = None
        self._access_credentials_name = None
        self._share_count = None
        self._public_share = None
        self._tags = None
        self._license_id = None
        self._license_text = None
        self._created_at = None
        self._created_by = None
        self._metadata = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if namespace is not None:
            self.namespace = namespace
        if name is not None:
            self.name = name
        self.description = description
        if uri is not None:
            self.uri = uri
        if tiledb_uri is not None:
            self.tiledb_uri = tiledb_uri
        if asset_count is not None:
            self.asset_count = asset_count
        if group_count is not None:
            self.group_count = group_count
        if size is not None:
            self.size = size
        if last_accessed is not None:
            self.last_accessed = last_accessed
        if allowed_actions is not None:
            self.allowed_actions = allowed_actions
        if group_type is not None:
            self.group_type = group_type
        if logo is not None:
            self.logo = logo
        if access_credentials_name is not None:
            self.access_credentials_name = access_credentials_name
        if share_count is not None:
            self.share_count = share_count
        if public_share is not None:
            self.public_share = public_share
        if tags is not None:
            self.tags = tags
        if license_id is not None:
            self.license_id = license_id
        if license_text is not None:
            self.license_text = license_text
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if metadata is not None:
            self.metadata = metadata

    @property
    def id(self):
        """Gets the id of this GroupInfo.  # noqa: E501

        unique ID of registered group  # noqa: E501

        :return: The id of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GroupInfo.

        unique ID of registered group  # noqa: E501

        :param id: The id of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def namespace(self):
        """Gets the namespace of this GroupInfo.  # noqa: E501

        namespace group is in  # noqa: E501

        :return: The namespace of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this GroupInfo.

        namespace group is in  # noqa: E501

        :param namespace: The namespace of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._namespace = namespace

    @property
    def name(self):
        """Gets the name of this GroupInfo.  # noqa: E501

        name of group  # noqa: E501

        :return: The name of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GroupInfo.

        name of group  # noqa: E501

        :param name: The name of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this GroupInfo.  # noqa: E501

        description of group  # noqa: E501

        :return: The description of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GroupInfo.

        description of group  # noqa: E501

        :param description: The description of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def uri(self):
        """Gets the uri of this GroupInfo.  # noqa: E501

        uri of group  # noqa: E501

        :return: The uri of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this GroupInfo.

        uri of group  # noqa: E501

        :param uri: The uri of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def tiledb_uri(self):
        """Gets the tiledb_uri of this GroupInfo.  # noqa: E501

        uri for access through TileDB cloud  # noqa: E501

        :return: The tiledb_uri of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._tiledb_uri

    @tiledb_uri.setter
    def tiledb_uri(self, tiledb_uri):
        """Sets the tiledb_uri of this GroupInfo.

        uri for access through TileDB cloud  # noqa: E501

        :param tiledb_uri: The tiledb_uri of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._tiledb_uri = tiledb_uri

    @property
    def asset_count(self):
        """Gets the asset_count of this GroupInfo.  # noqa: E501

        A count of direct array members  # noqa: E501

        :return: The asset_count of this GroupInfo.  # noqa: E501
        :rtype: float
        """
        return self._asset_count

    @asset_count.setter
    def asset_count(self, asset_count):
        """Sets the asset_count of this GroupInfo.

        A count of direct array members  # noqa: E501

        :param asset_count: The asset_count of this GroupInfo.  # noqa: E501
        :type: float
        """

        self._asset_count = asset_count

    @property
    def group_count(self):
        """Gets the group_count of this GroupInfo.  # noqa: E501

        A count of direct group members  # noqa: E501

        :return: The group_count of this GroupInfo.  # noqa: E501
        :rtype: float
        """
        return self._group_count

    @group_count.setter
    def group_count(self, group_count):
        """Sets the group_count of this GroupInfo.

        A count of direct group members  # noqa: E501

        :param group_count: The group_count of this GroupInfo.  # noqa: E501
        :type: float
        """

        self._group_count = group_count

    @property
    def size(self):
        """Gets the size of this GroupInfo.  # noqa: E501

        A count of direct members. This is the sum of asset_count and group_count  # noqa: E501

        :return: The size of this GroupInfo.  # noqa: E501
        :rtype: float
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this GroupInfo.

        A count of direct members. This is the sum of asset_count and group_count  # noqa: E501

        :param size: The size of this GroupInfo.  # noqa: E501
        :type: float
        """

        self._size = size

    @property
    def last_accessed(self):
        """Gets the last_accessed of this GroupInfo.  # noqa: E501

        Datetime groups was last accessed in UTC  # noqa: E501

        :return: The last_accessed of this GroupInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._last_accessed

    @last_accessed.setter
    def last_accessed(self, last_accessed):
        """Sets the last_accessed of this GroupInfo.

        Datetime groups was last accessed in UTC  # noqa: E501

        :param last_accessed: The last_accessed of this GroupInfo.  # noqa: E501
        :type: datetime
        """

        self._last_accessed = last_accessed

    @property
    def allowed_actions(self):
        """Gets the allowed_actions of this GroupInfo.  # noqa: E501

        list of actions user is allowed to do on this group  # noqa: E501

        :return: The allowed_actions of this GroupInfo.  # noqa: E501
        :rtype: list[GroupActions]
        """
        return self._allowed_actions

    @allowed_actions.setter
    def allowed_actions(self, allowed_actions):
        """Sets the allowed_actions of this GroupInfo.

        list of actions user is allowed to do on this group  # noqa: E501

        :param allowed_actions: The allowed_actions of this GroupInfo.  # noqa: E501
        :type: list[GroupActions]
        """

        self._allowed_actions = allowed_actions

    @property
    def group_type(self):
        """Gets the group_type of this GroupInfo.  # noqa: E501


        :return: The group_type of this GroupInfo.  # noqa: E501
        :rtype: GroupType
        """
        return self._group_type

    @group_type.setter
    def group_type(self, group_type):
        """Sets the group_type of this GroupInfo.


        :param group_type: The group_type of this GroupInfo.  # noqa: E501
        :type: GroupType
        """

        self._group_type = group_type

    @property
    def logo(self):
        """Gets the logo of this GroupInfo.  # noqa: E501

        logo (base64 encoded) for the gruop. Optional  # noqa: E501

        :return: The logo of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._logo

    @logo.setter
    def logo(self, logo):
        """Sets the logo of this GroupInfo.

        logo (base64 encoded) for the gruop. Optional  # noqa: E501

        :param logo: The logo of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._logo = logo

    @property
    def access_credentials_name(self):
        """Gets the access_credentials_name of this GroupInfo.  # noqa: E501

        the name of the access credentials to use. if unset, the default credentials will be used  # noqa: E501

        :return: The access_credentials_name of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._access_credentials_name

    @access_credentials_name.setter
    def access_credentials_name(self, access_credentials_name):
        """Sets the access_credentials_name of this GroupInfo.

        the name of the access credentials to use. if unset, the default credentials will be used  # noqa: E501

        :param access_credentials_name: The access_credentials_name of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._access_credentials_name = access_credentials_name

    @property
    def share_count(self):
        """Gets the share_count of this GroupInfo.  # noqa: E501

        number of unique namespaces this group is shared with  # noqa: E501

        :return: The share_count of this GroupInfo.  # noqa: E501
        :rtype: float
        """
        return self._share_count

    @share_count.setter
    def share_count(self, share_count):
        """Sets the share_count of this GroupInfo.

        number of unique namespaces this group is shared with  # noqa: E501

        :param share_count: The share_count of this GroupInfo.  # noqa: E501
        :type: float
        """

        self._share_count = share_count

    @property
    def public_share(self):
        """Gets the public_share of this GroupInfo.  # noqa: E501

        Suggests if the group was shared to public by owner  # noqa: E501

        :return: The public_share of this GroupInfo.  # noqa: E501
        :rtype: bool
        """
        return self._public_share

    @public_share.setter
    def public_share(self, public_share):
        """Sets the public_share of this GroupInfo.

        Suggests if the group was shared to public by owner  # noqa: E501

        :param public_share: The public_share of this GroupInfo.  # noqa: E501
        :type: bool
        """

        self._public_share = public_share

    @property
    def tags(self):
        """Gets the tags of this GroupInfo.  # noqa: E501

        optional tags for group  # noqa: E501

        :return: The tags of this GroupInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this GroupInfo.

        optional tags for group  # noqa: E501

        :param tags: The tags of this GroupInfo.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def license_id(self):
        """Gets the license_id of this GroupInfo.  # noqa: E501

        License identifier from SPDX License List or Custom  # noqa: E501

        :return: The license_id of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._license_id

    @license_id.setter
    def license_id(self, license_id):
        """Sets the license_id of this GroupInfo.

        License identifier from SPDX License List or Custom  # noqa: E501

        :param license_id: The license_id of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._license_id = license_id

    @property
    def license_text(self):
        """Gets the license_text of this GroupInfo.  # noqa: E501

        License text  # noqa: E501

        :return: The license_text of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._license_text

    @license_text.setter
    def license_text(self, license_text):
        """Sets the license_text of this GroupInfo.

        License text  # noqa: E501

        :param license_text: The license_text of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._license_text = license_text

    @property
    def created_at(self):
        """Gets the created_at of this GroupInfo.  # noqa: E501

        Datetime the group was registered with tiledb  # noqa: E501

        :return: The created_at of this GroupInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this GroupInfo.

        Datetime the group was registered with tiledb  # noqa: E501

        :param created_at: The created_at of this GroupInfo.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this GroupInfo.  # noqa: E501

        The username of the group's creator, if known.  # noqa: E501

        :return: The created_by of this GroupInfo.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this GroupInfo.

        The username of the group's creator, if known.  # noqa: E501

        :param created_by: The created_by of this GroupInfo.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def metadata(self):
        """Gets the metadata of this GroupInfo.  # noqa: E501

        Contains metadata of the group. **Note:** This property is included in the response only if the `with_metadata` query parameter is set to `true`.   # noqa: E501

        :return: The metadata of this GroupInfo.  # noqa: E501
        :rtype: list[MetadataStringifiedEntry]
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this GroupInfo.

        Contains metadata of the group. **Note:** This property is included in the response only if the `with_metadata` query parameter is set to `true`.   # noqa: E501

        :param metadata: The metadata of this GroupInfo.  # noqa: E501
        :type: list[MetadataStringifiedEntry]
        """

        self._metadata = metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GroupInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GroupInfo):
            return True

        return self.to_dict() != other.to_dict()
