# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class UserCreateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "display_name": "str",
        "email": "str",
        "username": "str",
        "password": "str",
        "timezone": "str",
        "image": "str",
        "invitation_token": "str",
    }

    attribute_map = {
        "display_name": "display_name",
        "email": "email",
        "username": "username",
        "password": "password",
        "timezone": "timezone",
        "image": "image",
        "invitation_token": "invitation_token",
    }

    def __init__(
        self,
        display_name=None,
        email=None,
        username=None,
        password=None,
        timezone=None,
        image=None,
        invitation_token=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """UserCreateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._display_name = None
        self._email = None
        self._username = None
        self._password = None
        self._timezone = None
        self._image = None
        self._invitation_token = None
        self.discriminator = None

        if display_name is not None:
            self.display_name = display_name
        self.email = email
        self.username = username
        self.password = password
        if timezone is not None:
            self.timezone = timezone
        if image is not None:
            self.image = image
        if invitation_token is not None:
            self.invitation_token = invitation_token

    @property
    def display_name(self):
        """Gets the display_name of this UserCreateRequest.  # noqa: E501

        display name of the user shown everywhere  # noqa: E501

        :return: The display_name of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this UserCreateRequest.

        display name of the user shown everywhere  # noqa: E501

        :param display_name: The display_name of this UserCreateRequest.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def email(self):
        """Gets the email of this UserCreateRequest.  # noqa: E501

        user email  # noqa: E501

        :return: The email of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserCreateRequest.

        user email  # noqa: E501

        :param email: The email of this UserCreateRequest.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and email is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `email`, must not be `None`"
            )  # noqa: E501

        self._email = email

    @property
    def username(self):
        """Gets the username of this UserCreateRequest.  # noqa: E501

        username that can be logged in with  # noqa: E501

        :return: The username of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this UserCreateRequest.

        username that can be logged in with  # noqa: E501

        :param username: The username of this UserCreateRequest.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and username is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `username`, must not be `None`"
            )  # noqa: E501

        self._username = username

    @property
    def password(self):
        """Gets the password of this UserCreateRequest.  # noqa: E501

        password for the user  # noqa: E501

        :return: The password of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this UserCreateRequest.

        password for the user  # noqa: E501

        :param password: The password of this UserCreateRequest.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and password is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `password`, must not be `None`"
            )  # noqa: E501

        self._password = password

    @property
    def timezone(self):
        """Gets the timezone of this UserCreateRequest.  # noqa: E501

        user timezone  # noqa: E501

        :return: The timezone of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """Sets the timezone of this UserCreateRequest.

        user timezone  # noqa: E501

        :param timezone: The timezone of this UserCreateRequest.  # noqa: E501
        :type: str
        """

        self._timezone = timezone

    @property
    def image(self):
        """Gets the image of this UserCreateRequest.  # noqa: E501

        Image data in the form data:image/png;base64,iVBORw0KGgoAAAA  # noqa: E501

        :return: The image of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this UserCreateRequest.

        Image data in the form data:image/png;base64,iVBORw0KGgoAAAA  # noqa: E501

        :param image: The image of this UserCreateRequest.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def invitation_token(self):
        """Gets the invitation_token of this UserCreateRequest.  # noqa: E501

        The user's workspace invitation token. This is necessary if new user signup is restricted to invited users.   # noqa: E501

        :return: The invitation_token of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._invitation_token

    @invitation_token.setter
    def invitation_token(self, invitation_token):
        """Sets the invitation_token of this UserCreateRequest.

        The user's workspace invitation token. This is necessary if new user signup is restricted to invited users.   # noqa: E501

        :param invitation_token: The invitation_token of this UserCreateRequest.  # noqa: E501
        :type: str
        """

        self._invitation_token = invitation_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
