# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class TeamspaceUser(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "user_id": "str",
        "username": "str",
        "display_name": "str",
        "email": "str",
        "image_id": "str",
        "role": "TeamspaceRole",
        "added_by": "str",
        "created_at": "datetime",
        "deleted_at": "datetime",
    }

    attribute_map = {
        "user_id": "user_id",
        "username": "username",
        "display_name": "display_name",
        "email": "email",
        "image_id": "image_id",
        "role": "role",
        "added_by": "added_by",
        "created_at": "created_at",
        "deleted_at": "deleted_at",
    }

    def __init__(
        self,
        user_id=None,
        username=None,
        display_name=None,
        email=None,
        image_id=None,
        role=None,
        added_by=None,
        created_at=None,
        deleted_at=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TeamspaceUser - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._user_id = None
        self._username = None
        self._display_name = None
        self._email = None
        self._image_id = None
        self._role = None
        self._added_by = None
        self._created_at = None
        self._deleted_at = None
        self.discriminator = None

        self.user_id = user_id
        self.username = username
        self.display_name = display_name
        self.email = email
        if image_id is not None:
            self.image_id = image_id
        self.role = role
        self.added_by = added_by
        self.created_at = created_at
        if deleted_at is not None:
            self.deleted_at = deleted_at

    @property
    def user_id(self):
        """Gets the user_id of this TeamspaceUser.  # noqa: E501

        The user's ID  # noqa: E501

        :return: The user_id of this TeamspaceUser.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this TeamspaceUser.

        The user's ID  # noqa: E501

        :param user_id: The user_id of this TeamspaceUser.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and user_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `user_id`, must not be `None`"
            )  # noqa: E501

        self._user_id = user_id

    @property
    def username(self):
        """Gets the username of this TeamspaceUser.  # noqa: E501

        The user's username  # noqa: E501

        :return: The username of this TeamspaceUser.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this TeamspaceUser.

        The user's username  # noqa: E501

        :param username: The username of this TeamspaceUser.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and username is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `username`, must not be `None`"
            )  # noqa: E501

        self._username = username

    @property
    def display_name(self):
        """Gets the display_name of this TeamspaceUser.  # noqa: E501

        The user's display name  # noqa: E501

        :return: The display_name of this TeamspaceUser.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this TeamspaceUser.

        The user's display name  # noqa: E501

        :param display_name: The display_name of this TeamspaceUser.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and display_name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `display_name`, must not be `None`"
            )  # noqa: E501

        self._display_name = display_name

    @property
    def email(self):
        """Gets the email of this TeamspaceUser.  # noqa: E501

        The user's email  # noqa: E501

        :return: The email of this TeamspaceUser.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this TeamspaceUser.

        The user's email  # noqa: E501

        :param email: The email of this TeamspaceUser.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and email is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `email`, must not be `None`"
            )  # noqa: E501

        self._email = email

    @property
    def image_id(self):
        """Gets the image_id of this TeamspaceUser.  # noqa: E501

        The image's ID  # noqa: E501

        :return: The image_id of this TeamspaceUser.  # noqa: E501
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this TeamspaceUser.

        The image's ID  # noqa: E501

        :param image_id: The image_id of this TeamspaceUser.  # noqa: E501
        :type: str
        """

        self._image_id = image_id

    @property
    def role(self):
        """Gets the role of this TeamspaceUser.  # noqa: E501


        :return: The role of this TeamspaceUser.  # noqa: E501
        :rtype: TeamspaceRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this TeamspaceUser.


        :param role: The role of this TeamspaceUser.  # noqa: E501
        :type: TeamspaceRole
        """
        if (
            self.local_vars_configuration.client_side_validation and role is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `role`, must not be `None`"
            )  # noqa: E501

        self._role = role

    @property
    def added_by(self):
        """Gets the added_by of this TeamspaceUser.  # noqa: E501

        The user's ID  # noqa: E501

        :return: The added_by of this TeamspaceUser.  # noqa: E501
        :rtype: str
        """
        return self._added_by

    @added_by.setter
    def added_by(self, added_by):
        """Sets the added_by of this TeamspaceUser.

        The user's ID  # noqa: E501

        :param added_by: The added_by of this TeamspaceUser.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and added_by is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `added_by`, must not be `None`"
            )  # noqa: E501

        self._added_by = added_by

    @property
    def created_at(self):
        """Gets the created_at of this TeamspaceUser.  # noqa: E501

        The datetime the teamspace user was created (in UTC)  # noqa: E501

        :return: The created_at of this TeamspaceUser.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this TeamspaceUser.

        The datetime the teamspace user was created (in UTC)  # noqa: E501

        :param created_at: The created_at of this TeamspaceUser.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and created_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_at`, must not be `None`"
            )  # noqa: E501

        self._created_at = created_at

    @property
    def deleted_at(self):
        """Gets the deleted_at of this TeamspaceUser.  # noqa: E501

        The datetime the teamspace user was deleted (in UTC)  # noqa: E501

        :return: The deleted_at of this TeamspaceUser.  # noqa: E501
        :rtype: datetime
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this TeamspaceUser.

        The datetime the teamspace user was deleted (in UTC)  # noqa: E501

        :param deleted_at: The deleted_at of this TeamspaceUser.  # noqa: E501
        :type: datetime
        """

        self._deleted_at = deleted_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TeamspaceUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TeamspaceUser):
            return True

        return self.to_dict() != other.to_dict()
