# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class PaginationMetadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "page": "int",
        "per_page": "int",
        "total_pages": "int",
        "total_items": "int",
    }

    attribute_map = {
        "page": "page",
        "per_page": "per_page",
        "total_pages": "total_pages",
        "total_items": "total_items",
    }

    def __init__(
        self,
        page=None,
        per_page=None,
        total_pages=None,
        total_items=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """PaginationMetadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._page = None
        self._per_page = None
        self._total_pages = None
        self._total_items = None
        self.discriminator = None

        self.page = page
        self.per_page = per_page
        self.total_pages = total_pages
        self.total_items = total_items

    @property
    def page(self):
        """Gets the page of this PaginationMetadata.  # noqa: E501

        pagination offset. Use it to skip the first ((page - 1) * per_page) items  # noqa: E501

        :return: The page of this PaginationMetadata.  # noqa: E501
        :rtype: int
        """
        return self._page

    @page.setter
    def page(self, page):
        """Sets the page of this PaginationMetadata.

        pagination offset. Use it to skip the first ((page - 1) * per_page) items  # noqa: E501

        :param page: The page of this PaginationMetadata.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation and page is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `page`, must not be `None`"
            )  # noqa: E501

        self._page = page

    @property
    def per_page(self):
        """Gets the per_page of this PaginationMetadata.  # noqa: E501

        pagination limit (page size)  # noqa: E501

        :return: The per_page of this PaginationMetadata.  # noqa: E501
        :rtype: int
        """
        return self._per_page

    @per_page.setter
    def per_page(self, per_page):
        """Sets the per_page of this PaginationMetadata.

        pagination limit (page size)  # noqa: E501

        :param per_page: The per_page of this PaginationMetadata.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation and per_page is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `per_page`, must not be `None`"
            )  # noqa: E501

        self._per_page = per_page

    @property
    def total_pages(self):
        """Gets the total_pages of this PaginationMetadata.  # noqa: E501

        number of total pages with current limit  # noqa: E501

        :return: The total_pages of this PaginationMetadata.  # noqa: E501
        :rtype: int
        """
        return self._total_pages

    @total_pages.setter
    def total_pages(self, total_pages):
        """Sets the total_pages of this PaginationMetadata.

        number of total pages with current limit  # noqa: E501

        :param total_pages: The total_pages of this PaginationMetadata.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation and total_pages is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `total_pages`, must not be `None`"
            )  # noqa: E501

        self._total_pages = total_pages

    @property
    def total_items(self):
        """Gets the total_items of this PaginationMetadata.  # noqa: E501

        number of total available items  # noqa: E501

        :return: The total_items of this PaginationMetadata.  # noqa: E501
        :rtype: int
        """
        return self._total_items

    @total_items.setter
    def total_items(self, total_items):
        """Sets the total_items of this PaginationMetadata.

        number of total available items  # noqa: E501

        :param total_items: The total_items of this PaginationMetadata.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation and total_items is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `total_items`, must not be `None`"
            )  # noqa: E501

        self._total_items = total_items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaginationMetadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PaginationMetadata):
            return True

        return self.to_dict() != other.to_dict()
