# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class Invitation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "invitation_id": "str",
        "invitee_email": "str",
        "created_by": "InvitingUser",
        "created_at": "datetime",
        "workspace_invitation": "InvitationWorkspace",
    }

    attribute_map = {
        "invitation_id": "invitation_id",
        "invitee_email": "invitee_email",
        "created_by": "created_by",
        "created_at": "created_at",
        "workspace_invitation": "workspace_invitation",
    }

    def __init__(
        self,
        invitation_id=None,
        invitee_email=None,
        created_by=None,
        created_at=None,
        workspace_invitation=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Invitation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._invitation_id = None
        self._invitee_email = None
        self._created_by = None
        self._created_at = None
        self._workspace_invitation = None
        self.discriminator = None

        self.invitation_id = invitation_id
        self.invitee_email = invitee_email
        self.created_by = created_by
        self.created_at = created_at
        if workspace_invitation is not None:
            self.workspace_invitation = workspace_invitation

    @property
    def invitation_id(self):
        """Gets the invitation_id of this Invitation.  # noqa: E501

        The invitation's ID  # noqa: E501

        :return: The invitation_id of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._invitation_id

    @invitation_id.setter
    def invitation_id(self, invitation_id):
        """Sets the invitation_id of this Invitation.

        The invitation's ID  # noqa: E501

        :param invitation_id: The invitation_id of this Invitation.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and invitation_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `invitation_id`, must not be `None`"
            )  # noqa: E501

        self._invitation_id = invitation_id

    @property
    def invitee_email(self):
        """Gets the invitee_email of this Invitation.  # noqa: E501

        The invited user's email address  # noqa: E501

        :return: The invitee_email of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._invitee_email

    @invitee_email.setter
    def invitee_email(self, invitee_email):
        """Sets the invitee_email of this Invitation.

        The invited user's email address  # noqa: E501

        :param invitee_email: The invitee_email of this Invitation.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and invitee_email is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `invitee_email`, must not be `None`"
            )  # noqa: E501

        self._invitee_email = invitee_email

    @property
    def created_by(self):
        """Gets the created_by of this Invitation.  # noqa: E501


        :return: The created_by of this Invitation.  # noqa: E501
        :rtype: InvitingUser
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Invitation.


        :param created_by: The created_by of this Invitation.  # noqa: E501
        :type: InvitingUser
        """
        if (
            self.local_vars_configuration.client_side_validation and created_by is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_by`, must not be `None`"
            )  # noqa: E501

        self._created_by = created_by

    @property
    def created_at(self):
        """Gets the created_at of this Invitation.  # noqa: E501

        The date and time the invitation was created  # noqa: E501

        :return: The created_at of this Invitation.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Invitation.

        The date and time the invitation was created  # noqa: E501

        :param created_at: The created_at of this Invitation.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and created_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_at`, must not be `None`"
            )  # noqa: E501

        self._created_at = created_at

    @property
    def workspace_invitation(self):
        """Gets the workspace_invitation of this Invitation.  # noqa: E501


        :return: The workspace_invitation of this Invitation.  # noqa: E501
        :rtype: InvitationWorkspace
        """
        return self._workspace_invitation

    @workspace_invitation.setter
    def workspace_invitation(self, workspace_invitation):
        """Sets the workspace_invitation of this Invitation.


        :param workspace_invitation: The workspace_invitation of this Invitation.  # noqa: E501
        :type: InvitationWorkspace
        """

        self._workspace_invitation = workspace_invitation

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Invitation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Invitation):
            return True

        return self.to_dict() != other.to_dict()
