# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class FileListResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "prefix": "str",
        "delimiter": "str",
        "max_keys": "int",
        "continuation_token": "str",
        "next_continuation_token": "str",
        "is_truncated": "bool",
        "common_prefixes": "list[CommonPrefix]",
        "objects": "list[Object]",
    }

    attribute_map = {
        "name": "Name",
        "prefix": "Prefix",
        "delimiter": "Delimiter",
        "max_keys": "MaxKeys",
        "continuation_token": "ContinuationToken",
        "next_continuation_token": "NextContinuationToken",
        "is_truncated": "IsTruncated",
        "common_prefixes": "CommonPrefixes",
        "objects": "Objects",
    }

    def __init__(
        self,
        name=None,
        prefix=None,
        delimiter=None,
        max_keys=None,
        continuation_token=None,
        next_continuation_token=None,
        is_truncated=None,
        common_prefixes=None,
        objects=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """FileListResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._prefix = None
        self._delimiter = None
        self._max_keys = None
        self._continuation_token = None
        self._next_continuation_token = None
        self._is_truncated = None
        self._common_prefixes = None
        self._objects = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if prefix is not None:
            self.prefix = prefix
        if delimiter is not None:
            self.delimiter = delimiter
        if max_keys is not None:
            self.max_keys = max_keys
        if continuation_token is not None:
            self.continuation_token = continuation_token
        if next_continuation_token is not None:
            self.next_continuation_token = next_continuation_token
        if is_truncated is not None:
            self.is_truncated = is_truncated
        if common_prefixes is not None:
            self.common_prefixes = common_prefixes
        if objects is not None:
            self.objects = objects

    @property
    def name(self):
        """Gets the name of this FileListResponse.  # noqa: E501

        The name of the bucket (teamspace) with the objects  # noqa: E501

        :return: The name of this FileListResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FileListResponse.

        The name of the bucket (teamspace) with the objects  # noqa: E501

        :param name: The name of this FileListResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def prefix(self):
        """Gets the prefix of this FileListResponse.  # noqa: E501

        The prefix under which objects are listed  # noqa: E501

        :return: The prefix of this FileListResponse.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this FileListResponse.

        The prefix under which objects are listed  # noqa: E501

        :param prefix: The prefix of this FileListResponse.  # noqa: E501
        :type: str
        """

        self._prefix = prefix

    @property
    def delimiter(self):
        """Gets the delimiter of this FileListResponse.  # noqa: E501

        The string that delimits the path segments. Only forward slash is supported  # noqa: E501

        :return: The delimiter of this FileListResponse.  # noqa: E501
        :rtype: str
        """
        return self._delimiter

    @delimiter.setter
    def delimiter(self, delimiter):
        """Sets the delimiter of this FileListResponse.

        The string that delimits the path segments. Only forward slash is supported  # noqa: E501

        :param delimiter: The delimiter of this FileListResponse.  # noqa: E501
        :type: str
        """

        self._delimiter = delimiter

    @property
    def max_keys(self):
        """Gets the max_keys of this FileListResponse.  # noqa: E501

        The maximum amount of objects to return  # noqa: E501

        :return: The max_keys of this FileListResponse.  # noqa: E501
        :rtype: int
        """
        return self._max_keys

    @max_keys.setter
    def max_keys(self, max_keys):
        """Sets the max_keys of this FileListResponse.

        The maximum amount of objects to return  # noqa: E501

        :param max_keys: The max_keys of this FileListResponse.  # noqa: E501
        :type: int
        """

        self._max_keys = max_keys

    @property
    def continuation_token(self):
        """Gets the continuation_token of this FileListResponse.  # noqa: E501

        The continuation token that was passed to the operation  # noqa: E501

        :return: The continuation_token of this FileListResponse.  # noqa: E501
        :rtype: str
        """
        return self._continuation_token

    @continuation_token.setter
    def continuation_token(self, continuation_token):
        """Sets the continuation_token of this FileListResponse.

        The continuation token that was passed to the operation  # noqa: E501

        :param continuation_token: The continuation_token of this FileListResponse.  # noqa: E501
        :type: str
        """

        self._continuation_token = continuation_token

    @property
    def next_continuation_token(self):
        """Gets the next_continuation_token of this FileListResponse.  # noqa: E501

        The continuation token to pass to list the next items  # noqa: E501

        :return: The next_continuation_token of this FileListResponse.  # noqa: E501
        :rtype: str
        """
        return self._next_continuation_token

    @next_continuation_token.setter
    def next_continuation_token(self, next_continuation_token):
        """Sets the next_continuation_token of this FileListResponse.

        The continuation token to pass to list the next items  # noqa: E501

        :param next_continuation_token: The next_continuation_token of this FileListResponse.  # noqa: E501
        :type: str
        """

        self._next_continuation_token = next_continuation_token

    @property
    def is_truncated(self):
        """Gets the is_truncated of this FileListResponse.  # noqa: E501

        Whether there are no more files to list  # noqa: E501

        :return: The is_truncated of this FileListResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_truncated

    @is_truncated.setter
    def is_truncated(self, is_truncated):
        """Sets the is_truncated of this FileListResponse.

        Whether there are no more files to list  # noqa: E501

        :param is_truncated: The is_truncated of this FileListResponse.  # noqa: E501
        :type: bool
        """

        self._is_truncated = is_truncated

    @property
    def common_prefixes(self):
        """Gets the common_prefixes of this FileListResponse.  # noqa: E501

        The common prefixes (folders) contained under prefix.  # noqa: E501

        :return: The common_prefixes of this FileListResponse.  # noqa: E501
        :rtype: list[CommonPrefix]
        """
        return self._common_prefixes

    @common_prefixes.setter
    def common_prefixes(self, common_prefixes):
        """Sets the common_prefixes of this FileListResponse.

        The common prefixes (folders) contained under prefix.  # noqa: E501

        :param common_prefixes: The common_prefixes of this FileListResponse.  # noqa: E501
        :type: list[CommonPrefix]
        """

        self._common_prefixes = common_prefixes

    @property
    def objects(self):
        """Gets the objects of this FileListResponse.  # noqa: E501

        The objects (files) contained under prefix.  # noqa: E501

        :return: The objects of this FileListResponse.  # noqa: E501
        :rtype: list[Object]
        """
        return self._objects

    @objects.setter
    def objects(self, objects):
        """Sets the objects of this FileListResponse.

        The objects (files) contained under prefix.  # noqa: E501

        :param objects: The objects of this FileListResponse.  # noqa: E501
        :type: list[Object]
        """

        self._objects = objects

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileListResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FileListResponse):
            return True

        return self.to_dict() != other.to_dict()
