# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class CredentialUpdateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "provider_default": "bool",
        "provider": "CloudProvider",
        "allowed_in_tasks": "bool",
        "credential": "Credential",
        "role": "AccessCredentialRole",
        "token": "Token",
    }

    attribute_map = {
        "name": "name",
        "provider_default": "provider_default",
        "provider": "provider",
        "allowed_in_tasks": "allowed_in_tasks",
        "credential": "credential",
        "role": "role",
        "token": "token",
    }

    def __init__(
        self,
        name=None,
        provider_default=None,
        provider=None,
        allowed_in_tasks=None,
        credential=None,
        role=None,
        token=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """CredentialUpdateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._provider_default = None
        self._provider = None
        self._allowed_in_tasks = None
        self._credential = None
        self._role = None
        self._token = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if provider_default is not None:
            self.provider_default = provider_default
        if provider is not None:
            self.provider = provider
        if allowed_in_tasks is not None:
            self.allowed_in_tasks = allowed_in_tasks
        if credential is not None:
            self.credential = credential
        if role is not None:
            self.role = role
        if token is not None:
            self.token = token

    @property
    def name(self):
        """Gets the name of this CredentialUpdateRequest.  # noqa: E501

        A user-specified name for the key  # noqa: E501

        :return: The name of this CredentialUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CredentialUpdateRequest.

        A user-specified name for the key  # noqa: E501

        :param name: The name of this CredentialUpdateRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def provider_default(self):
        """Gets the provider_default of this CredentialUpdateRequest.  # noqa: E501

        True if this is the user's default credential to be used when connecting to the given cloud provider. There can be at most one default for each unique provider  # noqa: E501

        :return: The provider_default of this CredentialUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._provider_default

    @provider_default.setter
    def provider_default(self, provider_default):
        """Sets the provider_default of this CredentialUpdateRequest.

        True if this is the user's default credential to be used when connecting to the given cloud provider. There can be at most one default for each unique provider  # noqa: E501

        :param provider_default: The provider_default of this CredentialUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._provider_default = provider_default

    @property
    def provider(self):
        """Gets the provider of this CredentialUpdateRequest.  # noqa: E501


        :return: The provider of this CredentialUpdateRequest.  # noqa: E501
        :rtype: CloudProvider
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """Sets the provider of this CredentialUpdateRequest.


        :param provider: The provider of this CredentialUpdateRequest.  # noqa: E501
        :type: CloudProvider
        """

        self._provider = provider

    @property
    def allowed_in_tasks(self):
        """Gets the allowed_in_tasks of this CredentialUpdateRequest.  # noqa: E501

        Is this credential allowed to be used in tasks  # noqa: E501

        :return: The allowed_in_tasks of this CredentialUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._allowed_in_tasks

    @allowed_in_tasks.setter
    def allowed_in_tasks(self, allowed_in_tasks):
        """Sets the allowed_in_tasks of this CredentialUpdateRequest.

        Is this credential allowed to be used in tasks  # noqa: E501

        :param allowed_in_tasks: The allowed_in_tasks of this CredentialUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._allowed_in_tasks = allowed_in_tasks

    @property
    def credential(self):
        """Gets the credential of this CredentialUpdateRequest.  # noqa: E501


        :return: The credential of this CredentialUpdateRequest.  # noqa: E501
        :rtype: Credential
        """
        return self._credential

    @credential.setter
    def credential(self, credential):
        """Sets the credential of this CredentialUpdateRequest.


        :param credential: The credential of this CredentialUpdateRequest.  # noqa: E501
        :type: Credential
        """

        self._credential = credential

    @property
    def role(self):
        """Gets the role of this CredentialUpdateRequest.  # noqa: E501


        :return: The role of this CredentialUpdateRequest.  # noqa: E501
        :rtype: AccessCredentialRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this CredentialUpdateRequest.


        :param role: The role of this CredentialUpdateRequest.  # noqa: E501
        :type: AccessCredentialRole
        """

        self._role = role

    @property
    def token(self):
        """Gets the token of this CredentialUpdateRequest.  # noqa: E501


        :return: The token of this CredentialUpdateRequest.  # noqa: E501
        :rtype: Token
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this CredentialUpdateRequest.


        :param token: The token of this CredentialUpdateRequest.  # noqa: E501
        :type: Token
        """

        self._token = token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CredentialUpdateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CredentialUpdateRequest):
            return True

        return self.to_dict() != other.to_dict()
