# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class Asset(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "workspace_id": "str",
        "teamspace_id": "str",
        "workspace": "WorkspaceLight",
        "teamspace": "TeamspaceLight",
        "name": "str",
        "description": "str",
        "member_type": "AssetMemberType",
        "mime": "str",
        "backing_type": "AssetBackingType",
        "type": "AssetType",
        "path": "str",
        "created_at": "datetime",
        "updated_at": "datetime",
        "created_by": "WorkspaceUser",
        "metadata": "list[AssetMetadata]",
        "uri": "str",
        "tiledb_uri": "str",
        "file_info": "FileInfo",
        "array_info": "ArrayInfo",
        "group_info": "GroupInfo",
        "folder_info": "FolderInfo",
    }

    attribute_map = {
        "id": "id",
        "workspace_id": "workspace_id",
        "teamspace_id": "teamspace_id",
        "workspace": "workspace",
        "teamspace": "teamspace",
        "name": "name",
        "description": "description",
        "member_type": "member_type",
        "mime": "mime",
        "backing_type": "backing_type",
        "type": "type",
        "path": "path",
        "created_at": "created_at",
        "updated_at": "updated_at",
        "created_by": "created_by",
        "metadata": "metadata",
        "uri": "uri",
        "tiledb_uri": "tiledb_uri",
        "file_info": "fileInfo",
        "array_info": "arrayInfo",
        "group_info": "groupInfo",
        "folder_info": "folderInfo",
    }

    def __init__(
        self,
        id=None,
        workspace_id=None,
        teamspace_id=None,
        workspace=None,
        teamspace=None,
        name=None,
        description=None,
        member_type=None,
        mime=None,
        backing_type=None,
        type=None,
        path=None,
        created_at=None,
        updated_at=None,
        created_by=None,
        metadata=None,
        uri=None,
        tiledb_uri=None,
        file_info=None,
        array_info=None,
        group_info=None,
        folder_info=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Asset - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._workspace_id = None
        self._teamspace_id = None
        self._workspace = None
        self._teamspace = None
        self._name = None
        self._description = None
        self._member_type = None
        self._mime = None
        self._backing_type = None
        self._type = None
        self._path = None
        self._created_at = None
        self._updated_at = None
        self._created_by = None
        self._metadata = None
        self._uri = None
        self._tiledb_uri = None
        self._file_info = None
        self._array_info = None
        self._group_info = None
        self._folder_info = None
        self.discriminator = None

        self.id = id
        self.workspace_id = workspace_id
        self.teamspace_id = teamspace_id
        self.workspace = workspace
        self.teamspace = teamspace
        self.name = name
        if description is not None:
            self.description = description
        if member_type is not None:
            self.member_type = member_type
        if mime is not None:
            self.mime = mime
        self.backing_type = backing_type
        self.type = type
        self.path = path
        self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        self.created_by = created_by
        if metadata is not None:
            self.metadata = metadata
        if uri is not None:
            self.uri = uri
        self.tiledb_uri = tiledb_uri
        if file_info is not None:
            self.file_info = file_info
        if array_info is not None:
            self.array_info = array_info
        if group_info is not None:
            self.group_info = group_info
        if folder_info is not None:
            self.folder_info = folder_info

    @property
    def id(self):
        """Gets the id of this Asset.  # noqa: E501

        The asset's ID  # noqa: E501

        :return: The id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Asset.

        The asset's ID  # noqa: E501

        :param id: The id of this Asset.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def workspace_id(self):
        """Gets the workspace_id of this Asset.  # noqa: E501

        The workspace's ID  # noqa: E501

        :return: The workspace_id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """Sets the workspace_id of this Asset.

        The workspace's ID  # noqa: E501

        :param workspace_id: The workspace_id of this Asset.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and workspace_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `workspace_id`, must not be `None`"
            )  # noqa: E501

        self._workspace_id = workspace_id

    @property
    def teamspace_id(self):
        """Gets the teamspace_id of this Asset.  # noqa: E501

        The teamspace's ID  # noqa: E501

        :return: The teamspace_id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._teamspace_id

    @teamspace_id.setter
    def teamspace_id(self, teamspace_id):
        """Sets the teamspace_id of this Asset.

        The teamspace's ID  # noqa: E501

        :param teamspace_id: The teamspace_id of this Asset.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and teamspace_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `teamspace_id`, must not be `None`"
            )  # noqa: E501

        self._teamspace_id = teamspace_id

    @property
    def workspace(self):
        """Gets the workspace of this Asset.  # noqa: E501


        :return: The workspace of this Asset.  # noqa: E501
        :rtype: WorkspaceLight
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this Asset.


        :param workspace: The workspace of this Asset.  # noqa: E501
        :type: WorkspaceLight
        """
        if (
            self.local_vars_configuration.client_side_validation and workspace is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `workspace`, must not be `None`"
            )  # noqa: E501

        self._workspace = workspace

    @property
    def teamspace(self):
        """Gets the teamspace of this Asset.  # noqa: E501


        :return: The teamspace of this Asset.  # noqa: E501
        :rtype: TeamspaceLight
        """
        return self._teamspace

    @teamspace.setter
    def teamspace(self, teamspace):
        """Sets the teamspace of this Asset.


        :param teamspace: The teamspace of this Asset.  # noqa: E501
        :type: TeamspaceLight
        """
        if (
            self.local_vars_configuration.client_side_validation and teamspace is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `teamspace`, must not be `None`"
            )  # noqa: E501

        self._teamspace = teamspace

    @property
    def name(self):
        """Gets the name of this Asset.  # noqa: E501

        The name of the asset.  # noqa: E501

        :return: The name of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Asset.

        The name of the asset.  # noqa: E501

        :param name: The name of this Asset.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `name`, must not be `None`"
            )  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Asset.  # noqa: E501

        The description of the asset.  # noqa: E501

        :return: The description of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Asset.

        The description of the asset.  # noqa: E501

        :param description: The description of this Asset.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def member_type(self):
        """Gets the member_type of this Asset.  # noqa: E501


        :return: The member_type of this Asset.  # noqa: E501
        :rtype: AssetMemberType
        """
        return self._member_type

    @member_type.setter
    def member_type(self, member_type):
        """Sets the member_type of this Asset.


        :param member_type: The member_type of this Asset.  # noqa: E501
        :type: AssetMemberType
        """

        self._member_type = member_type

    @property
    def mime(self):
        """Gets the mime of this Asset.  # noqa: E501

        The MIME type of the asset.  # noqa: E501

        :return: The mime of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._mime

    @mime.setter
    def mime(self, mime):
        """Sets the mime of this Asset.

        The MIME type of the asset.  # noqa: E501

        :param mime: The mime of this Asset.  # noqa: E501
        :type: str
        """

        self._mime = mime

    @property
    def backing_type(self):
        """Gets the backing_type of this Asset.  # noqa: E501


        :return: The backing_type of this Asset.  # noqa: E501
        :rtype: AssetBackingType
        """
        return self._backing_type

    @backing_type.setter
    def backing_type(self, backing_type):
        """Sets the backing_type of this Asset.


        :param backing_type: The backing_type of this Asset.  # noqa: E501
        :type: AssetBackingType
        """
        if (
            self.local_vars_configuration.client_side_validation
            and backing_type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `backing_type`, must not be `None`"
            )  # noqa: E501

        self._backing_type = backing_type

    @property
    def type(self):
        """Gets the type of this Asset.  # noqa: E501


        :return: The type of this Asset.  # noqa: E501
        :rtype: AssetType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Asset.


        :param type: The type of this Asset.  # noqa: E501
        :type: AssetType
        """
        if (
            self.local_vars_configuration.client_side_validation and type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type`, must not be `None`"
            )  # noqa: E501

        self._type = type

    @property
    def path(self):
        """Gets the path of this Asset.  # noqa: E501

        The path of the asset.  # noqa: E501

        :return: The path of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this Asset.

        The path of the asset.  # noqa: E501

        :param path: The path of this Asset.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and path is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `path`, must not be `None`"
            )  # noqa: E501

        self._path = path

    @property
    def created_at(self):
        """Gets the created_at of this Asset.  # noqa: E501

        Datetime asset was created in UTC  # noqa: E501

        :return: The created_at of this Asset.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Asset.

        Datetime asset was created in UTC  # noqa: E501

        :param created_at: The created_at of this Asset.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and created_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_at`, must not be `None`"
            )  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Asset.  # noqa: E501

        Datetime asset was updated in UTC  # noqa: E501

        :return: The updated_at of this Asset.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Asset.

        Datetime asset was updated in UTC  # noqa: E501

        :param updated_at: The updated_at of this Asset.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def created_by(self):
        """Gets the created_by of this Asset.  # noqa: E501


        :return: The created_by of this Asset.  # noqa: E501
        :rtype: WorkspaceUser
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Asset.


        :param created_by: The created_by of this Asset.  # noqa: E501
        :type: WorkspaceUser
        """
        if (
            self.local_vars_configuration.client_side_validation and created_by is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_by`, must not be `None`"
            )  # noqa: E501

        self._created_by = created_by

    @property
    def metadata(self):
        """Gets the metadata of this Asset.  # noqa: E501


        :return: The metadata of this Asset.  # noqa: E501
        :rtype: list[AssetMetadata]
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this Asset.


        :param metadata: The metadata of this Asset.  # noqa: E501
        :type: list[AssetMetadata]
        """

        self._metadata = metadata

    @property
    def uri(self):
        """Gets the uri of this Asset.  # noqa: E501

        URI where the asset is located.  # noqa: E501

        :return: The uri of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this Asset.

        URI where the asset is located.  # noqa: E501

        :param uri: The uri of this Asset.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def tiledb_uri(self):
        """Gets the tiledb_uri of this Asset.  # noqa: E501

        The TileDB URI in the form of tiledb://workspace_name/teamspace_name/asset_id  # noqa: E501

        :return: The tiledb_uri of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._tiledb_uri

    @tiledb_uri.setter
    def tiledb_uri(self, tiledb_uri):
        """Sets the tiledb_uri of this Asset.

        The TileDB URI in the form of tiledb://workspace_name/teamspace_name/asset_id  # noqa: E501

        :param tiledb_uri: The tiledb_uri of this Asset.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and tiledb_uri is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `tiledb_uri`, must not be `None`"
            )  # noqa: E501

        self._tiledb_uri = tiledb_uri

    @property
    def file_info(self):
        """Gets the file_info of this Asset.  # noqa: E501


        :return: The file_info of this Asset.  # noqa: E501
        :rtype: FileInfo
        """
        return self._file_info

    @file_info.setter
    def file_info(self, file_info):
        """Sets the file_info of this Asset.


        :param file_info: The file_info of this Asset.  # noqa: E501
        :type: FileInfo
        """

        self._file_info = file_info

    @property
    def array_info(self):
        """Gets the array_info of this Asset.  # noqa: E501


        :return: The array_info of this Asset.  # noqa: E501
        :rtype: ArrayInfo
        """
        return self._array_info

    @array_info.setter
    def array_info(self, array_info):
        """Sets the array_info of this Asset.


        :param array_info: The array_info of this Asset.  # noqa: E501
        :type: ArrayInfo
        """

        self._array_info = array_info

    @property
    def group_info(self):
        """Gets the group_info of this Asset.  # noqa: E501


        :return: The group_info of this Asset.  # noqa: E501
        :rtype: GroupInfo
        """
        return self._group_info

    @group_info.setter
    def group_info(self, group_info):
        """Sets the group_info of this Asset.


        :param group_info: The group_info of this Asset.  # noqa: E501
        :type: GroupInfo
        """

        self._group_info = group_info

    @property
    def folder_info(self):
        """Gets the folder_info of this Asset.  # noqa: E501


        :return: The folder_info of this Asset.  # noqa: E501
        :rtype: FolderInfo
        """
        return self._folder_info

    @folder_info.setter
    def folder_info(self, folder_info):
        """Sets the folder_info of this Asset.


        :param folder_info: The folder_info of this Asset.  # noqa: E501
        :type: FolderInfo
        """

        self._folder_info = folder_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Asset):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Asset):
            return True

        return self.to_dict() != other.to_dict()
