# coding: utf-8

"""
Tiledb Storage Platform API

TileDB Storage Platform REST API  # noqa: E501

The version of the OpenAPI document: 1.4.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client._common.api_v2.api_client import ApiClient
from tiledb.client._common.api_v2.exceptions import ApiTypeError  # noqa: F401
from tiledb.client._common.api_v2.exceptions import ApiValueError  # noqa: F401


class QueryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def submit_query(
        self, workspace, teamspace, array, type, content_type, query, **kwargs
    ):  # noqa: E501
        """submit_query  # noqa: E501

        send a query to run against a specified array/URI registered to a group/project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_query(workspace, teamspace, array, type, content_type, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: the workspace containing the teamspace the array belongs to (required)
        :param str teamspace: the teamspace the array belongs to (required)
        :param str array: asset ID or hierarchical path of array that is url-encoded (required)
        :param str type: type of query (required)
        :param str content_type: Content Type of input and return mime (required)
        :param Query query: query to run (required)
        :param str x_payer: Name of organization or user who should be charged for this request
        :param int open_at: open_at for array in unix epoch
        :param str read_all: If \"true\", resubmits incomplete queries until the query has completed. Defaults to \"false\".
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.submit_query_with_http_info(
            workspace, teamspace, array, type, content_type, query, **kwargs
        )  # noqa: E501

    def submit_query_with_http_info(
        self, workspace, teamspace, array, type, content_type, query, **kwargs
    ):  # noqa: E501
        """submit_query  # noqa: E501

        send a query to run against a specified array/URI registered to a group/project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_query_with_http_info(workspace, teamspace, array, type, content_type, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: the workspace containing the teamspace the array belongs to (required)
        :param str teamspace: the teamspace the array belongs to (required)
        :param str array: asset ID or hierarchical path of array that is url-encoded (required)
        :param str type: type of query (required)
        :param str content_type: Content Type of input and return mime (required)
        :param Query query: query to run (required)
        :param str x_payer: Name of organization or user who should be charged for this request
        :param int open_at: open_at for array in unix epoch
        :param str read_all: If \"true\", resubmits incomplete queries until the query has completed. Defaults to \"false\".
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "array",
            "type",
            "content_type",
            "query",
            "x_payer",
            "open_at",
            "read_all",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_query" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `submit_query`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `submit_query`"
            )  # noqa: E501
        # verify the required parameter 'array' is set
        if self.api_client.client_side_validation and (
            "array" not in local_var_params  # noqa: E501
            or local_var_params["array"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `array` when calling `submit_query`"
            )  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in local_var_params  # noqa: E501
            or local_var_params["type"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `type` when calling `submit_query`"
            )  # noqa: E501
        # verify the required parameter 'content_type' is set
        if self.api_client.client_side_validation and (
            "content_type" not in local_var_params  # noqa: E501
            or local_var_params["content_type"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `content_type` when calling `submit_query`"
            )  # noqa: E501
        # verify the required parameter 'query' is set
        if self.api_client.client_side_validation and (
            "query" not in local_var_params  # noqa: E501
            or local_var_params["query"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `query` when calling `submit_query`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "array" in local_var_params:
            path_params["array"] = local_var_params["array"]  # noqa: E501

        query_params = []
        if (
            "type" in local_var_params and local_var_params["type"] is not None
        ):  # noqa: E501
            query_params.append(("type", local_var_params["type"]))  # noqa: E501
        if (
            "open_at" in local_var_params and local_var_params["open_at"] is not None
        ):  # noqa: E501
            query_params.append(("open_at", local_var_params["open_at"]))  # noqa: E501
        if (
            "read_all" in local_var_params and local_var_params["read_all"] is not None
        ):  # noqa: E501
            query_params.append(
                ("read_all", local_var_params["read_all"])
            )  # noqa: E501

        header_params = {}
        if "content_type" in local_var_params:
            header_params["Content-Type"] = local_var_params[
                "content_type"
            ]  # noqa: E501
        if "x_payer" in local_var_params:
            header_params["X-Payer"] = local_var_params["x_payer"]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if "query" in local_var_params:
            body_params = local_var_params["query"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/capnp"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json", "application/capnp"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/v2/arrays/{workspace}/{teamspace}/{array}/query/submit",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
