# Copyright 2021 Chainopt LLC.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import click

from roe.utilities.running_utils import end


@click.command()
@click.option("-l", "--local", is_flag=True, type=bool, help="End local deployment")
def cli(local):
    """
    End ROE Services.

    1) Lists deployed packages
    2) Stops all deployed packages
    3) Stops ROE-API container in Docker
    """
    end(local)
    return
