"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTypeParametersSignature = exports.hasTypeParameters = exports.classNames = exports.renderFlags = exports.join = exports.wbr = exports.stringify = void 0;
const models_1 = require("../../models");
const utils_1 = require("../../utils");
function stringify(data) {
    if (typeof data === "bigint") {
        return data.toString() + "n";
    }
    return JSON.stringify(data);
}
exports.stringify = stringify;
/**
 * Insert word break tags ``<wbr>`` into the given string.
 *
 * Breaks the given string at ``_``, ``-`` and capital letters.
 *
 * @param str The string that should be split.
 * @return The original string containing ``<wbr>`` tags where possible.
 */
function wbr(str) {
    // TODO surely there is a better way to do this, but I'm tired.
    const ret = [];
    const re = /[\s\S]*?(?:([^_-][_-])(?=[^_-])|([^A-Z])(?=[A-Z][^A-Z]))/g;
    let match;
    let i = 0;
    while ((match = re.exec(str))) {
        ret.push(match[0]);
        ret.push(utils_1.JSX.createElement("wbr", null));
        i += match[0].length;
    }
    ret.push(str.slice(i));
    return ret;
}
exports.wbr = wbr;
function join(joiner, list, cb) {
    const result = [];
    for (const item of list) {
        if (result.length > 0) {
            result.push(joiner);
        }
        result.push(cb(item));
    }
    return utils_1.JSX.createElement(utils_1.JSX.Fragment, null, result);
}
exports.join = join;
function renderFlags(flags) {
    return (utils_1.JSX.createElement(utils_1.JSX.Fragment, null, flags.map((item) => (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
        utils_1.JSX.createElement("span", { class: "tsd-flag ts-flag" + item }, item),
        " ")))));
}
exports.renderFlags = renderFlags;
function classNames(names) {
    return Object.entries(names)
        .filter(([, include]) => include)
        .map(([key]) => key)
        .join(" ");
}
exports.classNames = classNames;
function hasTypeParameters(reflection) {
    if (reflection instanceof models_1.DeclarationReflection || reflection instanceof models_1.SignatureReflection) {
        return reflection.typeParameters != null;
    }
    return false;
}
exports.hasTypeParameters = hasTypeParameters;
function renderTypeParametersSignature(typeParameters) {
    return (utils_1.JSX.createElement(utils_1.JSX.Fragment, null, !!typeParameters && typeParameters.length > 0 && (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
        utils_1.JSX.createElement("span", { class: "tsd-signature-symbol" }, "<"),
        join(utils_1.JSX.createElement("span", { class: "tsd-signature-symbol" }, ", "), typeParameters, (item) => (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
            item.varianceModifier ? `${item.varianceModifier} ` : "",
            utils_1.JSX.createElement("span", { class: "tsd-signature-type", "data-tsd-kind": item.kindString }, item.name)))),
        utils_1.JSX.createElement("span", { class: "tsd-signature-symbol" }, ">")))));
}
exports.renderTypeParametersSignature = renderTypeParametersSignature;
