"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reflectionTemplate = void 0;
const lib_1 = require("../../lib");
const models_1 = require("../../../../models");
const utils_1 = require("../../../../utils");
const reflectionTemplate = (context, props) => {
    var _a;
    return (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
        props.model.hasComment() && utils_1.JSX.createElement("section", { class: "tsd-panel tsd-comment" }, context.comment(props.model)),
        (0, lib_1.hasTypeParameters)(props.model) && (utils_1.JSX.createElement("section", { class: "tsd-panel tsd-type-parameters" },
            utils_1.JSX.createElement("h3", null, "Type Parameters"),
            context.typeParameters(props.model.typeParameters))),
        props.model instanceof models_1.DeclarationReflection && (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
            !!props.model.typeHierarchy && (utils_1.JSX.createElement("section", { class: "tsd-panel tsd-hierarchy" },
                utils_1.JSX.createElement("h3", null, "Hierarchy"),
                context.hierarchy(props.model.typeHierarchy))),
            !!props.model.implementedTypes && (utils_1.JSX.createElement("section", { class: "tsd-panel" },
                utils_1.JSX.createElement("h3", null, "Implements"),
                utils_1.JSX.createElement("ul", { class: "tsd-hierarchy" }, props.model.implementedTypes.map((item) => (utils_1.JSX.createElement("li", null, context.type(item))))))),
            !!props.model.implementedBy && (utils_1.JSX.createElement("section", { class: "tsd-panel" },
                utils_1.JSX.createElement("h3", null, "Implemented by"),
                utils_1.JSX.createElement("ul", { class: "tsd-hierarchy" }, props.model.implementedBy.map((item) => (utils_1.JSX.createElement("li", null, context.type(item))))))),
            !!props.model.signatures && (utils_1.JSX.createElement("section", { class: "tsd-panel" },
                utils_1.JSX.createElement("h3", { class: "tsd-before-signature" }, "Callable"),
                context.memberSignatures(props.model))),
            !!props.model.indexSignature && (utils_1.JSX.createElement("section", { class: "tsd-panel " + props.model.cssClasses },
                utils_1.JSX.createElement("h3", { class: "tsd-before-signature" }, "Indexable"),
                utils_1.JSX.createElement("div", { class: "tsd-signature tsd-kind-icon" },
                    utils_1.JSX.createElement("span", { class: "tsd-signature-symbol" }, "["),
                    props.model.indexSignature.parameters.map((item) => (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
                        item.name,
                        ": ",
                        context.type(item.type)))),
                    utils_1.JSX.createElement("span", { class: "tsd-signature-symbol" }, "]: "),
                    context.type(props.model.indexSignature.type)),
                context.comment(props.model.indexSignature),
                ((_a = props.model.indexSignature) === null || _a === void 0 ? void 0 : _a.type) instanceof models_1.ReflectionType &&
                    context.parameter(props.model.indexSignature.type.declaration))))),
        context.index(props.model),
        context.members(props.model)));
};
exports.reflectionTemplate = reflectionTemplate;
