import type { Type } from "../types";
import { Reflection } from "./abstract";
import type { DeclarationReflection } from "./declaration";
/**
 * Modifier flags for type parameters, added in TS 4.7
 * @enum
 */
export declare const VarianceModifier: {
    readonly in: "in";
    readonly out: "out";
    readonly inOut: "in out";
};
export declare type VarianceModifier = typeof VarianceModifier[keyof typeof VarianceModifier];
export declare class TypeParameterReflection extends Reflection {
    parent?: DeclarationReflection;
    type?: Type;
    default?: Type;
    varianceModifier?: VarianceModifier;
    constructor(name: string, constraint: Type | undefined, defaultType: Type | undefined, parent: Reflection, varianceModifier: VarianceModifier | undefined);
}
