import * as ts from "typescript";
import type { Application } from "../application";
import { ProjectReflection, ReflectionKind, SomeType } from "../models/index";
import { Context } from "./context";
import { ConverterComponent } from "./components";
import { ChildableComponent } from "../utils/component";
import type { DocumentationEntryPoint } from "../utils/entry-point";
/**
 * Compiles source files using TypeScript and converts compiler symbols to reflections.
 */
export declare class Converter extends ChildableComponent<Application, ConverterComponent> {
    /**
     * The human readable name of the project. Used within the templates to set the title of the document.
     */
    name: string;
    externalPattern: string[];
    private externalPatternCache?;
    private excludeCache?;
    excludeExternals: boolean;
    excludeNotDocumented: boolean;
    excludePrivate: boolean;
    excludeProtected: boolean;
    /**
     * General events
     */
    /**
     * Triggered when the converter begins converting a project.
     * The listener will be given a {@link Context} object.
     * @event
     */
    static readonly EVENT_BEGIN: "begin";
    /**
     * Triggered when the converter has finished converting a project.
     * The listener will be given a {@link Context} object.
     * @event
     */
    static readonly EVENT_END: "end";
    /**
     * Factory events
     */
    /**
     * Triggered when the converter has created a declaration reflection.
     * The listener will be given {@link Context}, {@link Reflection} and a `ts.Node?`.
     * @event
     */
    static readonly EVENT_CREATE_DECLARATION: "createDeclaration";
    /**
     * Triggered when the converter has created a signature reflection.
     * The listener will be given {@link Context}, {@link SignatureReflection} and a `ts.Node?`
     * @event
     */
    static readonly EVENT_CREATE_SIGNATURE: "createSignature";
    /**
     * Triggered when the converter has created a parameter reflection.
     * The listener will be given {@link Context}, {@link ParameterReflection} and a `ts.Node?`
     * @event
     */
    static readonly EVENT_CREATE_PARAMETER: "createParameter";
    /**
     * Triggered when the converter has created a type parameter reflection.
     * The listener will be given {@link Context}, {@link TypeParameterReflection} and a `ts.Node?`
     * @event
     */
    static readonly EVENT_CREATE_TYPE_PARAMETER: "createTypeParameter";
    /**
     * Resolve events
     */
    /**
     * Triggered when the converter begins resolving a project.
     * The listener will be given {@link Context}.
     * @event
     */
    static readonly EVENT_RESOLVE_BEGIN: "resolveBegin";
    /**
     * Triggered when the converter resolves a reflection.
     * The listener will be given {@link Context} and a {@link Reflection}.
     * @event
     */
    static readonly EVENT_RESOLVE: "resolveReflection";
    /**
     * Triggered when the converter has finished resolving a project.
     * The listener will be given {@link Context}.
     * @event
     */
    static readonly EVENT_RESOLVE_END: "resolveEnd";
    /**
     * Compile the given source files and create a project reflection for them.
     */
    convert(entryPoints: readonly DocumentationEntryPoint[]): ProjectReflection;
    /** @internal */
    convertSymbol(context: Context, symbol: ts.Symbol): void;
    /**
     * Convert the given TypeScript type into its TypeDoc type reflection.
     *
     * @param context  The context object describing the current state the converter is in.
     * @param referenceTarget The target to be used to attempt to resolve reference types
     * @returns The TypeDoc type reflection representing the given node and type.
     * @internal
     */
    convertType(context: Context, node: ts.TypeNode | ts.Type | undefined): SomeType;
    /** @internal */
    getNodesForSymbol(symbol: ts.Symbol, kind: ReflectionKind): ts.Declaration[];
    /**
     * Compile the files within the given context and convert the compiler symbols to reflections.
     *
     * @param context  The context object describing the current state the converter is in.
     * @returns An array containing all errors generated by the TypeScript compiler.
     */
    private compile;
    private convertExports;
    private convertReExports;
    /**
     * Resolve the project within the given context.
     *
     * @param context  The context object describing the current state the converter is in.
     * @returns The final project reflection.
     */
    private resolve;
    /** @internal */
    shouldIgnore(symbol: ts.Symbol, checker: ts.TypeChecker): boolean;
    private isExcluded;
    /** @internal */
    isExternal(symbol: ts.Symbol): boolean;
}
