# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
import time

from Tea.exceptions import TeaException, UnretryableException
from Tea.request import TeaRequest
from Tea.core import TeaCore

from alibabacloud_pds_credentials.client import Client as AccessTokenCredentialClient
from alibabacloud_credentials.client import Client as CredentialClient
from alibabacloud_pds_sdk import models as pds_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_pds_credentials import models as access_token_credential_models
from alibabacloud_credentials import models as credential_models
from alibabacloud_roa_util.client import Client as ROAUtilClient


class Client:
    """
    *\
    """
    _domain_id: str = None
    _access_token_credential: AccessTokenCredentialClient = None
    _endpoint: str = None
    _protocol: str = None
    _nickname: str = None
    _user_agent: str = None
    _credential: CredentialClient = None

    def __init__(
        self, 
        config: pds_models.Config,
    ):
        if UtilClient.is_unset(config):
            raise TeaException({
                'name': 'ParameterMissing',
                'message': "'config' can not be unset"
            })
        UtilClient.validate_model(config)
        if not UtilClient.empty(config.access_token) or not UtilClient.empty(config.refresh_token):
            access_config = access_token_credential_models.Config(
                access_token=config.access_token,
                endpoint=config.endpoint,
                domain_id=config.domain_id,
                client_id=config.client_id,
                refresh_token=config.refresh_token,
                client_secret=config.client_secret,
                expire_time=config.expire_time
            )
            self._access_token_credential = AccessTokenCredentialClient(access_config)
        if not UtilClient.empty(config.access_key_id):
            if UtilClient.empty(config.type):
                config.type = 'access_key'
            credential_config = credential_models.Config(
                access_key_id=config.access_key_id,
                type=config.type,
                access_key_secret=config.access_key_secret,
                security_token=config.security_token
            )
            self._credential = CredentialClient(credential_config)
        self._endpoint = config.endpoint
        self._protocol = config.protocol
        self._user_agent = config.user_agent
        self._nickname = config.nickname
        self._domain_id = config.domain_id

    def cancel_link_ex(
        self,
        request: pds_models.CancelLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CancelLinkModel:
        """
        取消绑定关系，生成新用户，返回访问令牌
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/cancel_link')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CancelLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def cancel_link_ex_async(
        self,
        request: pds_models.CancelLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CancelLinkModel:
        """
        取消绑定关系，生成新用户，返回访问令牌
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/cancel_link')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CancelLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def confirm_link_ex(
        self,
        request: pds_models.ConfirmLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ConfirmLinkModel:
        """
        确认绑定关系, 成功后返回访问令牌
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/confirm_link')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ConfirmLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def confirm_link_ex_async(
        self,
        request: pds_models.ConfirmLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ConfirmLinkModel:
        """
        确认绑定关系, 成功后返回访问令牌
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/confirm_link')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ConfirmLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def change_password_ex(
        self,
        request: pds_models.DefaultChangePasswordRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ChangePasswordModel:
        """
        修改手机登录密码，密码必须包含数字和字母，长度8-20个字符
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/default/change_password')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ChangePasswordModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def change_password_ex_async(
        self,
        request: pds_models.DefaultChangePasswordRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ChangePasswordModel:
        """
        修改手机登录密码，密码必须包含数字和字母，长度8-20个字符
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/default/change_password')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ChangePasswordModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def set_password_ex(
        self,
        request: pds_models.DefaultSetPasswordRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.SetPasswordModel:
        """
        设置手机登录密码，密码必须包含数字和字母，长度8-20个字符
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/default/set_password')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.SetPasswordModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def set_password_ex_async(
        self,
        request: pds_models.DefaultSetPasswordRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.SetPasswordModel:
        """
        设置手机登录密码，密码必须包含数字和字母，长度8-20个字符
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/default/set_password')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.SetPasswordModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def verify_code_ex(
        self,
        request: pds_models.VerifyCodeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.VerifyCodeModel:
        """
        校验手机短信验证码，用于重置密码时校验手机，通过校验后返回state，可通过state重新设置密码
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/default/verify_code')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.VerifyCodeModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def verify_code_ex_async(
        self,
        request: pds_models.VerifyCodeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.VerifyCodeModel:
        """
        校验手机短信验证码，用于重置密码时校验手机，通过校验后返回state，可通过state重新设置密码
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/default/verify_code')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.VerifyCodeModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_access_token_by_link_info_ex(
        self,
        request: pds_models.GetAccessTokenByLinkInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetAccessTokenByLinkInfoModel:
        """
        管理员通过账号信息直接获取用户的访问令牌
        @tags account
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_access_token_by_link_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetAccessTokenByLinkInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_access_token_by_link_info_ex_async(
        self,
        request: pds_models.GetAccessTokenByLinkInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetAccessTokenByLinkInfoModel:
        """
        管理员通过账号信息直接获取用户的访问令牌
        @tags account
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_access_token_by_link_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetAccessTokenByLinkInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_link_info_ex(
        self,
        request: pds_models.GetByLinkInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetLinkInfoModel:
        """
        获取用户认证方式详情
        @tags account
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_link_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetLinkInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_link_info_ex_async(
        self,
        request: pds_models.GetByLinkInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetLinkInfoModel:
        """
        获取用户认证方式详情
        @tags account
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_link_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetLinkInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_link_info_by_user_id_ex(
        self,
        request: pds_models.GetLinkInfoByUserIDRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetLinkInfoByUserIdModel:
        """
        获取用户的所有绑定信息
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_link_info_by_user_id')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetLinkInfoByUserIdModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_link_info_by_user_id_ex_async(
        self,
        request: pds_models.GetLinkInfoByUserIDRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetLinkInfoByUserIdModel:
        """
        获取用户的所有绑定信息
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_link_info_by_user_id')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetLinkInfoByUserIdModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_public_key_ex(
        self,
        request: pds_models.GetPublicKeyRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetPublicKeyModel:
        """
        获取公钥，用于加密对称密钥
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_public_key')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetPublicKeyModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_public_key_ex_async(
        self,
        request: pds_models.GetPublicKeyRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetPublicKeyModel:
        """
        获取公钥，用于加密对称密钥
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/get_public_key')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetPublicKeyModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def link_ex(
        self,
        request: pds_models.AccountLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.LinkModel:
        """
        绑定用户认证方式
        @tags account
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/link')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.LinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def link_ex_async(
        self,
        request: pds_models.AccountLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.LinkModel:
        """
        绑定用户认证方式
        @tags account
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/link')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.LinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def check_exist_ex(
        self,
        request: pds_models.MobileCheckExistRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CheckExistModel:
        """
        查询手机号是否已被注册
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/check_exist')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CheckExistModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def check_exist_ex_async(
        self,
        request: pds_models.MobileCheckExistRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CheckExistModel:
        """
        查询手机号是否已被注册
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/check_exist')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CheckExistModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def login_ex(
        self,
        request: pds_models.MobileLoginRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.LoginModel:
        """
        通过手机号+短信或密码登录，返回刷新令牌和访问令牌
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/login')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.LoginModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def login_ex_async(
        self,
        request: pds_models.MobileLoginRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.LoginModel:
        """
        通过手机号+短信或密码登录，返回刷新令牌和访问令牌
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/login')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.LoginModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def register_ex(
        self,
        request: pds_models.MobileRegisterRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.RegisterModel:
        """
        通过手机号+短信验证码注册账号
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/register')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.RegisterModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def register_ex_async(
        self,
        request: pds_models.MobileRegisterRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.RegisterModel:
        """
        通过手机号+短信验证码注册账号
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/register')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.RegisterModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def mobile_send_sms_code_ex(
        self,
        request: pds_models.MobileSendSmsCodeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.MobileSendSmsCodeModel:
        """
        发送短信验证码，用于登录、注册、修改密码、绑定等
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/send_sms_code')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.MobileSendSmsCodeModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def mobile_send_sms_code_ex_async(
        self,
        request: pds_models.MobileSendSmsCodeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.MobileSendSmsCodeModel:
        """
        发送短信验证码，用于登录、注册、修改密码、绑定等
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/mobile/send_sms_code')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.MobileSendSmsCodeModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def account_revoke_ex(
        self,
        request: pds_models.RevokeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.AccountRevokeModel:
        """
        用户退出登录
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/revoke')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.AccountRevokeModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def account_revoke_ex_async(
        self,
        request: pds_models.RevokeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.AccountRevokeModel:
        """
        用户退出登录
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/revoke')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.AccountRevokeModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def account_token_ex(
        self,
        request: pds_models.AccountTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.AccountTokenModel:
        """
        用户通过刷新令牌（refresh_token）获取访问令牌（access_token）
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.AccountTokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def account_token_ex_async(
        self,
        request: pds_models.AccountTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.AccountTokenModel:
        """
        用户通过刷新令牌（refresh_token）获取访问令牌（access_token）
        @tags account
        @error InvalidParameterMissing The input parameter {parameter_name} is missing.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/account/token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.auth.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.AccountTokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def admin_list_stores_ex(
        self,
        request: pds_models.AdminListStoresRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.AdminListStoresModel:
        """
        列举Store列表
        @tags admin
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/domain/list_stores')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.AdminListStoresModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def admin_list_stores_ex_async(
        self,
        request: pds_models.AdminListStoresRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.AdminListStoresModel:
        """
        列举Store列表
        @tags admin
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/domain/list_stores')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.AdminListStoresModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def create_subdomain_ex(
        self,
        request: pds_models.CreateSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateSubdomainModel:
        """
        create subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def create_subdomain_ex_async(
        self,
        request: pds_models.CreateSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateSubdomainModel:
        """
        create subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def delete_subdomain_ex(
        self,
        request: pds_models.DeleteSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteSubdomainModel:
        """
        delete subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.DeleteSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def delete_subdomain_ex_async(
        self,
        request: pds_models.DeleteSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteSubdomainModel:
        """
        delete subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.DeleteSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_subdomain_ex(
        self,
        request: pds_models.GetSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetSubdomainModel:
        """
        get subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_subdomain_ex_async(
        self,
        request: pds_models.GetSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetSubdomainModel:
        """
        get subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_subdomains_ex(
        self,
        request: pds_models.ListSubdomainsRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListSubdomainsModel:
        """
        list subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListSubdomainsModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_subdomains_ex_async(
        self,
        request: pds_models.ListSubdomainsRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListSubdomainsModel:
        """
        list subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListSubdomainsModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def update_subdomain_ex(
        self,
        request: pds_models.UpdateSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateSubdomainModel:
        """
        update subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def update_subdomain_ex_async(
        self,
        request: pds_models.UpdateSubdomainRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateSubdomainModel:
        """
        update subdomain
        @tags subdomain
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error Forbidden User not authorized to operate on the specified APIs.
        @error InternalError The request has been failed due to some unknown error.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/subdomain/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateSubdomainModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_user_access_token_ex(
        self,
        request: pds_models.GetUserAccessTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetUserAccessTokenModel:
        """
        获取用户的accessToken
        @tags admin
        @error undefined undefined
        @error undefined undefined
        @error undefined undefined
        @error undefined undefined
        @error undefined undefined
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/user/get_access_token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetUserAccessTokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_user_access_token_ex_async(
        self,
        request: pds_models.GetUserAccessTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetUserAccessTokenModel:
        """
        获取用户的accessToken
        @tags admin
        @error undefined undefined
        @error undefined undefined
        @error undefined undefined
        @error undefined undefined
        @error undefined undefined
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/user/get_access_token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetUserAccessTokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_async_task_info_ex(
        self,
        request: pds_models.GetAsyncTaskRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetAsyncTaskInfoModel:
        """
        如果目录拷贝、目录删除不能在限定时间内完成，将访问一个异步任务id，
        通过此接口获取异步任务的信息，以确定任务是否执行成功。
        @tags async_task
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/async_task/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetAsyncTaskInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_async_task_info_ex_async(
        self,
        request: pds_models.GetAsyncTaskRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetAsyncTaskInfoModel:
        """
        如果目录拷贝、目录删除不能在限定时间内完成，将访问一个异步任务id，
        通过此接口获取异步任务的信息，以确定任务是否执行成功。
        @tags async_task
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/async_task/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetAsyncTaskInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def batch_operation_ex(
        self,
        request: pds_models.BatchRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.BatchOperationModel:
        """
        对多个原子操作封装成一个批处理请求，服务端并行处理并打包返回每个操作的执行结果。
        支持对文件和文件夹的移动、删除、修改，每个批处理请求最多包含100个原则操作。
        @tags batch
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/batch')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.BatchOperationModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def batch_operation_ex_async(
        self,
        request: pds_models.BatchRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.BatchOperationModel:
        """
        对多个原子操作封装成一个批处理请求，服务端并行处理并打包返回每个操作的执行结果。
        支持对文件和文件夹的移动、删除、修改，每个批处理请求最多包含100个原则操作。
        @tags batch
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/batch')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.BatchOperationModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def create_drive_ex(
        self,
        request: pds_models.CreateDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateDriveModel:
        """
        支持normal和large两种drive，
        large类型的drive用于文件数多的场景，不支持list操作，
        当drive的文件数量大于1亿时，建议使用large类型。
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def create_drive_ex_async(
        self,
        request: pds_models.CreateDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateDriveModel:
        """
        支持normal和large两种drive，
        large类型的drive用于文件数多的场景，不支持list操作，
        当drive的文件数量大于1亿时，建议使用large类型。
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def delete_drive_ex(
        self,
        request: pds_models.DeleteDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteDriveModel:
        """
        删除指定drive_id对应的Drive
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteDriveModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def delete_drive_ex_async(
        self,
        request: pds_models.DeleteDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteDriveModel:
        """
        删除指定drive_id对应的Drive
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteDriveModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_drive_ex(
        self,
        request: pds_models.GetDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetDriveModel:
        """
        获取指定drive_id对应的Drive详细信息。
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_drive_ex_async(
        self,
        request: pds_models.GetDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetDriveModel:
        """
        获取指定drive_id对应的Drive详细信息。
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_default_drive_ex(
        self,
        request: pds_models.GetDefaultDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetDefaultDriveModel:
        """
        一个用户可拥有多个drive，在创建drive时通过参数指定是否为这个用户的默认drive，
        每个用户只能设置一个默认drive。
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/get_default_drive')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetDefaultDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_default_drive_ex_async(
        self,
        request: pds_models.GetDefaultDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetDefaultDriveModel:
        """
        一个用户可拥有多个drive，在创建drive时通过参数指定是否为这个用户的默认drive，
        每个用户只能设置一个默认drive。
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/get_default_drive')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetDefaultDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_drives_ex(
        self,
        request: pds_models.ListDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListDrivesModel:
        """
        管理员列举指定用户的Drive
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListDrivesModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_drives_ex_async(
        self,
        request: pds_models.ListDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListDrivesModel:
        """
        管理员列举指定用户的Drive
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListDrivesModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_my_drives_ex(
        self,
        request: pds_models.ListMyDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListMyDrivesModel:
        """
        列举当前用户（访问令牌）的Drive
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/list_my_drives')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListMyDrivesModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_my_drives_ex_async(
        self,
        request: pds_models.ListMyDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListMyDrivesModel:
        """
        列举当前用户（访问令牌）的Drive
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/list_my_drives')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListMyDrivesModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def update_drive_ex(
        self,
        request: pds_models.UpdateDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateDriveModel:
        """
        更新指定drive_id的Drive信息
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def update_drive_ex_async(
        self,
        request: pds_models.UpdateDriveRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateDriveModel:
        """
        更新指定drive_id的Drive信息
        @tags drive
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/drive/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateDriveModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def archive_files_ex(
        self,
        request: pds_models.CCPArchiveFilesRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ArchiveFilesModel:
        """
        archive_files
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/archive_files')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ArchiveFilesModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def archive_files_ex_async(
        self,
        request: pds_models.CCPArchiveFilesRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ArchiveFilesModel:
        """
        archive_files
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/archive_files')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ArchiveFilesModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def complete_file_ex(
        self,
        request: pds_models.CompleteFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CompleteFileModel:
        """
        完成文件上传。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/complete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CompleteFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def complete_file_ex_async(
        self,
        request: pds_models.CompleteFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CompleteFileModel:
        """
        完成文件上传。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/complete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CompleteFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def copy_file_ex(
        self,
        request: pds_models.CopyFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CopyFileModel:
        """
        指定源文件或文件夹，拷贝到指定的文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/copy')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CopyFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CopyFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def copy_file_ex_async(
        self,
        request: pds_models.CopyFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CopyFileModel:
        """
        指定源文件或文件夹，拷贝到指定的文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/copy')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CopyFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CopyFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def create_file_ex(
        self,
        request: pds_models.CreateFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateFileModel:
        """
        在指定文件夹下创建文件或者文件夹，
        根文件夹用root表示，其他文件夹使用创建文件夹时返回的file_id。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def create_file_ex_async(
        self,
        request: pds_models.CreateFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateFileModel:
        """
        在指定文件夹下创建文件或者文件夹，
        根文件夹用root表示，其他文件夹使用创建文件夹时返回的file_id。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def create_file_with_proof_ex(
        self,
        request: pds_models.CreateFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateFileWithProofModel:
        """
        在指定文件夹下创建文件或者文件夹，
        根文件夹用root表示，其他文件夹使用创建文件夹时返回的file_id。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/create_with_proof')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateFileWithProofModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def create_file_with_proof_ex_async(
        self,
        request: pds_models.CreateFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateFileWithProofModel:
        """
        在指定文件夹下创建文件或者文件夹，
        根文件夹用root表示，其他文件夹使用创建文件夹时返回的file_id。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/create_with_proof')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateFileWithProofModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def delete_file_ex(
        self,
        request: pds_models.DeleteFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteFileModel:
        """
        指定文件或文件夹ID，删除文件或者文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.DeleteFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteFileModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def delete_file_ex_async(
        self,
        request: pds_models.DeleteFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteFileModel:
        """
        指定文件或文件夹ID，删除文件或者文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.DeleteFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteFileModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_file_ex(
        self,
        request: pds_models.GetFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetFileModel:
        """
        获取指定文件或文件夹ID的信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_file_ex_async(
        self,
        request: pds_models.GetFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetFileModel:
        """
        获取指定文件或文件夹ID的信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_file_by_path_ex(
        self,
        request: pds_models.GetFileByPathRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetFileByPathModel:
        """
        根据路径获取指定文件或文件夹的信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_by_path')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetFileByPathModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_file_by_path_ex_async(
        self,
        request: pds_models.GetFileByPathRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetFileByPathModel:
        """
        根据路径获取指定文件或文件夹的信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_by_path')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetFileByPathModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_download_url_ex(
        self,
        request: pds_models.GetDownloadUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetDownloadUrlModel:
        """
        获取文件的下载地址，调用者可自己设置range头并发下载。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_download_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetDownloadUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_download_url_ex_async(
        self,
        request: pds_models.GetDownloadUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetDownloadUrlModel:
        """
        获取文件的下载地址，调用者可自己设置range头并发下载。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_download_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetDownloadUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_last_cursor_ex(
        self,
        request: pds_models.GetLastCursorRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetLastCursorModel:
        """
        获取drive内，增量数据最新的游标
        @tags file_delta
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_last_cursor')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetLastCursorModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_last_cursor_ex_async(
        self,
        request: pds_models.GetLastCursorRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetLastCursorModel:
        """
        获取drive内，增量数据最新的游标
        @tags file_delta
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_last_cursor')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetLastCursorModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_media_play_url_ex(
        self,
        request: pds_models.GetMediaPlayURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetMediaPlayUrlModel:
        """
        获取media文件播放URL地址（当前仅支持m3u8）
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_media_play_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetMediaPlayUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_media_play_url_ex_async(
        self,
        request: pds_models.GetMediaPlayURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetMediaPlayUrlModel:
        """
        获取media文件播放URL地址（当前仅支持m3u8）
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_media_play_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetMediaPlayUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_office_edit_url_ex(
        self,
        request: pds_models.GetOfficeEditUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetOfficeEditUrlModel:
        """
        获取文档的在线编辑地址
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_office_edit_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetOfficeEditUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_office_edit_url_ex_async(
        self,
        request: pds_models.GetOfficeEditUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetOfficeEditUrlModel:
        """
        获取文档的在线编辑地址
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_office_edit_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetOfficeEditUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_office_preview_url_ex(
        self,
        request: pds_models.GetOfficePreviewUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetOfficePreviewUrlModel:
        """
        获取文档的预览地址（office文档）
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_office_preview_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetOfficePreviewUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_office_preview_url_ex_async(
        self,
        request: pds_models.GetOfficePreviewUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetOfficePreviewUrlModel:
        """
        获取文档的预览地址（office文档）
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_office_preview_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetOfficePreviewUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_share_link_download_url_ex(
        self,
        request: pds_models.GetShareLinkDownloadURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareLinkDownloadUrlModel:
        """
        获取分享中文件的下载地址，调用者可自己设置range头并发下载。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_share_link_download_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareLinkDownloadUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_share_link_download_url_ex_async(
        self,
        request: pds_models.GetShareLinkDownloadURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareLinkDownloadUrlModel:
        """
        获取分享中文件的下载地址，调用者可自己设置range头并发下载。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_share_link_download_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareLinkDownloadUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_share_link_video_preview_play_info_ex(
        self,
        request: pds_models.CCPGetShareLinkVideoPreviewPlayInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareLinkVideoPreviewPlayInfoModel:
        """
        获取分享中文件播放信息
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_share_link_video_preview_play_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareLinkVideoPreviewPlayInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_share_link_video_preview_play_info_ex_async(
        self,
        request: pds_models.CCPGetShareLinkVideoPreviewPlayInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareLinkVideoPreviewPlayInfoModel:
        """
        获取分享中文件播放信息
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_share_link_video_preview_play_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareLinkVideoPreviewPlayInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_upload_url_ex(
        self,
        request: pds_models.GetUploadUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetUploadUrlModel:
        """
        可指定分片信息，一次获取多个分片的上传地址。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_upload_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetUploadUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_upload_url_ex_async(
        self,
        request: pds_models.GetUploadUrlRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetUploadUrlModel:
        """
        可指定分片信息，一次获取多个分片的上传地址。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_upload_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetUploadUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_video_preview_play_info_ex(
        self,
        request: pds_models.CCPGetVideoPreviewPlayInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetVideoPreviewPlayInfoModel:
        """
        获取视频文件播放信息
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_video_preview_play_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetVideoPreviewPlayInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_video_preview_play_info_ex_async(
        self,
        request: pds_models.CCPGetVideoPreviewPlayInfoRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetVideoPreviewPlayInfoModel:
        """
        获取视频文件播放信息
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_video_preview_play_info')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetVideoPreviewPlayInfoModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_video_preview_sprite_url_ex(
        self,
        request: pds_models.GetVideoPreviewSpriteURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetVideoPreviewSpriteUrlModel:
        """
        获取视频雪碧图地址
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_video_preview_sprite_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetVideoPreviewSpriteUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_video_preview_sprite_url_ex_async(
        self,
        request: pds_models.GetVideoPreviewSpriteURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetVideoPreviewSpriteUrlModel:
        """
        获取视频雪碧图地址
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_video_preview_sprite_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetVideoPreviewSpriteUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_video_preview_url_ex(
        self,
        request: pds_models.GetVideoPreviewURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetVideoPreviewUrlModel:
        """
        获取视频播放地址
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_video_preview_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetVideoPreviewUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_video_preview_url_ex_async(
        self,
        request: pds_models.GetVideoPreviewURLRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetVideoPreviewUrlModel:
        """
        获取视频播放地址
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/get_video_preview_url')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetVideoPreviewUrlModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_file_ex(
        self,
        request: pds_models.ListFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileModel:
        """
        列举指定目录下的文件或文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_file_ex_async(
        self,
        request: pds_models.ListFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileModel:
        """
        列举指定目录下的文件或文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_file_activity_ex(
        self,
        request: pds_models.ListFileActivityRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileActivityModel:
        """
        list file activity
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_activity')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileActivityModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_file_activity_ex_async(
        self,
        request: pds_models.ListFileActivityRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileActivityModel:
        """
        list file activity
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_activity')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileActivityModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_file_by_anonymous_ex(
        self,
        request: pds_models.ListByAnonymousRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileByAnonymousModel:
        """
        查看分享中的文件列表
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ShareLinkTokenInvalid ShareToken is invalid. {message}
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_by_anonymous')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileByAnonymousModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_file_by_anonymous_ex_async(
        self,
        request: pds_models.ListByAnonymousRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileByAnonymousModel:
        """
        查看分享中的文件列表
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ShareLinkTokenInvalid ShareToken is invalid. {message}
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_by_anonymous')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileByAnonymousModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_file_by_custom_index_key_ex(
        self,
        request: pds_models.ListFileByCustomIndexKeyRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileByCustomIndexKeyModel:
        """
        根据自定义同步索引键列举文件或文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_by_custom_index_key')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileByCustomIndexKeyModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_file_by_custom_index_key_ex_async(
        self,
        request: pds_models.ListFileByCustomIndexKeyRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileByCustomIndexKeyModel:
        """
        根据自定义同步索引键列举文件或文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_by_custom_index_key')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileByCustomIndexKeyModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_file_delta_ex(
        self,
        request: pds_models.ListFileDeltaRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileDeltaModel:
        """
        获取drive内，增量数据列表
        @tags file_delta
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_delta')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileDeltaModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_file_delta_ex_async(
        self,
        request: pds_models.ListFileDeltaRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListFileDeltaModel:
        """
        获取drive内，增量数据列表
        @tags file_delta
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_delta')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListFileDeltaModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_uploaded_parts_ex(
        self,
        request: pds_models.ListUploadedPartRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListUploadedPartsModel:
        """
        列举upload_id对应的已上传分片。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_uploaded_parts')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListUploadedPartsModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_uploaded_parts_ex_async(
        self,
        request: pds_models.ListUploadedPartRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListUploadedPartsModel:
        """
        列举upload_id对应的已上传分片。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/list_uploaded_parts')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListUploadedPartsModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def live_transcode_ex(
        self,
        request: pds_models.CCPLiveTranscodeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.LiveTranscodeModel:
        """
        live_transcode
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/live_transcode')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.LiveTranscodeModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def live_transcode_ex_async(
        self,
        request: pds_models.CCPLiveTranscodeRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.LiveTranscodeModel:
        """
        live_transcode
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/live_transcode')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.LiveTranscodeModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def move_file_ex(
        self,
        request: pds_models.MoveFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.MoveFileModel:
        """
        指定源文件或文件夹，移动到指定的文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/move')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.MoveFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def move_file_ex_async(
        self,
        request: pds_models.MoveFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.MoveFileModel:
        """
        指定源文件或文件夹，移动到指定的文件夹。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/move')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.MoveFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def token_ex(
        self,
        request: pds_models.RefreshOfficeEditTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.TokenModel:
        """
        刷新在线编辑Token
        @tags file, refresh, office, edit
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/refresh_office_edit_token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.TokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def token_ex_async(
        self,
        request: pds_models.RefreshOfficeEditTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.TokenModel:
        """
        刷新在线编辑Token
        @tags file, refresh, office, edit
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/refresh_office_edit_token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.TokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def scan_file_meta_ex(
        self,
        request: pds_models.ScanFileMetaRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ScanFileMetaModel:
        """
        在指定drive下全量获取文件元信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/scan')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ScanFileMetaModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def scan_file_meta_ex_async(
        self,
        request: pds_models.ScanFileMetaRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ScanFileMetaModel:
        """
        在指定drive下全量获取文件元信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/scan')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ScanFileMetaModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def search_file_ex(
        self,
        request: pds_models.SearchFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.SearchFileModel:
        """
        根据筛选条件，在指定drive下搜索文件。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/search')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.SearchFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def search_file_ex_async(
        self,
        request: pds_models.SearchFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.SearchFileModel:
        """
        根据筛选条件，在指定drive下搜索文件。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/search')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.SearchFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def update_file_ex(
        self,
        request: pds_models.UpdateFileMetaRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateFileModel:
        """
        对指定的文件或文件夹更新信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def update_file_ex_async(
        self,
        request: pds_models.UpdateFileMetaRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateFileModel:
        """
        对指定的文件或文件夹更新信息。
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error AlreadyExist {resource} has already exists. {extra_msg}
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def walk_file_ex(
        self,
        request: pds_models.CCPWalkFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.WalkFileModel:
        """
        walk file
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/walk')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.WalkFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def walk_file_ex_async(
        self,
        request: pds_models.CCPWalkFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.WalkFileModel:
        """
        walk file
        @tags file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/file/walk')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.WalkFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def clear_recyclebin_ex(
        self,
        request: pds_models.ClearRecycleBinRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ClearRecyclebinModel:
        """
        clear_recyclebin
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/clear')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ClearRecyclebinModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def clear_recyclebin_ex_async(
        self,
        request: pds_models.ClearRecycleBinRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ClearRecyclebinModel:
        """
        clear_recyclebin
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/clear')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ClearRecyclebinModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_recyclebin_ex(
        self,
        request: pds_models.ListFileInRecycleBinRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListRecyclebinModel:
        """
        list_recyclebin
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListRecyclebinModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_recyclebin_ex_async(
        self,
        request: pds_models.ListFileInRecycleBinRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListRecyclebinModel:
        """
        list_recyclebin
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListRecyclebinModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def restore_file_ex(
        self,
        request: pds_models.RestoreFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.RestoreFileModel:
        """
        restore_file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/restore')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.RestoreFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.RestoreFileModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def restore_file_ex_async(
        self,
        request: pds_models.RestoreFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.RestoreFileModel:
        """
        restore_file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/restore')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.RestoreFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.RestoreFileModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def trash_file_ex(
        self,
        request: pds_models.TrashFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.TrashFileModel:
        """
        trash_file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/trash')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.TrashFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.TrashFileModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def trash_file_ex_async(
        self,
        request: pds_models.TrashFileRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.TrashFileModel:
        """
        trash_file
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/recyclebin/trash')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 202):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.TrashFileModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.TrashFileModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def report_event_ex(
        self,
        request: pds_models.ReportEventRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ReportEventModel:
        """
        上报事件
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/report_event')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ReportEventModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def report_event_ex_async(
        self,
        request: pds_models.ReportEventRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ReportEventModel:
        """
        上报事件
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/report_event')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ReportEventModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def create_share_ex(
        self,
        request: pds_models.CreateShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateShareModel:
        """
        创建共享。
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def create_share_ex_async(
        self,
        request: pds_models.CreateShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateShareModel:
        """
        创建共享。
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def delete_share_ex(
        self,
        request: pds_models.DeleteShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteShareModel:
        """
        删除指定共享
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteShareModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def delete_share_ex_async(
        self,
        request: pds_models.DeleteShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteShareModel:
        """
        删除指定共享
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteShareModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_share_ex(
        self,
        request: pds_models.GetShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareModel:
        """
        获取共享信息。
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_share_ex_async(
        self,
        request: pds_models.GetShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareModel:
        """
        获取共享信息。
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_share_ex(
        self,
        request: pds_models.ListShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListShareModel:
        """
        列举指定用户的共享
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_share_ex_async(
        self,
        request: pds_models.ListShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListShareModel:
        """
        列举指定用户的共享
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def update_share_ex(
        self,
        request: pds_models.UpdateShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateShareModel:
        """
        修改指定共享
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def update_share_ex_async(
        self,
        request: pds_models.UpdateShareRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateShareModel:
        """
        修改指定共享
        @tags share
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateShareModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def cancel_share_link_ex(
        self,
        request: pds_models.CancelShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CancelShareLinkModel:
        """
        取消指定分享
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/cancel')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.CancelShareLinkModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def cancel_share_link_ex_async(
        self,
        request: pds_models.CancelShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CancelShareLinkModel:
        """
        取消指定分享
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/cancel')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.CancelShareLinkModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def create_share_link_ex(
        self,
        request: pds_models.CreateShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateShareLinkModel:
        """
        创建分享。
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def create_share_link_ex_async(
        self,
        request: pds_models.CreateShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateShareLinkModel:
        """
        创建分享。
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error NotFound The resource {resource_name} cannot be found. Please check.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_share_link_ex(
        self,
        request: pds_models.GetShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareLinkModel:
        """
        查看分享的所有信息
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_share_link_ex_async(
        self,
        request: pds_models.GetShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareLinkModel:
        """
        查看分享的所有信息
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_share_by_anonymous_ex(
        self,
        request: pds_models.GetShareLinkByAnonymousRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareByAnonymousModel:
        """
        查看分享的基本信息，比如分享者、到期时间等
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get_by_anonymous')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareByAnonymousModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_share_by_anonymous_ex_async(
        self,
        request: pds_models.GetShareLinkByAnonymousRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareByAnonymousModel:
        """
        查看分享的基本信息，比如分享者、到期时间等
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get_by_anonymous')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareByAnonymousModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_share_id_ex(
        self,
        request: pds_models.GetShareLinkIDRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareIdModel:
        """
        使用分享口令换取分享id
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get_share_id')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareIdModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_share_id_ex_async(
        self,
        request: pds_models.GetShareLinkIDRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareIdModel:
        """
        使用分享口令换取分享id
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get_share_id')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareIdModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_share_token_ex(
        self,
        request: pds_models.GetShareLinkTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareTokenModel:
        """
        使用分享码+提取码换取分享token
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get_share_token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareTokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_share_token_ex_async(
        self,
        request: pds_models.GetShareLinkTokenRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetShareTokenModel:
        """
        使用分享码+提取码换取分享token
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/get_share_token')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetShareTokenModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def list_share_link_ex(
        self,
        request: pds_models.ListShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListShareLinkModel:
        """
        列举指定用户的分享
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def list_share_link_ex_async(
        self,
        request: pds_models.ListShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.ListShareLinkModel:
        """
        列举指定用户的分享
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/list')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.ListShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def update_share_link_ex(
        self,
        request: pds_models.UpdateShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateShareLinkModel:
        """
        更新分享。
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def update_share_link_ex_async(
        self,
        request: pds_models.UpdateShareLinkRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.UpdateShareLinkModel:
        """
        更新分享。
        @tags share_link
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/share_link/update')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.UpdateShareLinkModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def create_group_ex(
        self,
        request: pds_models.CreateGroupRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateGroupModel:
        """
        创建用户组
        @tags group
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/group/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateGroupModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def create_group_ex_async(
        self,
        request: pds_models.CreateGroupRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.CreateGroupModel:
        """
        创建用户组
        @tags group
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/group/create')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 201):
                    obj = await UtilClient.read_as_json_async(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.CreateGroupModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def delete_group_ex(
        self,
        request: pds_models.DeleteGroupRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteGroupModel:
        """
        删除用户组
        @tags group
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/group/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteGroupModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def delete_group_ex_async(
        self,
        request: pds_models.DeleteGroupRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.DeleteGroupModel:
        """
        删除用户组
        @tags group
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = await self.get_access_key_id_async()
                access_key_secret = await self.get_access_key_secret_async()
                security_token = await self.get_security_token_async()
                access_token = await self.get_access_token_async()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/group/delete')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = await TeaCore.async_do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 204):
                    return TeaCore.from_map(
                        pds_models.DeleteGroupModel(),
                        {
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = await UtilClient.read_as_json_async(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    def get_group_ex(
        self,
        request: pds_models.GetGroupRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetGroupModel:
        """
        获取用户组
        @tags group
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': runtime.http_proxy,
            'httpsProxy': runtime.https_proxy,
            'noProxy': runtime.no_proxy,
            'maxIdleConns': runtime.max_idle_conns,
            'socks5Proxy': runtime.socks_5proxy,
            'socks5NetWork': runtime.socks_5net_work,
            'retry': {
                'retryable': runtime.autoretry,
                'maxAttempts': UtilClient.default_number(runtime.max_attempts, 3)
            },
            'backoff': {
                'policy': UtilClient.default_string(runtime.backoff_policy, 'no'),
                'period': UtilClient.default_number(runtime.backoff_period, 1)
            },
            'ignoreSSL': runtime.ignore_ssl
        }
        _last_request = None
        _last_exception = None
        _now = time.time()
        _retry_times = 0
        while TeaCore.allow_retry(_runtime.get('retry'), _retry_times, _now):
            if _retry_times > 0:
                _backoff_time = TeaCore.get_backoff_time(_runtime.get('backoff'), _retry_times)
                if _backoff_time > 0:
                    TeaCore.sleep(_backoff_time)
            _retry_times = _retry_times + 1
            try:
                _request = TeaRequest()
                accesskey_id = self.get_access_key_id()
                access_key_secret = self.get_access_key_secret()
                security_token = self.get_security_token()
                access_token = self.get_access_token()
                real_req = UtilClient.to_map(request)
                _request.protocol = UtilClient.default_string(self._protocol, 'https')
                _request.method = 'POST'
                _request.pathname = self.get_pathname(self._nickname, f'/v2/group/get')
                _request.headers = TeaCore.merge({
                    'user-agent': self.get_user_agent(),
                    'host': UtilClient.default_string(self._endpoint, f'{self._domain_id}.api.aliyunpds.com'),
                    'content-type': 'application/json; charset=utf-8'
                }, request.headers)
                real_req['headers'] = None
                if not UtilClient.empty(access_token):
                    _request.headers['authorization'] = f'Bearer {access_token}'
                elif not UtilClient.empty(accesskey_id) and not UtilClient.empty(access_key_secret):
                    if not UtilClient.empty(security_token):
                        _request.headers['x-acs-security-token'] = security_token
                    _request.headers['date'] = UtilClient.get_date_utcstring()
                    _request.headers['accept'] = 'application/json'
                    _request.headers['x-acs-signature-method'] = 'HMAC-SHA1'
                    _request.headers['x-acs-signature-version'] = '1.0'
                    string_to_sign = ROAUtilClient.get_string_to_sign(_request)
                    _request.headers['authorization'] = f'acs {accesskey_id}:{ROAUtilClient.get_signature(string_to_sign, access_key_secret)}'
                _request.body = UtilClient.to_jsonstring(real_req)
                _last_request = _request
                _response = TeaCore.do_action(_request, _runtime)
                resp_map = None
                obj = None
                if UtilClient.equal_number(_response.status_code, 200):
                    obj = UtilClient.read_as_json(_response.body)
                    resp_map = UtilClient.assert_as_map(obj)
                    return TeaCore.from_map(
                        pds_models.GetGroupModel(),
                        {
                            'body': resp_map,
                            'headers': _response.headers
                        }
                    )
                if not UtilClient.empty(_response.headers.get('x-ca-error-message')):
                    raise TeaException({
                        'data': {
                            'requestId': _response.headers.get('x-ca-request-id'),
                            'statusCode': _response.status_code,
                            'statusMessage': _response.status_message
                        },
                        'message': _response.headers.get('x-ca-error-message')
                    })
                obj = UtilClient.read_as_json(_response.body)
                resp_map = UtilClient.assert_as_map(obj)
                raise TeaException(TeaCore.merge({
                    'data': {
                        'requestId': _response.headers.get('x-ca-request-id'),
                        'statusCode': _response.status_code,
                        'statusMessage': _response.status_message
                    }
                }, resp_map))
            except Exception as e:
                if TeaCore.is_retryable(e):
                    _last_exception = e
                    continue
                raise e
        raise UnretryableException(_last_request, _last_exception)

    async def get_group_ex_async(
        self,
        request: pds_models.GetGroupRequest,
        runtime: pds_models.RuntimeOptions,
    ) -> pds_models.GetGroupModel:
        """
        获取用户组
        @tags group
        @error InvalidParameter The input parameter {parameter_name} is not valid.
        @error AccessTokenInvalid AccessToken is invalid. {message}
        @error ForbiddenNoPermission No Permission to access resource {resource_name}.
        @error InternalError The request has been failed due to some unknown error.
        @error ServiceUnavailable The request has failed due to a temporary failure of the server.
        """
        request.validate()
        runtime.validate()
        _runtime = {
            'timeouted': 'retry',
            'readTimeout': runtime.read_timeout,
            'connectTimeout': runtime.connect_timeout,
            'localAddr': runtime.local_addr,
            'httpProxy': run