#!/usr/bin/env python3

# SPDX-FileCopyrightText: 2025 Ilya Egorov <0x42005e1f@gmail.com>
# SPDX-License-Identifier: ISC

import sys

from typing import Any, Protocol

if sys.version_info >= (3, 9):
    from collections.abc import Generator
else:
    from typing import Generator

class Waiter(Protocol):
    __slots__ = ()

    def wake(self, /) -> None: ...

class GreenWaiter(Waiter, Protocol):
    __slots__ = ()

    def __init__(self, /, *, shield: bool = False) -> None: ...
    def wait(self, /, timeout: float | None = None) -> bool: ...
    @property
    def shield(self, /) -> bool: ...
    @shield.setter
    def shield(self, /, value: bool) -> None: ...

class AsyncWaiter(Waiter, Protocol):
    __slots__ = ()

    def __init__(self, /, *, shield: bool = False) -> None: ...
    def __await__(self, /) -> Generator[Any, Any, bool]: ...
    @property
    def shield(self, /) -> bool: ...
    @shield.setter
    def shield(self, /, value: bool) -> None: ...

def _get_threading_waiter_class() -> type[GreenWaiter]: ...
def _get_eventlet_waiter_class() -> type[GreenWaiter]: ...
def _get_gevent_waiter_class() -> type[GreenWaiter]: ...
def _get_asyncio_waiter_class() -> type[AsyncWaiter]: ...
def _get_curio_waiter_class() -> type[AsyncWaiter]: ...
def _get_trio_waiter_class() -> type[AsyncWaiter]: ...
def _create_threading_waiter(shield: bool = False) -> GreenWaiter: ...
def _create_eventlet_waiter(shield: bool = False) -> GreenWaiter: ...
def _create_gevent_waiter(shield: bool = False) -> GreenWaiter: ...
def _create_asyncio_waiter(shield: bool = False) -> AsyncWaiter: ...
def _create_curio_waiter(shield: bool = False) -> AsyncWaiter: ...
def _create_trio_waiter(shield: bool = False) -> AsyncWaiter: ...
def create_green_waiter(*, shield: bool = False) -> GreenWaiter: ...
def create_async_waiter(*, shield: bool = False) -> AsyncWaiter: ...
