#!/usr/bin/env python3

# SPDX-FileCopyrightText: 2025 Ilya Egorov <0x42005e1f@gmail.com>
# SPDX-License-Identifier: ISC

import sys

from typing import Final, NoReturn, TypeVar

if sys.version_info >= (3, 9):
    from collections.abc import Awaitable, Callable
else:
    from typing import Awaitable, Callable

_T = TypeVar("_T")

_DAY_TO_SEC: Final[int]

_MS_TO_SEC: Final[int]
_NS_TO_SEC: Final[int]

def _floor_to_float(value: int, pow10: int = 0, /) -> float: ...
def _threading_seconds_per_sleep() -> float: ...
def _eventlet_seconds_per_sleep() -> float: ...
def _gevent_seconds_per_sleep() -> float: ...
def _asyncio_seconds_per_sleep() -> float: ...
def _curio_seconds_per_sleep() -> float: ...
def _trio_seconds_per_sleep() -> float: ...
def green_seconds_per_sleep() -> float: ...
def async_seconds_per_sleep() -> float: ...
def _threading_seconds_per_timeout() -> float: ...
def _eventlet_seconds_per_timeout() -> float: ...
def _gevent_seconds_per_timeout() -> float: ...
def _asyncio_seconds_per_timeout() -> float: ...
def _curio_seconds_per_timeout() -> float: ...
def _trio_seconds_per_timeout() -> float: ...
def green_seconds_per_timeout() -> float: ...
def async_seconds_per_timeout() -> float: ...
def _threading_clock() -> float: ...
def _eventlet_clock() -> float: ...
def _gevent_clock() -> float: ...
def _asyncio_clock() -> float: ...
def _curio_clock() -> float: ...
def _trio_clock() -> float: ...
def green_clock() -> float: ...
def async_clock() -> float: ...
def _threading_sleep(seconds: float, /) -> None: ...
def _eventlet_sleep(seconds: float, /) -> None: ...
def _gevent_sleep(seconds: float, /) -> None: ...
async def _asyncio_sleep(seconds: float, /) -> None: ...
async def _curio_sleep(seconds: float, /) -> None: ...
async def _trio_sleep(seconds: float, /) -> None: ...
def _green_long_sleep(
    sleep: Callable[[float], _T],
    seconds: float,
    /,
    seconds_per_sleep: float,
    *,
    clock: Callable[[], float],
    check: bool = False,
) -> _T: ...
async def _async_long_sleep(
    sleep: Callable[[float], Awaitable[_T]],
    seconds: float,
    /,
    seconds_per_sleep: float,
    *,
    clock: Callable[[], float],
    check: bool = False,
) -> _T: ...
def green_sleep(seconds: float, /) -> None: ...
async def async_sleep(seconds: float, /) -> None: ...
def _threading_sleep_until(deadline: float, /) -> None: ...
def _eventlet_sleep_until(deadline: float, /) -> None: ...
def _gevent_sleep_until(deadline: float, /) -> None: ...
async def _asyncio_sleep_until(deadline: float, /) -> None: ...
async def _curio_sleep_until(deadline: float, /) -> None: ...
async def _trio_sleep_until(deadline: float, /) -> None: ...
def _green_long_sleep_until(
    sleep_until: Callable[[float], _T],
    deadline: float,
    /,
    seconds_per_sleep: float,
    *,
    clock: Callable[[], float],
    check: bool = False,
) -> _T: ...
async def _async_long_sleep_until(
    sleep_until: Callable[[float], Awaitable[_T]],
    deadline: float,
    /,
    seconds_per_sleep: float,
    *,
    clock: Callable[[], float],
    check: bool = False,
) -> _T: ...
def green_sleep_until(deadline: float, /) -> None: ...
async def async_sleep_until(deadline: float, /) -> None: ...
def _threading_sleep_forever() -> NoReturn: ...
def _eventlet_sleep_forever() -> NoReturn: ...
def _gevent_sleep_forever() -> NoReturn: ...
async def _asyncio_sleep_forever() -> NoReturn: ...
async def _curio_sleep_forever() -> NoReturn: ...
async def _trio_sleep_forever() -> NoReturn: ...
def green_sleep_forever() -> NoReturn: ...
async def async_sleep_forever() -> NoReturn: ...
