#!/usr/bin/env python3

# SPDX-FileCopyrightText: 2025 Ilya Egorov <0x42005e1f@gmail.com>
# SPDX-License-Identifier: ISC

import sys

from collections import deque
from typing import (
    Any,
    ClassVar,
    Final,
    Generic,
    NoReturn,
    SupportsIndex,
    TypeVar,
)

from aiologic.meta import DEFAULT, MISSING, DefaultType, MissingType

if sys.version_info >= (3, 9):
    from collections.abc import Iterable, Iterator, MutableSequence
else:
    from typing import Iterable, Iterator, MutableSequence

if sys.version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self

_USE_SIMPLEQUEUE: Final[bool]

_USE_ONCELOCK: Final[bool]

_WRAPPER_ASSIGNMENTS: tuple[str, ...]

_T = TypeVar("_T")

class lazydeque(MutableSequence[_T]):
    __slots__ = (
        "__weakref__",
        "_data",
        "_data_holder",
        "_maxlen",
    )

    def __new__(
        cls,
        /,
        iterable: Iterable[_T] | MissingType = MISSING,
        maxlen: int | None = None,
    ) -> Self: ...
    def __getnewargs__(self, /) -> tuple[Any, ...]: ...
    def __getstate__(self, /) -> None: ...
    def __copy__(self, /) -> Self: ...
    def __repr__(self, /) -> str: ...
    __hash__: ClassVar[None]  # type: ignore[assignment]
    def __eq__(self, value: object, /) -> bool: ...
    def __ne__(self, value: object, /) -> bool: ...
    def __lt__(self, value: lazydeque[_T] | deque[_T], /) -> bool: ...
    def __le__(self, value: lazydeque[_T] | deque[_T], /) -> bool: ...
    def __gt__(self, value: lazydeque[_T] | deque[_T], /) -> bool: ...
    def __ge__(self, value: lazydeque[_T] | deque[_T], /) -> bool: ...
    def __add__(self, value: lazydeque[_T] | deque[_T], /) -> Self: ...
    def __radd__(self, value: lazydeque[_T] | deque[_T], /) -> Self: ...
    def __mul__(self, value: SupportsIndex, /) -> Self: ...
    def __rmul__(self, value: SupportsIndex, /) -> Self: ...
    def __iadd__(self, value: Iterable[_T], /) -> Self: ...
    def __imul__(self, value: SupportsIndex, /) -> Self: ...
    def __getitem__(  # type: ignore[override]
        self,
        key: SupportsIndex,
        /,
    ) -> _T: ...
    def __setitem__(  # type: ignore[override]
        self,
        key: SupportsIndex,
        value: _T,
        /,
    ) -> None: ...
    def __delitem__(  # type: ignore[override]
        self,
        key: SupportsIndex,
        /,
    ) -> None: ...
    def __contains__(self, key: object, /) -> bool: ...
    def __bool__(self, /) -> bool: ...
    def __len__(self, /) -> int: ...
    def __iter__(self, /) -> Iterator[_T]: ...
    def __reversed__(self, /) -> Iterator[_T]: ...
    def _init(self, /) -> deque[_T]: ...
    def _iter(self, /) -> Iterator[_T]: ...
    def _reversed(self, /) -> Iterator[_T]: ...
    def copy(self, /) -> Self: ...
    def append(self, x: _T, /) -> None: ...
    def appendleft(self, x: _T, /) -> None: ...
    def extend(self, iterable: Iterable[_T], /) -> None: ...
    def extendleft(self, iterable: Iterable[_T], /) -> None: ...
    def insert(self, i: int, x: _T, /) -> None: ...
    def index(
        self,
        x: _T,
        start: SupportsIndex | DefaultType = DEFAULT,
        stop: SupportsIndex | DefaultType = DEFAULT,
        /,
    ) -> int: ...
    def count(self, x: _T, /) -> int: ...
    def rotate(self, n: SupportsIndex = 1, /) -> None: ...
    def reverse(self, /) -> None: ...
    def remove(self, value: _T, /) -> None: ...
    def pop(self, /) -> _T: ...  # type: ignore[override]
    def popleft(self, /) -> _T: ...
    def clear(self, /) -> None: ...
    @property
    def maxlen(self, /) -> int | None: ...

class lazyqueue(Generic[_T]):
    __slots__ = (
        "__weakref__",
        "_data",
        "_data_holder",
    )

    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> NoReturn: ...
    def __repr__(self, /) -> str: ...
    def __bool__(self, /) -> bool: ...
    def __len__(self, /) -> int: ...
    def _init(self, /) -> Any: ...
    def put(self, x: _T, /) -> None: ...
    def get(self, /) -> _T: ...
