#!/usr/bin/env python3

# SPDX-FileCopyrightText: 2025 Ilya Egorov <0x42005e1f@gmail.com>
# SPDX-License-Identifier: ISC

import sys

from typing import Any, Final

from .meta import DEFAULT, MISSING, DefaultType, MissingType

if sys.version_info >= (3, 11):
    from typing import Self, overload
else:
    from typing_extensions import Self, overload

if sys.version_info >= (3, 9):
    from collections.abc import Callable, Generator
else:
    from typing import Callable, Generator

_PERFECT_FAIRNESS_ENABLED: Final[bool]

_USE_ONCELOCK: Final[bool]
_USE_ONCELOCK_FORCED: Final[bool]

class Event:
    __slots__ = (
        "__weakref__",
        "_is_unset",
        "_waiters",
    )

    def __new__(cls, /) -> Self: ...
    def __getnewargs__(self, /) -> tuple[Any, ...]: ...
    def __getstate__(self, /) -> None: ...
    def __copy__(self, /) -> Self: ...
    def __repr__(self, /) -> str: ...
    def __bool__(self, /) -> bool: ...
    def __await__(self, /) -> Generator[Any, Any, bool]: ...
    def wait(self, /, timeout: float | None = None) -> bool: ...
    def set(self, /) -> None: ...
    def is_set(self, /) -> bool: ...
    def _wakeup(self, /) -> None: ...
    @property
    def waiting(self, /) -> int: ...

class REvent(Event):
    __slots__ = ("_timer",)

    def __new__(cls, /) -> Self: ...
    def __getnewargs__(self, /) -> tuple[Any, ...]: ...
    def __getstate__(self, /) -> None: ...
    def __copy__(self, /) -> Self: ...
    def __repr__(self, /) -> str: ...
    def __bool__(self, /) -> bool: ...
    def __await__(self, /) -> Generator[Any, Any, bool]: ...
    def wait(self, /, timeout: float | None = None) -> bool: ...
    def clear(self, /) -> None: ...
    def set(self, /) -> None: ...
    def is_set(self, /) -> bool: ...
    def _wakeup(self, /, deadline: float | None = None) -> None: ...
    @property
    def waiting(self, /) -> int: ...

class CountdownEvent:
    __slots__ = (
        "__weakref__",
        "_initial_value",
        "_is_unset",
        "_timer",
        "_waiters",
    )

    def __new__(
        cls,
        /,
        initial_value: int | DefaultType = DEFAULT,
    ) -> Self: ...
    def __getnewargs__(self, /) -> tuple[Any, ...]: ...
    def __getstate__(self, /) -> None: ...
    def __copy__(self, /) -> Self: ...
    def __repr__(self, /) -> str: ...
    def __bool__(self, /) -> bool: ...
    def __await__(self, /) -> Generator[Any, Any, bool]: ...
    def wait(self, /, timeout: float | None = None) -> bool: ...
    def up(self, /, count: int = 1) -> None: ...
    def down(self, /) -> None: ...
    def clear(self, /) -> None: ...
    @overload
    def _get(
        self,
        /,
        default: object = MISSING,
        *,
        default_factory: MissingType = MISSING,
    ) -> object: ...
    @overload
    def _get(
        self,
        /,
        default: MissingType = MISSING,
        *,
        default_factory: Callable[[], object],
    ) -> object: ...
    def _wakeup(self, /, deadline: float | None = None) -> None: ...
    @property
    def initial_value(self, /) -> int: ...
    @property
    def value(self, /) -> int: ...
    @property
    def waiting(self, /) -> bool: ...
