#!/usr/bin/env python3

# SPDX-FileCopyrightText: 2025 Ilya Egorov <0x42005e1f@gmail.com>
# SPDX-License-Identifier: ISC

import sys

from types import TracebackType
from typing import Any, Final

from .meta import DEFAULT, DefaultType

if sys.version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self

if sys.version_info >= (3, 9):
    from collections.abc import Generator
else:
    from typing import Generator

_PERFECT_FAIRNESS_ENABLED: Final[bool]

_USE_ONCELOCK: Final[bool]
_USE_ONCELOCK_FORCED: Final[bool]

class BrokenBarrierError(RuntimeError): ...

class Latch:
    __slots__ = (
        "__weakref__",
        "_filling",
        "_parties",
        "_unbroken",
        "_waiters",
    )

    def __new__(cls, /, parties: int | DefaultType = DEFAULT) -> Self: ...
    def __getnewargs__(self, /) -> tuple[Any, ...]: ...
    def __getstate__(self, /) -> None: ...
    def __copy__(self, /) -> Self: ...
    def __repr__(self, /) -> str: ...
    def __bool__(self, /) -> bool: ...
    def __await__(self, /) -> Generator[Any, Any]: ...
    def wait(self, /, timeout: float | None = None) -> None: ...
    def abort(self, /) -> None: ...
    def _wakeup_if_reached(self, /) -> bool: ...
    def _wakeup(self, /, unbroken: bool) -> None: ...
    @property
    def parties(self, /) -> int: ...
    @property
    def broken(self, /) -> bool: ...
    @property
    def waiting(self, /) -> int: ...

class Barrier:
    __slots__ = (
        "__weakref__",
        "_parties",
        "_unbroken",
        "_unlocked",
        "_waiters",
    )

    def __new__(cls, /, parties: int | DefaultType = DEFAULT) -> Self: ...
    def __getnewargs__(self, /) -> tuple[Any, ...]: ...
    def __getstate__(self, /) -> None: ...
    def __copy__(self, /) -> Self: ...
    def __repr__(self, /) -> str: ...
    async def __aenter__(self, /) -> int: ...
    def __enter__(self, /) -> int: ...
    async def __aexit__(
        self,
        /,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> None: ...
    def __exit__(
        self,
        /,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> None: ...
    def __await__(self, /) -> Generator[Any, Any, int]: ...
    def wait(self, /, timeout: float | None = None) -> int: ...
    def abort(self, /) -> None: ...
    def _acquire_nowait_if_reached(self, /) -> bool: ...
    def _wakeup_if_reached(self, /) -> bool: ...
    def _wakeup(self, /) -> bool: ...
    def _wakeup_on_draining_pf(self, /, tokens_marker: object) -> None: ...
    def _wakeup_on_draining(self, /, tokens: list[Any]) -> None: ...
    def _wakeup_on_breaking(self, /) -> None: ...
    def _release(self, /) -> None: ...
    @property
    def parties(self, /) -> int: ...
    @property
    def broken(self, /) -> bool: ...
    @property
    def waiting(self, /) -> int: ...

class RBarrier(Barrier):
    __slots__ = (
        "_resetting",
        "_timer",
    )

    def __new__(cls, /, parties: int | DefaultType = DEFAULT) -> Self: ...
    def __getnewargs__(self, /) -> tuple[Any, ...]: ...
    def __getstate__(self, /) -> None: ...
    def __copy__(self, /) -> Self: ...
    def __repr__(self, /) -> str: ...
    async def __aenter__(self, /) -> int: ...
    def __enter__(self, /) -> int: ...
    async def __aexit__(
        self,
        /,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> None: ...
    def __exit__(
        self,
        /,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> None: ...
    def __await__(self, /) -> Generator[Any, Any, int]: ...
    def wait(self, /, timeout: float | None = None) -> int: ...
    def reset(self, /) -> None: ...
    def abort(self, /) -> None: ...
    def _wakeup(self, /) -> bool: ...
    def _wakeup_on_draining_pf(self, /, tokens_marker: object) -> None: ...
    def _wakeup_on_draining(self, /, tokens: list[Any]) -> None: ...
    def _wakeup_on_breaking(
        self,
        /,
        deadline: float | None = None,
    ) -> None: ...
    @property
    def parties(self, /) -> int: ...
    @property
    def broken(self, /) -> bool: ...
    @property
    def waiting(self, /) -> int: ...
