# Generated by Django 4.2.11 on 2024-06-09 07:44

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('endoreg_db', '0037_alter_medicationindication_sources'),
    ]

    operations = [
        migrations.CreateModel(
            name='EmissionFactor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('value', models.FloatField()),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='Material',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ProductGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Waste',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TransportRoute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('distance', models.FloatField()),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='ReferenceProduct',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('emission_factor_package', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_product_package', to='endoreg_db.emissionfactor')),
                ('emission_factor_product', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_product_product', to='endoreg_db.emissionfactor')),
                ('emission_factor_total', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.product')),
                ('product_group', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='reference_product', to='endoreg_db.productgroup')),
            ],
        ),
        migrations.CreateModel(
            name='ProductWeight',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, null=True)),
                ('measured', models.FloatField(null=True)),
                ('verified', models.FloatField(null=True)),
                ('manufacturer', models.FloatField(null=True)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.product')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='ProductMaterial',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('component', models.CharField(max_length=255)),
                ('quantity', models.FloatField()),
                ('material', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.material')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='product_materials', to='endoreg_db.product')),
                ('unit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit')),
            ],
        ),
        migrations.AddField(
            model_name='product',
            name='product_group',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.productgroup'),
        ),
        migrations.AddField(
            model_name='product',
            name='transport_route',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.transportroute'),
        ),
        migrations.CreateModel(
            name='CenterWaste',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField()),
                ('quantity', models.FloatField()),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
                ('waste', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.waste')),
            ],
        ),
        migrations.CreateModel(
            name='CenterResource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, null=True)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('quantity', models.FloatField()),
                ('year', models.IntegerField()),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('resource', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.resource')),
                ('transport_emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='center_resource_transport_emission_factor', to='endoreg_db.emissionfactor')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
                ('use_emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='center_resource_use_emission_factor', to='endoreg_db.emissionfactor')),
            ],
        ),
        migrations.CreateModel(
            name='CenterProduct',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_used', models.DateField()),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.product')),
            ],
        ),
    ]
