# Generated by Django 4.2.11 on 2024-04-26 09:59

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('endoreg_db', '0025_event_alter_rawpdffile_file_patientevent'),
    ]

    operations = [
        migrations.CreateModel(
            name='Disease',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DiseaseClassification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('disease', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.disease')),
            ],
        ),
        migrations.CreateModel(
            name='DiseaseClassificationChoice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('disease_classification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.diseaseclassification')),
            ],
        ),
        migrations.CreateModel(
            name='LabValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('default_unit', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='Medication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('default_unit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='Rule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('attribute_key', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'Rule',
                'verbose_name_plural': 'Rules',
            },
        ),
        migrations.CreateModel(
            name='RuleAttributeDType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='RuleType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'Rule Type',
                'verbose_name_plural': 'Rule Types',
            },
        ),
        migrations.AddField(
            model_name='patientevent',
            name='last_update',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.CreateModel(
            name='Ruleset',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('rules', models.ManyToManyField(to='endoreg_db.rule')),
            ],
        ),
        migrations.AddField(
            model_name='rule',
            name='attribute_dtype',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.ruleattributedtype'),
        ),
        migrations.AddField(
            model_name='rule',
            name='rule_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.ruletype'),
        ),
        migrations.CreateModel(
            name='PatientMedication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('dosage', models.JSONField()),
                ('active', models.BooleanField(default=True)),
                ('medication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.medication')),
                ('unit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit')),
            ],
            options={
                'verbose_name': 'Patient Medication',
                'verbose_name_plural': 'Patient Medications',
            },
        ),
        migrations.CreateModel(
            name='PatientLabValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.FloatField(blank=True, null=True)),
                ('value_str', models.CharField(blank=True, max_length=255, null=True)),
                ('date', models.DateTimeField()),
                ('lab_value', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.labvalue')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
                ('unit', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='PatientDisease',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('last_update', models.DateTimeField(auto_now=True)),
                ('classification_choices', models.ManyToManyField(to='endoreg_db.diseaseclassificationchoice')),
                ('disease', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.disease')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
            ],
        ),
    ]
