# Generated by Django 4.2.10 on 2024-02-13 22:19

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Center',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Endoscope',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('sn', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'Endoscope',
                'verbose_name_plural': 'Endoscopes',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='EndoscopeType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'Endoscope Type',
                'verbose_name_plural': 'Endoscope Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='EndoscopyProcessor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('image_width', models.IntegerField()),
                ('image_height', models.IntegerField()),
                ('endoscope_image_x', models.IntegerField()),
                ('endoscope_image_y', models.IntegerField()),
                ('endoscope_image_width', models.IntegerField()),
                ('endoscope_image_height', models.IntegerField()),
                ('examination_date_x', models.IntegerField()),
                ('examination_date_y', models.IntegerField()),
                ('examination_date_width', models.IntegerField()),
                ('examination_date_height', models.IntegerField()),
                ('examination_time_x', models.IntegerField(blank=True, null=True)),
                ('examination_time_y', models.IntegerField(blank=True, null=True)),
                ('examination_time_width', models.IntegerField(blank=True, null=True)),
                ('examination_time_height', models.IntegerField(blank=True, null=True)),
                ('patient_first_name_x', models.IntegerField()),
                ('patient_first_name_y', models.IntegerField()),
                ('patient_first_name_width', models.IntegerField()),
                ('patient_first_name_height', models.IntegerField()),
                ('patient_last_name_x', models.IntegerField()),
                ('patient_last_name_y', models.IntegerField()),
                ('patient_last_name_width', models.IntegerField()),
                ('patient_last_name_height', models.IntegerField()),
                ('patient_dob_x', models.IntegerField()),
                ('patient_dob_y', models.IntegerField()),
                ('patient_dob_width', models.IntegerField()),
                ('patient_dob_height', models.IntegerField()),
                ('endoscope_type_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_type_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_type_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_type_height', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_height', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Examination',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('time', models.TimeField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Examination',
                'verbose_name_plural': 'Examinations',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ExaminationType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Examiner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=255)),
                ('last_name', models.CharField(max_length=255)),
                ('dob', models.DateField(blank=True, null=True, verbose_name='Date of Birth')),
                ('gender', models.CharField(blank=True, choices=[('Male', 'Male'), ('Female', 'Female'), ('Other', 'Other')], max_length=10, null=True)),
                ('email', models.EmailField(blank=True, max_length=255, null=True)),
                ('phone', models.CharField(blank=True, max_length=255, null=True)),
                ('is_real_person', models.BooleanField(default=True)),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Frame',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('frame_number', models.IntegerField()),
                ('image', models.ImageField(upload_to='frames')),
                ('suffix', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InformationSource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Label',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='LabelSet',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('version', models.IntegerField()),
                ('labels', models.ManyToManyField(related_name='labels', to='endoreg_db.label')),
            ],
        ),
        migrations.CreateModel(
            name='LabelType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='LegacyImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='legacy_images')),
                ('suffix', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='LegacyVideo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_hash', models.CharField(max_length=255, unique=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('suffix', models.CharField(max_length=255)),
                ('fps', models.FloatField()),
                ('duration', models.FloatField()),
                ('width', models.IntegerField()),
                ('height', models.IntegerField()),
                ('endoscope_image_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_height', models.IntegerField(blank=True, null=True)),
                ('frames_extracted', models.BooleanField(default=False)),
                ('meta', models.JSONField(blank=True, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to='legacy_videos')),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('endoscopy_processor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscopyprocessor')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ModelMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('version', models.CharField(max_length=255)),
                ('weights', models.FileField(upload_to='weights/')),
                ('description', models.TextField(blank=True, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('labelset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='models', to='endoreg_db.labelset')),
            ],
        ),
        migrations.CreateModel(
            name='ModelType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Patient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=255)),
                ('last_name', models.CharField(max_length=255)),
                ('dob', models.DateField(blank=True, null=True, verbose_name='Date of Birth')),
                ('gender', models.CharField(blank=True, choices=[('Male', 'Male'), ('Female', 'Female'), ('Other', 'Other')], max_length=10, null=True)),
                ('email', models.EmailField(blank=True, max_length=255, null=True)),
                ('phone', models.CharField(blank=True, max_length=255, null=True)),
                ('is_real_person', models.BooleanField(default=True)),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Profession',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Unit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('description', models.CharField(blank=True, max_length=100, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=10, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(blank=True, null=True, upload_to='raw_videos')),
                ('video_hash', models.CharField(max_length=255, unique=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('suffix', models.CharField(max_length=255)),
                ('fps', models.FloatField()),
                ('duration', models.FloatField()),
                ('width', models.IntegerField()),
                ('height', models.IntegerField()),
                ('endoscope_image_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_height', models.IntegerField(blank=True, null=True)),
                ('frames_extracted', models.BooleanField(default=False)),
                ('meta', models.JSONField(blank=True, null=True)),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('endoscopy_processor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscopyprocessor')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VideoPredictionMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('prediction_array', models.BinaryField(blank=True, null=True)),
                ('model_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.modelmeta')),
                ('video', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='video_prediction_meta', to='endoreg_db.video')),
            ],
            options={
                'abstract': False,
                'unique_together': {('model_meta', 'video')},
            },
        ),
        migrations.CreateModel(
            name='VideoImportMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_anonymized', models.BooleanField(default=False)),
                ('video_patient_data_detected', models.BooleanField(default=False)),
                ('outside_detected', models.BooleanField(default=False)),
                ('patient_data_removed', models.BooleanField(default=False)),
                ('outside_removed', models.BooleanField(default=False)),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('endoscope', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscope')),
                ('processor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscopyprocessor')),
            ],
        ),
        migrations.AddField(
            model_name='video',
            name='import_meta',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.videoimportmeta'),
        ),
        migrations.AddField(
            model_name='video',
            name='patient',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient'),
        ),
        migrations.CreateModel(
            name='ReportFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pdf', models.FileField(blank=True, null=True, upload_to='raw_report_pdfs')),
                ('pdf_hash', models.CharField(max_length=255, unique=True)),
                ('meta', models.JSONField(blank=True, null=True)),
                ('text', models.TextField(blank=True, null=True)),
                ('text_anonymized', models.TextField(blank=True, null=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('time', models.TimeField(blank=True, null=True)),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('examiner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.examiner')),
                ('patient', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
            ],
        ),
        migrations.CreateModel(
            name='PortalUserInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('works_in_endoscopy', models.BooleanField(blank=True, null=True)),
                ('profession', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.profession')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PatientExamination',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('examination', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.examination')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='patient_examinations', to='endoreg_db.patient')),
                ('report_file', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_examination', to='endoreg_db.reportfile')),
                ('video', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_examination', to='endoreg_db.video')),
            ],
            options={
                'verbose_name': 'Patient Examination',
                'verbose_name_plural': 'Patient Examinations',
                'ordering': ['patient', 'examination'],
            },
        ),
        migrations.AddField(
            model_name='modelmeta',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='models', to='endoreg_db.modeltype'),
        ),
        migrations.CreateModel(
            name='LegacyVideoPredictionMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('prediction_array', models.BinaryField(blank=True, null=True)),
                ('model_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.modelmeta')),
                ('video', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='video_prediction_meta', to='endoreg_db.legacyvideo')),
            ],
            options={
                'abstract': False,
                'unique_together': {('model_meta', 'video')},
            },
        ),
        migrations.AddField(
            model_name='legacyvideo',
            name='patient',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient'),
        ),
        migrations.CreateModel(
            name='LegacyLabelVideoSegment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_frame_number', models.IntegerField()),
                ('end_frame_number', models.IntegerField()),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
                ('prediction_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='video_segments', to='endoreg_db.legacyvideopredictionmeta')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.informationsource')),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.legacyvideo')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LegacyFrame',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('frame_number', models.IntegerField()),
                ('image', models.ImageField(blank=True, null=True, upload_to='legacy_frames')),
                ('suffix', models.CharField(max_length=255)),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='frames', to='endoreg_db.legacyvideo')),
            ],
        ),
        migrations.CreateModel(
            name='LegacyBinaryClassificationAnnotationTask',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_finished', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_finished', models.DateTimeField(blank=True, null=True)),
                ('image_path', models.CharField(blank=True, max_length=255, null=True)),
                ('labelstudio_project_id', models.IntegerField(blank=True, null=True)),
                ('labelstudio_task_id', models.IntegerField(blank=True, null=True)),
                ('image_type', models.CharField(default='legacy', max_length=255)),
                ('frame', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='binary_classification_annotation_tasks', to='endoreg_db.legacyframe')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LabelVideoSegment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_frame_number', models.IntegerField()),
                ('end_frame_number', models.IntegerField()),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
                ('prediction_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='video_segments', to='endoreg_db.videopredictionmeta')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.informationsource')),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.video')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='label',
            name='label_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='labels', to='endoreg_db.labeltype'),
        ),
        migrations.CreateModel(
            name='ImageClassificationPrediction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.BooleanField()),
                ('confidence', models.FloatField()),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.frame')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.label')),
                ('legacy_frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.legacyframe')),
                ('legacy_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.legacyimage')),
                ('model_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.modelmeta')),
            ],
        ),
        migrations.CreateModel(
            name='ImageClassificationAnnotation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.BooleanField()),
                ('annotator', models.CharField(max_length=255)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.frame')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.label')),
                ('legacy_frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.legacyframe')),
                ('legacy_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.legacyimage')),
            ],
        ),
        migrations.AddField(
            model_name='frame',
            name='video',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='frames', to='endoreg_db.video'),
        ),
        migrations.CreateModel(
            name='ExaminationTimeType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('examinations', models.ManyToManyField(blank=True, to='endoreg_db.examination')),
            ],
            options={
                'verbose_name': 'Examination Time Type',
                'verbose_name_plural': 'Examination Time Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ExaminationTime',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('start_time', models.TimeField(blank=True, null=True)),
                ('end_time', models.TimeField(blank=True, null=True)),
                ('time_types', models.ManyToManyField(blank=True, to='endoreg_db.examinationtimetype')),
            ],
            options={
                'verbose_name': 'Examination Time',
                'verbose_name_plural': 'Examination Times',
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='examination',
            name='examination_types',
            field=models.ManyToManyField(blank=True, to='endoreg_db.examinationtype'),
        ),
        migrations.CreateModel(
            name='BinaryClassificationAnnotationTask',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_finished', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_finished', models.DateTimeField(blank=True, null=True)),
                ('image_path', models.CharField(blank=True, max_length=255, null=True)),
                ('labelstudio_project_id', models.IntegerField(blank=True, null=True)),
                ('labelstudio_task_id', models.IntegerField(blank=True, null=True)),
                ('image_type', models.CharField(default='frame', max_length=255)),
                ('frame', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='binary_classification_annotation_tasks', to='endoreg_db.frame')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ActiveModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('model_meta', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.modelmeta')),
            ],
        ),
        migrations.AddIndex(
            model_name='legacyframe',
            index=models.Index(fields=['video', 'frame_number'], name='endoreg_db__video_i_e10f1c_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='legacyframe',
            unique_together={('video', 'frame_number')},
        ),
        migrations.AlterUniqueTogether(
            name='imageclassificationprediction',
            unique_together={('label', 'frame', 'model_meta')},
        ),
        migrations.AddIndex(
            model_name='frame',
            index=models.Index(fields=['video', 'frame_number'], name='endoreg_db__video_i_56cc44_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='frame',
            unique_together={('video', 'frame_number')},
        ),
    ]
